/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import alexiil.mods.load.Lib;
import alexiil.mods.load.ModLoadingListener;
import alexiil.mods.load.ProgressDisplayer;
import alexiil.mods.load.git.Commit;
import alexiil.mods.load.git.GitHubUser;
import alexiil.mods.load.git.Release;
import alexiil.mods.load.git.SiteRequester;
import com.google.common.eventbus.EventBus;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="betterloadingscreen", guiFactory="alexiil.mods.load.gui.ConfigGuiFactory", acceptableRemoteVersions="*")
public class BetterLoadingScreen {
    @Mod.Instance(value="betterloadingscreen")
    public static BetterLoadingScreen instance;
    private static List<GitHubUser> contributors;
    private static List<Commit> commits;
    private static List<Release> releases;
    private static Commit thisCommit;
    public static ModMetadata meta;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) throws IOException {
        ModLoadingListener thisListener = null;
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!(mod instanceof FMLModContainer)) continue;
            EventBus bus = null;
            try {
                Field f = FMLModContainer.class.getDeclaredField("eventBus");
                f.setAccessible(true);
                bus = (EventBus)f.get(mod);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (bus == null) continue;
            if (mod.getModId().equals("betterloadingscreen")) {
                thisListener = new ModLoadingListener(mod);
                bus.register((Object)thisListener);
                continue;
            }
            bus.register((Object)new ModLoadingListener(mod));
        }
        if (thisListener != null) {
            ModLoadingListener.doProgress(ModLoadingListener.State.CONSTRUCT, thisListener);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        FMLCommonHandler.instance().bus().register((Object)instance);
        meta = event.getModMetadata();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        System.out.println("ricardo milos");
    }

    @Mod.EventHandler
    public void inithmm(FMLStateEvent event) {
        System.out.println("bruh: " + event.toString());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void guiOpen(GuiOpenEvent event) throws IOException {
        if (event.gui != null && event.gui instanceof GuiMainMenu) {
            ProgressDisplayer.close();
        }
    }

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID == "betterloadingscreen") {
            ProgressDisplayer.cfg.save();
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.SERVER)
    public void serverAboutToStart(FMLServerAboutToStartEvent event) throws IOException {
        ProgressDisplayer.close();
    }

    public static String getCommitHash() {
        return "@COMMIT_HASH@";
    }

    public static int getBuildType() {
        return Lib.Mod.buildType();
    }

    public static void initSiteVersioning() {
        if (ProgressDisplayer.connectExternally) {
            String droneSite = "https://drone.io/github.com/AlexIIL/BetterLoadingScreen_1.7/files/VersionInfo/build/libs/version/";
            contributors = Collections.unmodifiableList(SiteRequester.getContributors(droneSite + "contributors.json"));
            if (contributors.size() == 0) {
                BetterLoadingScreen.meta.authorList.add("Could not connect to GitHub to fetch the rest...");
            }
            for (GitHubUser gitHubUser : contributors) {
                if ("AlexIIL".equals(gitHubUser.login)) continue;
                BetterLoadingScreen.meta.authorList.add(gitHubUser.login);
            }
            commits = SiteRequester.getCommits(droneSite + "commits.json");
            Collections.sort(commits, new Comparator<Commit>(){

                @Override
                public int compare(Commit c0, Commit c1) {
                    return c1.commit.committer.date.compareTo(c0.commit.committer.date);
                }
            });
            commits = Collections.unmodifiableList(commits);
            for (Commit commit : commits) {
                if (!BetterLoadingScreen.getCommitHash().equals(commit.sha)) continue;
                thisCommit = commit;
            }
            if (thisCommit == null && commits.size() > 0 && BetterLoadingScreen.getBuildType() == 2) {
                System.out.println("Didn't find my commit! This is unexpected, consider this a bug!");
                System.out.println("Commit Hash : \"" + BetterLoadingScreen.getCommitHash() + "\"");
            }
            releases = Collections.unmodifiableList(SiteRequester.getReleases(droneSite + "releases.json"));
        }
    }

    public static List<GitHubUser> getContributors() {
        if (contributors == null) {
            BetterLoadingScreen.initSiteVersioning();
        }
        return contributors;
    }

    public static List<Commit> getCommits() {
        if (contributors == null) {
            BetterLoadingScreen.initSiteVersioning();
        }
        return commits;
    }

    public static Commit getCurrentCommit() {
        if (contributors == null) {
            BetterLoadingScreen.initSiteVersioning();
        }
        return thisCommit;
    }

    public static List<Release> getReleases() {
        if (contributors == null) {
            BetterLoadingScreen.initSiteVersioning();
        }
        return releases;
    }

    static {
        contributors = null;
        commits = null;
        releases = null;
        thisCommit = null;
    }
}

