/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.json;

import alexiil.mods.load.BetterLoadingScreen;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ImgurTest {
    private static OkHttpClient httpClient;
    private static final String USER_AGENT = "BetterLoadingScreenMod";
    private static final String CLIENT_ID = "55141d737288505";

    public static String imgurUrlToApiUrl(String url) {
        if (url.indexOf("https") != -1) {
            return "https://api.imgur.com/3/album/" + url.substring(26);
        }
        return "https://api.imgur.com/3/album/" + url.substring(25);
    }

    public static List<String> fetchImgurGallery(String url) throws IOException {
        url = ImgurTest.imgurUrlToApiUrl(url);
        BetterLoadingScreen.log.trace("sendget func");
        final ArrayList<String> images = new ArrayList<String>();
        httpClient = new OkHttpClient.Builder().build();
        Request request = new Request.Builder().url(url).header("Authorization", "Client-ID 55141d737288505").header("User-Agent", USER_AGENT).build();
        httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                BetterLoadingScreen.log.error("An error has occurred " + e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                BetterLoadingScreen.log.debug("got a response, askip");
                try {
                    JSONObject data = new JSONObject(response.body().string());
                    JSONObject data2 = new JSONObject(data.get("data").toString());
                    JSONArray image_objs = data2.getJSONArray("images");
                    for (int i = 0; i < image_objs.length(); ++i) {
                        JSONObject image = image_objs.getJSONObject(i);
                        if (image.getBoolean("is_ad")) continue;
                        images.add(image.getString("link"));
                    }
                    BetterLoadingScreen.log.trace("Image list:\n" + images.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        return images;
    }
}

