/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.util.p2p;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.parts.p2p.PartP2PTunnel;
import com.projecturanus.betterp2p.network.P2PInfo;
import com.projecturanus.betterp2p.util.p2p.P2PStatus;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\n\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a6\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u000f*\u00020\u001b\u001a\u0016\u0010\u001c\u001a\u00020\u001d*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u001e\u001a\u00020\u000f\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\",\u0010\u0006\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\u0004\"\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"hasChannel", "", "Lappeng/parts/p2p/PartP2PTunnel;", "getHasChannel", "(Lappeng/parts/p2p/PartP2PTunnel;)Z", "value", "outputProperty", "getOutputProperty", "setOutputProperty", "(Lappeng/parts/p2p/PartP2PTunnel;Z)V", "linkP2P", "Lkotlin/Pair;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "inputIndex", "", "outputIndex", "status", "Lcom/projecturanus/betterp2p/util/p2p/P2PStatus;", "updateP2P", "tunnel", "frequency", "", "output", "name", "", "getEnumIndex", "Lnet/minecraftforge/common/util/ForgeDirection;", "getInfo", "Lcom/projecturanus/betterp2p/network/P2PInfo;", "index", "betterp2p"})
public final class P2PUtilKt {
    @Nullable
    public static final Pair<PartP2PTunnel<?>, PartP2PTunnel<?>> linkP2P(@NotNull EntityPlayer player, int inputIndex, int outputIndex, @NotNull P2PStatus status) {
        PartP2PTunnel originalInput;
        String string;
        IGrid grid;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        PartP2PTunnel<?> input = status.getListP2P().get(inputIndex);
        PartP2PTunnel<?> output = status.getListP2P().get(outputIndex);
        IGridNode iGridNode = input.getGridNode();
        IGrid iGrid = grid = iGridNode == null ? null : iGridNode.getGrid();
        if (!(!(grid instanceof ISecurityGrid) || ((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD) && ((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.SECURITY))) {
            return null;
        }
        if (!Intrinsics.areEqual(input.getClass(), output.getClass())) {
            return null;
        }
        if (Intrinsics.areEqual(input, output)) {
            return null;
        }
        long frequency = input.getFrequency();
        P2PCache cache = input.getProxy().getP2P();
        if ((int)input.getFrequency() == 0 || input.isOutput()) {
            frequency = System.currentTimeMillis();
            string = input.getCustomName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.customName");
            P2PUtilKt.updateP2P(input, frequency, false, player, string);
        }
        if (cache.getInput(frequency) != null && !Intrinsics.areEqual((Object)(originalInput = cache.getInput(frequency)), input)) {
            Intrinsics.checkNotNullExpressionValue((Object)originalInput, (String)"originalInput");
            String string2 = input.getCustomName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"input.customName");
            P2PUtilKt.updateP2P(originalInput, frequency, true, player, string2);
        }
        string = input.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.customName");
        PartP2PTunnel<?> partP2PTunnel = P2PUtilKt.updateP2P(input, frequency, false, player, string);
        string = input.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.customName");
        return TuplesKt.to(partP2PTunnel, P2PUtilKt.updateP2P(output, frequency, true, player, string));
    }

    @NotNull
    public static final PartP2PTunnel<?> updateP2P(@NotNull PartP2PTunnel<?> tunnel, long frequency, boolean output, @NotNull EntityPlayer player, @NotNull String name) {
        ForgeDirection forgeDirection;
        Intrinsics.checkNotNullParameter(tunnel, (String)"tunnel");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ForgeDirection side = tunnel.getSide();
        tunnel.getHost().removePart(side, true);
        NBTTagCompound data = new NBTTagCompound();
        ItemStack itemStack = tunnel.getItemStack(PartItemStack.Wrench);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"tunnel.getItemStack(PartItemStack.Wrench)");
        ItemStack p2pItem = itemStack;
        String string = p2pItem.func_77977_a();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"p2pItem.unlocalizedName");
        String type = string;
        P2PUtilKt.setOutputProperty(tunnel, output);
        tunnel.setCustomName(name);
        p2pItem.func_77955_b(data);
        data.func_74772_a("freq", frequency);
        ItemStack newType = ItemStack.func_77949_a((NBTTagCompound)data);
        IPartHost iPartHost = tunnel.getHost();
        ForgeDirection forgeDirection2 = forgeDirection = iPartHost == null ? null : iPartHost.addPart(newType, side, player);
        if (forgeDirection == null) {
            throw new RuntimeException("Cannot bind");
        }
        ForgeDirection dir = forgeDirection;
        iPartHost = tunnel.getHost().getPart(dir);
        Intrinsics.checkNotNullExpressionValue((Object)iPartHost, (String)"tunnel.host.getPart(dir)");
        IPartHost newBus = iPartHost;
        if (newBus instanceof PartP2PTunnel) {
            P2PUtilKt.setOutputProperty((PartP2PTunnel)newBus, output);
            try {
                P2PCache p2p = ((PartP2PTunnel)newBus).getProxy().getP2P();
                p2p.updateFreq((PartP2PTunnel)newBus, frequency);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            ((PartP2PTunnel)newBus).onTunnelNetworkChange();
            return (PartP2PTunnel)newBus;
        }
        throw new RuntimeException("Cannot bind");
    }

    public static final boolean getOutputProperty(@NotNull PartP2PTunnel<?> $this$outputProperty) {
        Intrinsics.checkNotNullParameter($this$outputProperty, (String)"<this>");
        return $this$outputProperty.isOutput();
    }

    public static final void setOutputProperty(@NotNull PartP2PTunnel<?> $this$outputProperty, boolean value) {
        Intrinsics.checkNotNullParameter($this$outputProperty, (String)"<this>");
        Field field = PartP2PTunnel.class.getDeclaredField("output");
        field.setAccessible(true);
        field.setBoolean($this$outputProperty, value);
    }

    public static final int getEnumIndex(@NotNull ForgeDirection $this$getEnumIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getEnumIndex, (String)"<this>");
        if ($this$getEnumIndex == ForgeDirection.WEST) {
            return 5;
        }
        if ($this$getEnumIndex == ForgeDirection.EAST) {
            return 4;
        }
        return $this$getEnumIndex.ordinal();
    }

    public static final boolean getHasChannel(@NotNull PartP2PTunnel<?> $this$hasChannel) {
        Intrinsics.checkNotNullParameter($this$hasChannel, (String)"<this>");
        return $this$hasChannel.isPowered() && $this$hasChannel.isActive();
    }

    @NotNull
    public static final P2PInfo getInfo(@NotNull PartP2PTunnel<?> $this$getInfo, int index) {
        Intrinsics.checkNotNullParameter($this$getInfo, (String)"<this>");
        long l = $this$getInfo.getFrequency();
        int n = $this$getInfo.getLocation().x;
        int n2 = $this$getInfo.getLocation().y;
        int n3 = $this$getInfo.getLocation().z;
        int n4 = $this$getInfo.getLocation().getDimension();
        ForgeDirection forgeDirection = $this$getInfo.getSide();
        Intrinsics.checkNotNullExpressionValue((Object)forgeDirection, (String)"side");
        Object object = EnumFacing.func_82600_a((int)P2PUtilKt.getEnumIndex(forgeDirection));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFront(side.getEnumIndex())");
        EnumFacing enumFacing = object;
        object = $this$getInfo.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"customName");
        return new P2PInfo(index, l, n, n2, n3, n4, enumFacing, (String)object, $this$getInfo.isOutput(), P2PUtilKt.getHasChannel($this$getInfo));
    }
}

