/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.util;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalCoord;
import appeng.parts.AEBasePart;
import appeng.parts.ICableBusContainer;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.networking.TileCableBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a@\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017\u001a6\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\"\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"facingPosX", "", "Lappeng/parts/AEBasePart;", "getFacingPosX", "(Lappeng/parts/AEBasePart;)Ljava/lang/Integer;", "facingPosY", "getFacingPosY", "facingPosZ", "getFacingPosZ", "facingTile", "Lnet/minecraft/tileentity/TileEntity;", "getFacingTile", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/tileentity/TileEntity;", "getCableBus", "Lappeng/parts/ICableBusContainer;", "w", "Lnet/minecraft/world/IBlockAccess;", "posX", "posY", "posZ", "getPart", "Lappeng/api/parts/IPart;", "hitX", "", "hitY", "hitZ", "listTargetGridP2P", "", "Lappeng/parts/p2p/PartP2PTunnel;", "grid", "Lappeng/api/networking/IGrid;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "clazz", "Ljava/lang/Class;", "betterp2p"})
public final class CableBusUtilKt {
    @Nullable
    public static final ICableBusContainer getCableBus(@NotNull IBlockAccess w, int posX, int posY, int posZ) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        TileEntity te = w.func_147438_o(posX, posY, posZ);
        ICableBusContainer out = null;
        if (te instanceof TileCableBus) {
            out = (ICableBusContainer)((TileCableBus)te).getCableBus();
        }
        return out;
    }

    @Nullable
    public static final IPart getPart(@NotNull IBlockAccess w, int posX, int posY, int posZ, float hitX, float hitY, float hitZ) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Vec3 vec = Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ);
        TileEntity te = w.func_147438_o(posX, posY, posZ);
        if (!(te instanceof IPartHost)) {
            return null;
        }
        SelectedPart p = ((IPartHost)te).selectPart(vec);
        SelectedPart selectedPart = p;
        return selectedPart == null ? null : selectedPart.part;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PartP2PTunnel<?>> listTargetGridP2P(@Nullable IGrid grid, @NotNull EntityPlayer player, @NotNull Class<? extends PartP2PTunnel<?>> clazz) {
        List list;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (grid instanceof ISecurityGrid && !((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD)) {
            return CollectionsKt.emptyList();
        }
        IGrid iGrid = grid;
        if (iGrid == null) {
            list = null;
        } else {
            IMachineSet iMachineSet = iGrid.getMachines(clazz);
            if (iMachineSet == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)iMachineSet;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IGridNode iGridNode = (IGridNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IGridHost iGridHost = it.getMachine();
                    if (iGridHost == null) {
                        throw new NullPointerException("null cannot be cast to non-null type appeng.parts.p2p.PartP2PTunnel<*>");
                    }
                    PartP2PTunnel partP2PTunnel = (PartP2PTunnel)iGridHost;
                    collection.add(partP2PTunnel);
                }
                List list2 = (List)destination$iv$iv;
                list = CollectionsKt.toList((Iterable)list2);
            }
        }
        List list3 = list;
        return list3 == null ? CollectionsKt.emptyList() : list3;
    }

    @Nullable
    public static final Integer getFacingPosX(@NotNull AEBasePart $this$facingPosX) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosX, (String)"<this>");
        IPartHost iPartHost = $this$facingPosX.getHost();
        if (iPartHost == null) {
            n = null;
        } else {
            DimensionalCoord dimensionalCoord = iPartHost.getLocation();
            if (dimensionalCoord == null) {
                n = null;
            } else {
                int n2 = dimensionalCoord.x;
                ForgeDirection forgeDirection = $this$facingPosX.getSide();
                Integer n3 = forgeDirection == null ? null : Integer.valueOf(forgeDirection.offsetX);
                n = n2 & (n3 == null ? EnumFacing.UP.func_82601_c() : n3.intValue());
            }
        }
        return n;
    }

    @Nullable
    public static final Integer getFacingPosY(@NotNull AEBasePart $this$facingPosY) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosY, (String)"<this>");
        IPartHost iPartHost = $this$facingPosY.getHost();
        if (iPartHost == null) {
            n = null;
        } else {
            DimensionalCoord dimensionalCoord = iPartHost.getLocation();
            if (dimensionalCoord == null) {
                n = null;
            } else {
                int n2 = dimensionalCoord.y;
                ForgeDirection forgeDirection = $this$facingPosY.getSide();
                Integer n3 = forgeDirection == null ? null : Integer.valueOf(forgeDirection.offsetY);
                n = n2 & (n3 == null ? EnumFacing.UP.func_96559_d() : n3.intValue());
            }
        }
        return n;
    }

    @Nullable
    public static final Integer getFacingPosZ(@NotNull AEBasePart $this$facingPosZ) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosZ, (String)"<this>");
        IPartHost iPartHost = $this$facingPosZ.getHost();
        if (iPartHost == null) {
            n = null;
        } else {
            DimensionalCoord dimensionalCoord = iPartHost.getLocation();
            if (dimensionalCoord == null) {
                n = null;
            } else {
                int n2 = dimensionalCoord.z;
                ForgeDirection forgeDirection = $this$facingPosZ.getSide();
                Integer n3 = forgeDirection == null ? null : Integer.valueOf(forgeDirection.offsetZ);
                n = n2 & (n3 == null ? EnumFacing.UP.func_82599_e() : n3.intValue());
            }
        }
        return n;
    }

    @Nullable
    public static final TileEntity getFacingTile(@NotNull AEBasePart $this$facingTile) {
        Intrinsics.checkNotNullParameter((Object)$this$facingTile, (String)"<this>");
        if ($this$facingTile.getHost().isInWorld()) {
            Integer posX = CableBusUtilKt.getFacingPosX($this$facingTile);
            Integer posY = CableBusUtilKt.getFacingPosY($this$facingTile);
            Integer posZ = CableBusUtilKt.getFacingPosZ($this$facingTile);
            if (posX != null && posY != null && posZ != null) {
                World world;
                DimensionalCoord dimensionalCoord;
                IPartHost iPartHost = $this$facingTile.getHost();
                return iPartHost == null ? null : ((dimensionalCoord = iPartHost.getLocation()) == null ? null : ((world = dimensionalCoord.getWorld()) == null ? null : world.func_147438_o(posX.intValue(), posY.intValue(), posZ.intValue())));
            }
        }
        return null;
    }
}

