/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary;

import binnie.core.Mods;
import binnie.core.genetics.BeeModifierLogic;
import binnie.core.genetics.EnumBeeBooleanModifier;
import binnie.core.genetics.EnumBeeModifier;
import binnie.core.util.I18N;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum EnumHiveFrame implements IHiveFrame,
IBeeModifier
{
    Cocoa,
    Cage,
    Soul,
    Clay,
    Debug;

    protected Item item;
    protected int maxDamage = 240;
    protected BeeModifierLogic logic = new BeeModifierLogic();

    public static void init() {
        EnumHiveFrame.Cocoa.logic.setModifier(EnumBeeModifier.LIFESPAN, 0.75f, 0.25f);
        EnumHiveFrame.Cocoa.logic.setModifier(EnumBeeModifier.PRODUCTION, 1.5f, 5.0f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.TERRITORY, 0.5f, 0.1f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.LIFESPAN, 0.75f, 0.5f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.PRODUCTION, 0.75f, 0.5f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.MUTATION, 1.5f, 5.0f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.LIFESPAN, 0.75f, 0.5f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.PRODUCTION, 0.25f, 0.1f);
        Soul.setMaxDamage(80);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.LIFESPAN, 1.5f, 5.0f);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.MUTATION, 0.5f, 0.2f);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.PRODUCTION, 0.75f, 0.2f);
        EnumHiveFrame.Debug.logic.setModifier(EnumBeeModifier.LIFESPAN, 1.0E-4f, 1.0E-4f);
        GameRegistry.addRecipe((ItemStack)new ItemStack(EnumHiveFrame.Cocoa.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), Mods.forestry.stack("frameImpregnated"), Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(EnumHiveFrame.Cage.item), (Object[])new Object[]{Mods.forestry.stack("frameImpregnated"), Blocks.field_150411_aY});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(EnumHiveFrame.Soul.item), (Object[])new Object[]{Mods.forestry.stack("frameImpregnated"), Blocks.field_150425_aM});
        GameRegistry.addRecipe((ItemStack)new ItemStack(EnumHiveFrame.Clay.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), Mods.forestry.stack("frameImpregnated"), Character.valueOf('c'), Items.field_151119_aD});
    }

    public void setMaxDamage(int damage) {
        this.maxDamage = damage;
    }

    public ItemStack frameUsed(IBeeHousing house, ItemStack frame, IBee queen, int wear) {
        frame.func_77964_b(frame.func_77960_j() + wear);
        if (frame.func_77960_j() >= frame.func_77958_k()) {
            return null;
        }
        return frame;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.TERRITORY, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.MUTATION, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.LIFESPAN, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.PRODUCTION, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.FLOWERING, currentModifier);
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.GENETIC_DECAY, currentModifier);
    }

    public boolean isSealed() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SEALED);
    }

    public boolean isSelfLighted() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SELF_LIGHTED);
    }

    public boolean isSunlightSimulated() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SUNLIGHT_STIMULATED);
    }

    public boolean isHellish() {
        return this.logic.getModifier(EnumBeeBooleanModifier.HELLISH);
    }

    public String getName() {
        return I18N.localise("extrabees.item.frame." + this.toString().toLowerCase());
    }

    public IBeeModifier getBeeModifier() {
        return this;
    }
}

