/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IColourMix;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerColor;
import binnie.botany.api.IFlowerGenome;
import binnie.botany.api.IFlowerMutation;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.FlowerGenome;
import binnie.core.util.I18N;
import binnie.genetics.genetics.AlleleHelper;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class Flower
extends Individual
implements IFlower {
    public IFlowerGenome genome;
    public IFlowerGenome mate;
    protected int age;
    protected boolean wilting;
    protected boolean flowered;

    public Flower(NBTTagCompound nbttagcompound) {
        this.age = 0;
        this.wilting = false;
        this.readFromNBT(nbttagcompound);
    }

    public Flower(IFlowerGenome genome, int age) {
        this.genome = genome;
        this.age = age;
        this.wilting = false;
        this.flowered = age > 0;
    }

    public String getDisplayName() {
        IAlleleFlowerSpecies species = this.getGenome().getPrimary();
        String name = "";
        if (species != null) {
            name = name + species.getName();
        }
        return name;
    }

    public void addTooltip(List<String> list) {
        IAlleleFlowerSpecies primary = this.genome.getPrimary();
        IAlleleFlowerSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumFlowerChromosome.SPECIES)) {
            list.add(EnumChatFormatting.BLUE + I18N.localise("botany.item.tooltip.hybrid", primary.getName(), secondary.getName()));
        }
        list.add(EnumChatFormatting.GRAY + I18N.localise("botany.item.tooltip.age", this.getAge()));
        list.add(EnumChatFormatting.GREEN + I18N.localise("botany.item.tooltip.temperature", AlleleHelper.toDisplay(primary.getTemperature()), AlleleHelper.toDisplay(this.genome.getToleranceTemperature())));
        list.add(EnumChatFormatting.GREEN + I18N.localise("botany.item.tooltip.moisture", AlleleHelper.toDisplay(primary.getMoisture()), AlleleHelper.toDisplay(this.genome.getToleranceMoisture())));
        list.add(EnumChatFormatting.GREEN + I18N.localise("botany.item.tooltip.pH", AlleleHelper.toDisplay(primary.getHumidity()), AlleleHelper.toDisplay(this.genome.getTolerancePH())));
        list.add(EnumChatFormatting.GRAY + I18N.localise("botany.item.tooltip.fertility", this.genome.getFertility()));
    }

    public String getIdent() {
        return this.getGenome().getPrimary().getUID();
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound == null) {
            this.genome = BotanyCore.getFlowerRoot().templateAsGenome(BotanyCore.getFlowerRoot().getDefaultTemplate());
            return;
        }
        this.age = nbttagcompound.func_74762_e("Age");
        this.wilting = nbttagcompound.func_74767_n("Wilt");
        this.flowered = nbttagcompound.func_74767_n("Flowered");
        if (nbttagcompound.func_74764_b("Genome")) {
            this.genome = new FlowerGenome(nbttagcompound.func_74775_l("Genome"));
        }
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new FlowerGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound NBTmachine;
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Age", this.age);
        nbttagcompound.func_74757_a("Wilt", this.wilting);
        nbttagcompound.func_74757_a("Flowered", this.flowered);
        if (this.genome != null) {
            NBTmachine = new NBTTagCompound();
            this.genome.writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Genome", (NBTBase)NBTmachine);
        }
        if (this.mate != null) {
            NBTmachine = new NBTTagCompound();
            this.mate.writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Mate", (NBTBase)NBTmachine);
        }
    }

    public int getMetadata() {
        return 0;
    }

    @Override
    public IFlowerGenome getGenome() {
        return this.genome;
    }

    @Override
    public void mate(IFlower other) {
        this.mate = new FlowerGenome(other.getGenome().getChromosomes());
    }

    @Override
    public IFlowerGenome getMate() {
        return this.mate;
    }

    public IFlower copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Flower(nbttagcompound);
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public void age() {
        if (this.age < 15) {
            ++this.age;
        }
    }

    @Override
    public int getMaxAge() {
        return this.getGenome().getLifespan();
    }

    @Override
    public boolean isWilted() {
        return this.wilting;
    }

    @Override
    public void setWilted(boolean value) {
        this.wilting = value;
    }

    @Override
    public boolean hasFlowered() {
        return this.flowered;
    }

    @Override
    public void setFlowered(boolean value) {
        this.flowered = value;
    }

    @Override
    public void removeMate() {
        this.mate = null;
    }

    @Override
    public IFlower getOffspring(World world) {
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.mutateSpecies(world, this.genome, this.mate);
        IChromosome[] parent2 = this.mutateSpecies(world, this.mate, this.genome);
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome((Random)world.field_73012_v, (IChromosome)parent1[i], (IChromosome)parent2[i]);
        }
        return new Flower(new FlowerGenome(chromosomes), 0);
    }

    private IChromosome[] mutateSpecies(World world, IFlowerGenome genomeOne, IFlowerGenome genomeTwo) {
        IFlowerGenome genome2;
        IFlowerGenome genome0;
        IAllele allele2;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele2 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome2 = genomeTwo;
        } else {
            allele0 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele2 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome2 = genomeOne;
        }
        IFlowerColor colour1 = genome0.getPrimaryColor();
        IFlowerColor colour2 = genome2.getPrimaryColor();
        if (colour1 != colour2) {
            for (IColourMix mutation : BotanyCore.getFlowerRoot().getColourMixes(true)) {
                if (!mutation.isMutation(colour1, colour2) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parent1[EnumFlowerChromosome.PRIMARY.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        if ((colour1 = genome0.getSecondaryColor()) != (colour2 = genome2.getSecondaryColor())) {
            for (IColourMix mutation : BotanyCore.getFlowerRoot().getColourMixes(true)) {
                if (!mutation.isMutation(colour1, colour2) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parent1[EnumFlowerChromosome.SECONDARY.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        if ((colour1 = genome0.getStemColor()) != (colour2 = genome2.getStemColor())) {
            for (IColourMix mutation : BotanyCore.getFlowerRoot().getColourMixes(true)) {
                if (!mutation.isMutation(colour1, colour2) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parent1[EnumFlowerChromosome.STEM.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        IChromosome[] template = null;
        for (IFlowerMutation mutation2 : BotanyCore.getFlowerRoot().getMutations(true)) {
            float chance = mutation2.getChance(allele0, allele2, genome0, genome2);
            if (!(chance > 0.0f) || !(world.field_73012_v.nextFloat() * 100.0f < chance) || template != null) continue;
            template = BotanyCore.getFlowerRoot().templateAsChromosomes(mutation2.getTemplate());
        }
        if (template != null) {
            parent1 = template;
        }
        return parent1;
    }
}

