/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.Binnie;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.IFluidType;
import binnie.core.util.I18N;
import binnie.genetics.Genetics;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public enum GeneticLiquid implements IFluidType
{
    GrowthMedium("growthMedium", 15460533),
    Bacteria("bacteria", 14203521),
    BacteriaPoly("bacteriaPoly", 11443396),
    RawDNA("dna.raw", 15089129),
    BacteriaVector("bacteriaVector", 15960958);

    protected String name;
    protected String ident;
    protected IIcon icon;
    protected int color;
    protected float transparency;

    private GeneticLiquid(String name, int color) {
        this.name = name;
        this.ident = name;
        this.color = color;
        this.transparency = 1.0f;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcon(IIconRegister register) {
        this.icon = Genetics.proxy.getIcon(register, "liquids/" + this.ident);
    }

    @Override
    public String getName() {
        return I18N.localise("fluid.binnie." + this.name);
    }

    @Override
    public String getIdentifier() {
        return "binnie." + this.ident;
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public int getContainerColor() {
        return this.color;
    }

    @Override
    public FluidStack get(int amount) {
        return Binnie.Liquid.getLiquidStack(this.getIdentifier(), amount);
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public boolean canPlaceIn(FluidContainer container) {
        return this == GrowthMedium || container == FluidContainer.Cylinder;
    }

    @Override
    public boolean showInCreative(FluidContainer container) {
        return container == FluidContainer.Cylinder;
    }
}

