/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.extrabees.genetics.requirements.DummyMutationCondition;
import binnie.extrabees.genetics.requirements.DummyMutationConditionGroupPersons;
import binnie.extrabees.genetics.requirements.IMutationRequirement;
import binnie.extrabees.genetics.requirements.RequirementGroupOfPersons;
import binnie.extrabees.genetics.requirements.RequirementPerson;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.BeeMutation;
import java.util.ArrayList;
import java.util.List;

public class ExtraBeeMutation
extends BeeMutation
implements IBeeMutationCustom {
    public static List<IMutation> mutations = new ArrayList<IMutation>();
    private List<IMutationRequirement> requirements = new ArrayList<IMutationRequirement>();

    public ExtraBeeMutation(IAlleleBeeSpecies bee0, IAlleleBeeSpecies bee1, IAllele[] result, int chance) {
        super(bee0, bee1, result, chance);
        mutations.add((IMutation)this);
    }

    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    public float getChance(IBeeHousing housing, IAlleleBeeSpecies allele0, IAlleleBeeSpecies allele1, IBeeGenome genome0, IBeeGenome genome1) {
        for (IMutationRequirement requirement : this.requirements) {
            if (requirement.fufilled(housing, (IAllele)allele0, (IAllele)allele1, (IGenome)genome0, (IGenome)genome1)) continue;
            return 0.0f;
        }
        return super.getChance(housing, allele0, allele1, genome0, genome1);
    }

    public void restrictPerson(String nickname) {
        RequirementPerson requirement = new RequirementPerson(nickname);
        this.requirements.add(requirement);
        this.addMutationCondition(new DummyMutationCondition(requirement));
    }

    public void restrictedByGroupOfPersons(String[] nicknames) {
        RequirementGroupOfPersons requirement = new RequirementGroupOfPersons(nicknames);
        this.requirements.add(requirement);
        this.addMutationCondition(new DummyMutationConditionGroupPersons(requirement));
    }
}

