/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.nei.NEIUtils;
import binnie.core.nei.PositionedFluidTank;
import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.item.GeneticsItems;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.api.apiculture.EnumBeeType;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class GenepoolRecipeHandler
extends RecipeHandlerBase {
    private static final List<GenepoolRecipe> recipes = new ArrayList<GenepoolRecipe>();

    @Override
    public void prepare() {
        if (BinnieCore.isApicultureActive()) {
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("beeDroneGE", 1, Short.MAX_VALUE)));
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("beePrincessGE", 1, Short.MAX_VALUE)));
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("beeQueenGE", 1, Short.MAX_VALUE)));
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("beeLarvaeGE", 1, Short.MAX_VALUE)));
        }
        if (BinnieCore.isArboricultureActive()) {
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("sapling", 1, Short.MAX_VALUE)));
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("pollenFertile", 1, Short.MAX_VALUE)));
        }
        if (BinnieCore.isLepidopteryActive()) {
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("butterflyGE", 1, Short.MAX_VALUE)));
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("caterpillarGE", 1, Short.MAX_VALUE)));
            recipes.add(new GenepoolRecipe(Mods.forestry.stack("serumGE", 1, Short.MAX_VALUE)));
        }
        if (BinnieCore.isBotanyActive()) {
            recipes.add(new GenepoolRecipe(new ItemStack((Item)Botany.flowerItem, 1, Short.MAX_VALUE)));
            recipes.add(new GenepoolRecipe(new ItemStack(Botany.seed, 1, Short.MAX_VALUE)));
            recipes.add(new GenepoolRecipe(new ItemStack(Botany.pollen, 1, Short.MAX_VALUE)));
        }
    }

    public String getOverlayIdentifier() {
        return "genetics.genepool";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/genepool.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.machine.labMachine.genepool");
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 38, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)74);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(75, 38, 176, 0, 24, 17, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (GenepoolRecipe recipe : recipes) {
            this.arecipes.add(new CachedGenepoolRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        if (NEIUtils.areFluidsSameType(GeneticLiquid.RawDNA.get(0), result)) {
            this.loadAllRecipes();
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)GeneticsItems.Enzyme.get(1), (ItemStack)ingredient)) {
            this.loadAllRecipes();
        } else {
            for (GenepoolRecipe recipe : recipes) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
                this.arecipes.add(new CachedGenepoolRecipe(recipe));
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (NEIUtils.areFluidsSameType(Binnie.Liquid.getLiquidStack("bioethanol", 0), ingredient)) {
            this.loadAllRecipes();
        }
    }

    public class CachedGenepoolRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedFluidTank> tanks = new ArrayList<PositionedFluidTank>();
        public List<PositionedStack> ingredients = new ArrayList<PositionedStack>();
        public PositionedStack input;
        public PositionedStack enzyme;

        public CachedGenepoolRecipe(GenepoolRecipe recipe) {
            if (recipe.getInput() != null) {
                this.tanks.add(new PositionedFluidTank(recipe.getEthanol(), 100, new Rectangle(38, 6, 16, 58)));
                this.tanks.add(new PositionedFluidTank(recipe.getRawDNA(), 100, new Rectangle(119, 6, 16, 58)));
                this.enzyme = new PositionedStack((Object)recipe.getEnzyme(), 58, 6);
                this.input = new PositionedStack((Object)recipe.getInput(), 78, 6);
                this.ingredients.add(this.enzyme);
                this.ingredients.add(this.input);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(GenepoolRecipeHandler.this.cycleticks / 40, this.ingredients);
        }

        @Override
        public List<PositionedFluidTank> getFluidTanks() {
            return this.tanks;
        }

        public PositionedStack getResult() {
            return null;
        }
    }

    private static class GenepoolRecipe {
        private final ItemStack inputStack;

        public GenepoolRecipe(ItemStack inputStack) {
            this.inputStack = inputStack;
        }

        public FluidStack getRawDNA() {
            int amount;
            EnumBeeType type = Binnie.Genetics.getBeeRoot().getType(this.inputStack);
            switch (type) {
                case QUEEN: {
                    amount = 50;
                    break;
                }
                case PRINCESS: {
                    amount = 30;
                    break;
                }
                default: {
                    amount = 10;
                }
            }
            return GeneticLiquid.RawDNA.get(amount);
        }

        public ItemStack getEnzyme() {
            return GeneticsItems.Enzyme.get(1);
        }

        public FluidStack getEthanol() {
            return Binnie.Liquid.getLiquidStack("bioethanol", (int)((double)this.getRawDNA().amount * 1.2));
        }

        public ItemStack getInput() {
            return this.inputStack;
        }
    }
}

