/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.events;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.events.Event;

public abstract class EventHandler<E extends Event> {
    Class<E> eventClass;
    Origin origin;
    IWidget relative;

    public EventHandler(Class<E> eventClass) {
        this.eventClass = eventClass;
        this.origin = Origin.Any;
    }

    public EventHandler setOrigin(Origin origin, IWidget relative) {
        this.origin = origin;
        this.relative = relative;
        return this;
    }

    public abstract void onEvent(E var1);

    public boolean handles(Event e) {
        return this.eventClass.isInstance(e) && this.origin.isOrigin(e.getOrigin(), this.relative);
    }

    public static enum Origin {
        Any,
        Self,
        Parent,
        DirectChild;


        public boolean isOrigin(IWidget origin, IWidget test) {
            boolean bl;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case Any: {
                    bl = true;
                    break;
                }
                case DirectChild: {
                    bl = test.getWidgets().contains(origin);
                    break;
                }
                case Parent: {
                    if (test.getParent() == origin) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case Self: {
                    bl = test == origin;
                }
            }
            return bl;
        }
    }
}

