/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.ITooltipHelp;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.TopLevelWidget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.ContainerCraftGUI;
import binnie.core.craftgui.minecraft.GuiCraftGUI;
import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.craftgui.minecraft.MinecraftTooltip;
import binnie.core.craftgui.minecraft.WindowInventory;
import binnie.core.craftgui.minecraft.control.ControlHelp;
import binnie.core.craftgui.minecraft.control.ControlInfo;
import binnie.core.craftgui.minecraft.control.ControlPowerSystem;
import binnie.core.craftgui.minecraft.control.ControlSlot;
import binnie.core.craftgui.minecraft.control.ControlSlotBase;
import binnie.core.craftgui.minecraft.control.ControlUser;
import binnie.core.craftgui.minecraft.control.EnumHighlighting;
import binnie.core.craftgui.renderer.Renderer;
import binnie.core.craftgui.resource.StyleSheetManager;
import binnie.core.craftgui.resource.Texture;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.craftgui.resource.minecraft.StandardTexture;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.PowerSystem;
import binnie.core.nei.NEIHook;
import binnie.core.network.packet.MessageCraftGUI;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceType;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Deque;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class Window
extends TopLevelWidget
implements INetwork.RecieveGuiNBT {
    protected float titleButtonLeft;
    protected float titleButtonRight;
    private GuiCraftGUI gui;
    private final ContainerCraftGUI container;
    private final WindowInventory windowInventory;
    private ControlText title;
    private StandardTexture bgText1;
    private StandardTexture bgText2;
    private boolean hasBeenInitialised;
    private EntityPlayer player;
    private IInventory entityInventory;
    private final Side side;

    public Window(float width, float height, EntityPlayer player, IInventory inventory, Side side) {
        this.side = side;
        this.titleButtonLeft = 8.0f;
        this.titleButtonRight = 8.0f;
        this.bgText1 = null;
        this.bgText2 = null;
        this.hasBeenInitialised = false;
        this.setInventories(player, inventory);
        this.container = new ContainerCraftGUI(this);
        this.windowInventory = new WindowInventory(this);
        if (side == Side.SERVER) {
            return;
        }
        this.setSize(new IPoint(width, height));
        this.gui = new GuiCraftGUI(this);
        for (EnumHighlighting h : EnumHighlighting.values()) {
            ControlSlot.highlighting.put(h, new ArrayList());
        }
        CraftGUI.render = new Renderer(this.gui);
        CraftGUI.render.stylesheet(StyleSheetManager.getDefault());
        this.titleButtonLeft = -14.0f;
        if (this.showHelpButton()) {
            ControlHelp controlHelp = new ControlHelp(this, this.titleButtonLeft += 22.0f, 8.0f);
        }
        if (this.showInfoButton() != null) {
            ControlInfo controlInfo = new ControlInfo(this, this.titleButtonLeft += 22.0f, 8.0f, this.showInfoButton());
        }
        this.addSelfEventHandler((EventHandler)new EventWidget.ChangeSize.Handler(){

            @Override
            public void onEvent(EventWidget.ChangeSize event) {
                if (Window.this.isClient() && Window.this.getGui() != null) {
                    Window.this.getGui().resize(Window.this.getSize());
                    if (Window.this.title != null) {
                        Window.this.title.setSize(new IPoint(Window.this.w(), Window.this.title.h()));
                    }
                }
            }
        });
    }

    public static <T extends Window> T get(IWidget widget) {
        return (T)((Window)widget.getSuperParent());
    }

    public void getTooltip(Tooltip tooltip) {
        Deque<IWidget> queue = this.calculateMousedOverWidgets();
        while (!queue.isEmpty()) {
            IWidget widget = queue.removeFirst();
            if (!widget.isEnabled() || !widget.isVisible() || !widget.calculateIsMouseOver()) continue;
            if (NEIHook.enabled && widget instanceof ControlSlotBase) {
                return;
            }
            if (widget instanceof ITooltip) {
                ((ITooltip)((Object)widget)).getTooltip(tooltip);
                if (tooltip.exists()) {
                    return;
                }
            }
            if (!widget.hasAttribute(WidgetAttribute.BLOCK_TOOLTIP)) continue;
            return;
        }
    }

    public void getHelpTooltip(MinecraftTooltip tooltip) {
        Deque<IWidget> queue = this.calculateMousedOverWidgets();
        while (!queue.isEmpty()) {
            IWidget widget = queue.removeFirst();
            if (!widget.isEnabled() || !widget.isVisible() || !widget.calculateIsMouseOver()) continue;
            if (widget instanceof ITooltipHelp) {
                ((ITooltipHelp)((Object)widget)).getHelpTooltip(tooltip);
                if (tooltip.exists()) {
                    return;
                }
            }
            if (!widget.hasAttribute(WidgetAttribute.BLOCK_TOOLTIP)) continue;
            return;
        }
    }

    protected abstract AbstractMod getMod();

    protected abstract String getName();

    public BinnieResource getBackgroundTextureFile(int i) {
        return Binnie.Resource.getPNG(this.getMod(), ResourceType.GUI, this.getName() + (i == 1 ? "" : Integer.valueOf(i)));
    }

    public boolean showHelpButton() {
        return Machine.getInterface(IInventoryMachine.class, this.getInventory()) != null;
    }

    public String showInfoButton() {
        if (Machine.getInterface(IMachineInformation.class, this.getInventory()) != null) {
            return Machine.getInterface(IMachineInformation.class, this.getInventory()).getInformation();
        }
        return null;
    }

    public void setTitle(String title) {
        this.title = new ControlTextCentered((IWidget)this, 12.0f, title);
        this.title.setColor(0x404040);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiCraftGUI getGui() {
        return this.gui;
    }

    public ContainerCraftGUI getContainer() {
        return this.container;
    }

    public WindowInventory getWindowInventory() {
        return this.windowInventory;
    }

    public void initGui() {
        if (this.hasBeenInitialised) {
            return;
        }
        this.bgText1 = new StandardTexture(0, 0, 256, 256, this.getBackgroundTextureFile(1));
        if (this.getSize().x() > 256.0f) {
            this.bgText2 = new StandardTexture(0, 0, 256, 256, this.getBackgroundTextureFile(2));
        }
        if (!BinnieCore.proxy.checkTexture(this.bgText1.getTexture())) {
            this.bgText1 = null;
            this.bgText2 = null;
        }
        this.initialiseClient();
        this.hasBeenInitialised = true;
    }

    public abstract void initialiseClient();

    public void initialiseServer() {
    }

    @Override
    public void onRenderBackground() {
        CraftGUI.render.color(0xFFFFFF);
        if (this.getBackground1() != null) {
            CraftGUI.render.texture(this.getBackground1(), IPoint.ZERO);
        }
        if (this.getBackground2() != null) {
            CraftGUI.render.texture(this.getBackground2(), new IPoint(256.0f, 0.0f));
        }
        CraftGUI.render.color(this.getColor());
        CraftGUI.render.texture((Object)CraftGUITexture.Window, this.getArea());
    }

    @Override
    public void onUpdateClient() {
        ControlSlot.highlighting.get((Object)EnumHighlighting.HELP).clear();
        ControlSlot.shiftClickActive = false;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public GameProfile getUsername() {
        return this.getPlayer().func_146103_bH();
    }

    public ItemStack getHeldItemStack() {
        if (this.player != null) {
            return this.player.field_71071_by.func_70445_o();
        }
        return null;
    }

    public void setHeldItemStack(ItemStack stack) {
        if (this.player != null) {
            this.player.field_71071_by.func_70437_b(stack);
        }
    }

    public IInventory getInventory() {
        return this.entityInventory;
    }

    public void setInventories(EntityPlayer player2, IInventory inventory) {
        this.player = player2;
        this.entityInventory = inventory;
    }

    public void onClose() {
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public boolean isClient() {
        return this.side == Side.CLIENT;
    }

    public World getWorld() {
        if (this.getPlayer() != null) {
            return this.getPlayer().field_70170_p;
        }
        return BinnieCore.proxy.getWorld();
    }

    public void sendClientAction(String name, NBTTagCompound action) {
        action.func_74778_a("type", name);
        MessageCraftGUI packet = new MessageCraftGUI(action);
        BinnieCore.proxy.sendToServer(packet);
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
        if (side == Side.CLIENT && name.equals("username")) {
            float titleButtonRight;
            float w = this.w();
            this.titleButtonRight = titleButtonRight = this.titleButtonRight + 16.0f;
            new ControlUser(this, w - titleButtonRight, 8.0f, nbt.func_74779_i("username"));
            this.titleButtonRight += 6.0f;
        }
        if (side == Side.CLIENT && name.equals("power-system")) {
            float titleButtonRight2;
            float w2 = this.w();
            this.titleButtonRight = titleButtonRight2 = this.titleButtonRight + 16.0f;
            new ControlPowerSystem(this, w2 - titleButtonRight2, 8.0f, PowerSystem.get(nbt.func_74771_c("system")));
            this.titleButtonRight += 6.0f;
        }
    }

    public void onWindowInventoryChanged() {
    }

    public Texture getBackground1() {
        return this.bgText1;
    }

    public Texture getBackground2() {
        return this.bgText2;
    }
}

