/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.util.I18N;
import forestry.api.core.INBTTagable;
import net.minecraft.nbt.NBTTagCompound;

public class ErrorState
implements INBTTagable {
    private String name;
    private String desc;
    private int[] data;
    private final boolean progress;
    private boolean itemError;
    private boolean tankError;
    private boolean powerError;

    public ErrorState(String name, String desc) {
        this.data = new int[0];
        this.progress = false;
        this.itemError = false;
        this.tankError = false;
        this.powerError = false;
        this.name = name;
        this.desc = desc;
    }

    public ErrorState(String name, String desc, int[] data) {
        this.progress = false;
        this.itemError = false;
        this.tankError = false;
        this.powerError = false;
        this.name = name;
        this.desc = desc;
        this.data = data;
    }

    public String toString() {
        return this.name;
    }

    public String getTooltip() {
        return this.desc;
    }

    public int[] getData() {
        return this.data;
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.desc = nbt.func_74779_i("desc");
        this.data = nbt.func_74759_k("data");
        this.itemError = nbt.func_74767_n("item");
        this.tankError = nbt.func_74767_n("tank");
        this.powerError = nbt.func_74767_n("power");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.toString());
        nbt.func_74778_a("desc", this.getTooltip());
        nbt.func_74783_a("data", this.data);
        if (this.isItemError()) {
            nbt.func_74757_a("item", true);
        }
        if (this.isTankError()) {
            nbt.func_74757_a("tank", true);
        }
        if (this.isPowerError()) {
            nbt.func_74757_a("power", true);
        }
    }

    public boolean isItemError() {
        return this.itemError || this instanceof Item;
    }

    public boolean isTankError() {
        return this.tankError || this instanceof Tank;
    }

    public boolean isPowerError() {
        return this.powerError || this instanceof InsufficientPower;
    }

    public static class Item
    extends ErrorState {
        public Item(String name, String desc, int[] slots) {
            super(name, desc, slots);
        }
    }

    public static class Tank
    extends ErrorState {
        public Tank(String name, String desc, int[] slots) {
            super(name, desc, slots);
        }
    }

    public static class InsufficientPower
    extends ErrorState {
        public InsufficientPower() {
            super(I18N.localise("binniecore.machine.error.insufficientPower.title"), I18N.localise("binniecore.machine.error.insufficientPower.desc"));
        }
    }

    public static class InsufficientLiquid
    extends Tank {
        public InsufficientLiquid(String desc, int tank) {
            super(I18N.localise("binniecore.machine.error.insufficientLiquid"), desc, new int[]{tank});
        }
    }

    public static class TankSpace
    extends Tank {
        public TankSpace(String desc, int tank) {
            super(I18N.localise("binniecore.machine.error.tankFull"), desc, new int[]{tank});
        }
    }

    public static class NoSpace
    extends Item {
        public NoSpace(String desc, int slot) {
            super(I18N.localise("binniecore.machine.error.noSpace"), desc, new int[]{slot});
        }

        public NoSpace(String desc, int[] slots) {
            super(I18N.localise("binniecore.machine.error.noSpace"), desc, slots);
        }
    }

    public static class InvalidItem
    extends Item {
        public InvalidItem(String desc, int slot) {
            this(I18N.localise("binniecore.machine.error.invalidItem"), desc, slot);
        }

        public InvalidItem(String name, String desc, int slot) {
            super(name, desc, new int[]{slot});
        }
    }

    public static class NoItem
    extends Item {
        public NoItem(String desc, int slot) {
            this(desc, new int[]{slot});
        }

        public NoItem(String desc, int[] slots) {
            super(I18N.localise("binniecore.machine.error.noItem"), desc, slots);
        }
    }
}

