/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.storage;

import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.ControlButton;
import binnie.core.craftgui.controls.ControlCheckbox;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextEdit;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.page.ControlPage;
import binnie.core.craftgui.controls.page.ControlPages;
import binnie.core.craftgui.controls.scroll.ControlScrollableContent;
import binnie.core.craftgui.controls.tab.ControlTab;
import binnie.core.craftgui.controls.tab.ControlTabBar;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.events.EventTextEdit;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.CraftGUIUtil;
import binnie.core.craftgui.geometry.IBorder;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.minecraft.Dialog;
import binnie.core.craftgui.minecraft.EnumColor;
import binnie.core.craftgui.minecraft.IWindowAffectsShiftClick;
import binnie.core.craftgui.minecraft.MinecraftGUI;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.core.craftgui.minecraft.control.ControlSlide;
import binnie.core.craftgui.minecraft.control.ControlSlot;
import binnie.core.craftgui.minecraft.control.ControlSlotArray;
import binnie.core.craftgui.minecraft.control.ControlTabIcon;
import binnie.core.craftgui.resource.Texture;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.craftgui.window.Panel;
import binnie.core.machines.Machine;
import binnie.core.machines.storage.CompartmentTab;
import binnie.core.machines.storage.ComponentCompartmentInventory;
import binnie.core.machines.storage.ControlColourSelector;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.util.I18N;
import binnie.genetics.craftgui.WindowMachine;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WindowCompartment
extends WindowMachine
implements IWindowAffectsShiftClick {
    private final Map<Panel, Integer> panels = new HashMap<Panel, Integer>();
    private ControlTextEdit tabName;
    private ControlItemDisplay tabIcon;
    private ControlColourSelector tabColour;
    private int currentTab = 0;

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowCompartment(player, inventory, side);
    }

    public WindowCompartment(EntityPlayer player, IInventory inventory, Side side) {
        super(320, 226, player, inventory, side);
    }

    @Override
    public void initialiseClient() {
        this.setTitle(Machine.getMachine(this.getInventory()).getPackage().getDisplayName());
        int x = 16;
        int y = 32;
        ComponentCompartmentInventory inv = Machine.getMachine(this.getInventory()).getInterface(ComponentCompartmentInventory.class);
        Integer[] tabs1 = new Integer[]{};
        Integer[] tabs2 = new Integer[]{};
        if (inv.getTabNumber() == 4) {
            tabs1 = new Integer[]{0, 1};
            tabs2 = new Integer[]{2, 3};
        }
        if (inv.getTabNumber() == 6) {
            tabs1 = new Integer[]{0, 1, 2};
            tabs2 = new Integer[]{3, 4, 5};
        }
        if (inv.getTabNumber() == 8) {
            tabs1 = new Integer[]{0, 1, 2, 3};
            tabs2 = new Integer[]{4, 5, 6, 7};
        }
        boolean doubleTabbed = tabs2.length > 0;
        int compartmentPageWidth = 16 + 18 * inv.getPageSize() / 5;
        int compartmentPageHeight = 106;
        int compartmentWidth = compartmentPageWidth + (doubleTabbed ? 48 : 24);
        Control controlCompartment = new Control(this, x, y, compartmentWidth, compartmentPageHeight);
        final ControlTabBar<Integer> tab = new ControlTabBar<Integer>((IWidget)controlCompartment, 0.0f, 0.0f, 24.0f, (float)compartmentPageHeight, Position.LEFT){

            @Override
            public ControlTab<Integer> createTab(float x, float y, float w, float h, Integer value) {
                return new ControlTabIcon<Integer>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public ItemStack getItemStack() {
                        return WindowCompartment.this.getTab((Integer)this.value).getIcon();
                    }

                    @Override
                    public String getName() {
                        return WindowCompartment.this.getTab((Integer)this.value).getName();
                    }

                    @Override
                    public int getOutlineColor() {
                        return WindowCompartment.this.getTab((Integer)this.value).getColor().getColor();
                    }

                    @Override
                    public boolean hasOutline() {
                        return true;
                    }
                };
            }
        };
        String[] tabHelp = new String[]{I18N.localise("binniecore.machine.storage.tab"), I18N.localise("binniecore.machine.storage.tab.desc")};
        tab.addHelp(tabHelp);
        tab.setValues(Arrays.asList(tabs1));
        tab.setValue(0);
        tab.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                NBTTagCompound nbt = new NBTTagCompound();
                int i = (Integer)event.getValue();
                nbt.func_74774_a("i", (byte)i);
                ((Window)Window.get(tab)).sendClientAction("tab-change", nbt);
                WindowCompartment.this.currentTab = i;
            }
        }.setOrigin(EventHandler.Origin.DirectChild, tab));
        x += 24;
        ControlPages compartmentPages = new ControlPages(controlCompartment, 24.0f, 0.0f, compartmentPageWidth, compartmentPageHeight);
        ControlPage[] page = new ControlPage[inv.getTabNumber()];
        for (int p = 0; p < inv.getTabNumber(); ++p) {
            page[p] = new ControlPage<Integer>(compartmentPages, p);
        }
        CraftGUIUtil.linkWidgets(tab, compartmentPages);
        int i = 0;
        for (int p2 = 0; p2 < inv.getTabNumber(); ++p2) {
            ControlPage thisPage = page[p2];
            Panel panel = new Panel(thisPage, 0.0f, 0.0f, thisPage.w(), thisPage.h(), MinecraftGUI.PanelType.Black){

                @Override
                public void onRenderForeground() {
                    Texture iTexture = CraftGUI.render.getTexture((Object)CraftGUITexture.TabOutline);
                    CraftGUI.render.color(WindowCompartment.this.getTab((Integer)WindowCompartment.this.panels.get(this)).getColor().getColor());
                    CraftGUI.render.texture(iTexture, this.getArea().inset(3));
                }
            };
            this.panels.put(panel, p2);
            int[] slotsIDs = new int[inv.getPageSize()];
            for (int k = 0; k < inv.getPageSize(); ++k) {
                slotsIDs[k] = i++;
            }
            new ControlSlotArray((IWidget)thisPage, 8, 8, inv.getPageSize() / 5, 5).create(slotsIDs);
        }
        x += compartmentPageWidth;
        if (tabs2.length > 0) {
            ControlTabBar<Integer> tab2 = new ControlTabBar<Integer>((IWidget)controlCompartment, (float)(24 + compartmentPageWidth), 0.0f, 24.0f, (float)compartmentPageHeight, Position.RIGHT){

                @Override
                public ControlTab<Integer> createTab(float x, float y, float w, float h, Integer value) {
                    return new ControlTabIcon<Integer>((ControlTabBar)this, x, y, w, h, value){

                        @Override
                        public ItemStack getItemStack() {
                            return WindowCompartment.this.getTab((Integer)this.value).getIcon();
                        }

                        @Override
                        public String getName() {
                            return WindowCompartment.this.getTab((Integer)this.value).getName();
                        }

                        @Override
                        public int getOutlineColor() {
                            return WindowCompartment.this.getTab((Integer)this.value).getColor().getColor();
                        }

                        @Override
                        public boolean hasOutline() {
                            return true;
                        }
                    };
                }
            };
            tab2.setValues(Arrays.asList(tabs2));
            tab2.setValue(0);
            tab2.addHelp(tabHelp);
            tab2.addEventHandler(new EventValueChanged.Handler(){

                @Override
                public void onEvent(EventValueChanged event) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    int i = (Integer)event.getValue();
                    nbt.func_74774_a("i", (byte)i);
                    ((Window)Window.get(tab)).sendClientAction("tab-change", nbt);
                    WindowCompartment.this.currentTab = i;
                }
            }.setOrigin(EventHandler.Origin.DirectChild, tab2));
            CraftGUIUtil.linkWidgets(tab2, compartmentPages);
            x += 24;
        }
        this.setSize(new IPoint(Math.max(32 + compartmentWidth, 252), this.h()));
        controlCompartment.setPosition(new IPoint((this.w() - controlCompartment.w()) / 2.0f, controlCompartment.y()));
        new ControlPlayerInventory((IWidget)this, true);
        ControlSlide slide = new ControlSlide(this, 0.0f, 134.0f, 136.0f, 92.0f, Position.LEFT);
        slide.setLabel(I18N.localise("binniecore.machine.storage.tab.properties"));
        slide.setSlide(false);
        slide.addHelp(I18N.localise("binniecore.machine.storage.tooltip.properties"));
        slide.addHelp(I18N.localise("binniecore.machine.storage.tooltip.properties.desc"));
        Panel tabPropertyPanel = new Panel(slide, 16.0f, 8.0f, 112.0f, 76.0f, MinecraftGUI.PanelType.Gray);
        int y2 = 4;
        new ControlText((IWidget)tabPropertyPanel, new IPoint(4.0f, y2), I18N.localise("binniecore.machine.storage.tab.name"));
        float x2 = 4.0f;
        this.tabName = new ControlTextEdit(tabPropertyPanel, x2, y2 += 12, 104.0f, 12.0f);
        this.tabName.addSelfEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(EventTextEdit event) {
                CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                tab.setName((String)event.getValue());
                NBTTagCompound nbt = new NBTTagCompound();
                tab.writeToNBT(nbt);
                WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
            }
        }.setOrigin(EventHandler.Origin.Self, this.tabName));
        new ControlText((IWidget)tabPropertyPanel, new IPoint(4.0f, y2 += 20), I18N.localise("binniecore.machine.storage.tab.icon"));
        this.tabIcon = new ControlItemDisplay(tabPropertyPanel, 58.0f, y2 - 4);
        this.tabIcon.setItemStack(new ItemStack(Items.field_151121_aF));
        this.tabIcon.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.tabIcon.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (WindowCompartment.this.getHeldItemStack() == null) {
                    return;
                }
                CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                ItemStack stack = WindowCompartment.this.getHeldItemStack().func_77946_l();
                stack.field_77994_a = 1;
                tab.setIcon(stack);
                NBTTagCompound nbt = new NBTTagCompound();
                tab.writeToNBT(nbt);
                WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
            }
        });
        this.tabColour = new ControlColourSelector(tabPropertyPanel, 82.0f, y2 - 4, 16.0f, 16.0f, EnumColor.White);
        this.tabIcon.addHelp(I18N.localise("binniecore.machine.storage.tooltip.icon"));
        this.tabIcon.addHelp(I18N.localise("binniecore.machine.storage.tooltip.icon.desc"));
        new ControlText((IWidget)tabPropertyPanel, new IPoint(4.0f, y2 += 20), I18N.localise("binniecore.machine.storage.tab.color"));
        int cw = 8;
        Panel panelColour = new Panel(tabPropertyPanel, 40.0f, y2 - 4, cw * 8 + 2, cw * 2 + 1, MinecraftGUI.PanelType.Gray);
        for (int cc = 0; cc < 16; ++cc) {
            final ControlColourSelector color = new ControlColourSelector(panelColour, 1 + cw * (cc % 8), 1 + cw * (cc / 8), cw, cw, EnumColor.values()[cc]);
            color.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

                @Override
                public void onEvent(EventMouse.Down event) {
                    CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                    tab.setColor(color.getValue());
                    NBTTagCompound nbt = new NBTTagCompound();
                    tab.writeToNBT(nbt);
                    WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
                }
            });
            color.addHelp(I18N.localise("binniecore.machine.storage.tooltip.color"));
            color.addHelp(I18N.localise("binniecore.machine.storage.tooltip.color.desc"));
        }
        SearchButton searchButton = new SearchButton(controlCompartment, compartmentWidth, compartmentPageHeight);
        searchButton.addHelp(I18N.localise("binniecore.machine.storage.tooltip.search"));
        searchButton.addHelp(I18N.localise("binniecore.machine.storage.tooltip.search.desc"));
    }

    public void createSearchDialog() {
        new Dialog(this, 252.0f, 192.0f){
            Control slotGrid;
            String textSearch;
            boolean sortByName;
            boolean includeItems;
            boolean includeBlocks;
            {
                this.textSearch = "";
                this.sortByName = false;
                this.includeItems = true;
                this.includeBlocks = true;
            }

            @Override
            public void onClose() {
            }

            @Override
            public void initialise() {
                ControlScrollableContent<IWidget> scroll = new ControlScrollableContent<IWidget>((IWidget)this, 124.0f, 16.0f, 116.0f, 92.0f, 6.0f){

                    @Override
                    public void onRenderBackground() {
                        CraftGUI.render.color(0xAAAAAA);
                        CraftGUI.render.texture((Object)CraftGUITexture.Outline, this.getArea().inset(new IBorder(0.0f, 6.0f, 0.0f, 0.0f)));
                    }
                };
                this.slotGrid = new Control(scroll, 1.0f, 1.0f, 108.0f, 18.0f);
                scroll.setScrollableContent(this.slotGrid);
                new ControlPlayerInventory((IWidget)this, true);
                new ControlTextEdit(this, 16.0f, 16.0f, 100.0f, 14.0f).addEventHandler((EventHandler)new EventTextEdit.Handler(){

                    @Override
                    public void onEvent(EventTextEdit event) {
                        textSearch = (String)event.value;
                        this.updateSearch();
                    }
                });
                this.includeItems = true;
                this.includeBlocks = true;
                new ControlCheckbox(this, 16.0f, 40.0f, 100.0f, I18N.localise("binniecore.machine.storage.sort"), this.sortByName){

                    @Override
                    protected void onValueChanged(boolean value) {
                        sortByName = value;
                        this.updateSearch();
                    }
                };
                new ControlCheckbox(this, 16.0f, 64.0f, 100.0f, I18N.localise("binniecore.machine.storage.filterItems"), this.includeItems){

                    @Override
                    protected void onValueChanged(boolean value) {
                        includeItems = value;
                        this.updateSearch();
                    }
                };
                new ControlCheckbox(this, 16.0f, 88.0f, 100.0f, I18N.localise("binniecore.machine.storage.filterBlocks"), this.includeBlocks){

                    @Override
                    protected void onValueChanged(boolean value) {
                        includeBlocks = value;
                        this.updateSearch();
                    }
                };
                this.updateSearch();
            }

            private void updateSearch() {
                HashMap<Integer, Object> slotIds = new HashMap<Integer, Object>();
                IInventory inv = WindowCompartment.this.getInventory();
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null) continue;
                    String name = stack.func_82833_r().toLowerCase();
                    if (this.textSearch != null && !name.contains(this.textSearch)) continue;
                    Block block = Block.func_149634_a((Item)stack.func_77973_b());
                    if (!this.includeBlocks && block != Blocks.field_150350_a || !this.includeItems && block == Blocks.field_150350_a) continue;
                    slotIds.put(i, name);
                }
                if (this.sortByName) {
                    LinkedList list = new LinkedList(slotIds.entrySet());
                    list.sort((o1, o2) -> -((String)o2.getValue()).compareTo((String)o1.getValue()));
                    LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
                    for (Map.Entry entry : list) {
                        result.put((Integer)entry.getKey(), (String)entry.getValue());
                    }
                    slotIds = result;
                }
                int y = 0;
                int x = 0;
                int width = 108;
                int n = 2 + 18 * (1 + (slotIds.size() - 1) / 6);
                this.slotGrid.deleteAllChildren();
                this.slotGrid.setSize(new IPoint(width, n));
                Iterator iterator = slotIds.keySet().iterator();
                while (iterator.hasNext()) {
                    int k = (Integer)iterator.next();
                    new ControlSlot(this.slotGrid, x, y).assign(k);
                    if ((x += 18) < 108) continue;
                    x = 0;
                    y += 18;
                }
                while (y < 108 || x != 0) {
                    new ControlSlot(this.slotGrid, x, y);
                    if ((x += 18) < 108) continue;
                    x = 0;
                    y += 18;
                }
            }
        };
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        this.updateTabs();
    }

    public void updateTabs() {
        CompartmentTab tab = this.getCurrentTab();
        if (!this.tabName.isFocused()) {
            this.tabName.setValue(tab.getName());
        }
        this.tabIcon.setItemStack(tab.getIcon());
        this.tabColour.setValue(tab.getColor());
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
        super.recieveGuiNBT(side, player, name, nbt);
        if (name.equals("tab-change")) {
            this.currentTab = nbt.func_74771_c("i");
        }
    }

    @Override
    public String getTitle() {
        return I18N.localise("binniecore.machine.storage.compartment");
    }

    @Override
    protected AbstractMod getMod() {
        return BinnieCore.instance;
    }

    @Override
    protected String getName() {
        return "compartment";
    }

    @Override
    public void alterRequest(TransferRequest request) {
        IInventory inventory = this.getInventory();
        if (request.getDestination() == inventory) {
            ComponentCompartmentInventory inv = Machine.getMachine(inventory).getInterface(ComponentCompartmentInventory.class);
            request.setTargetSlots(inv.getSlotsForTab(this.currentTab));
        }
    }

    public CompartmentTab getTab(int i) {
        return Machine.getInterface(ComponentCompartmentInventory.class, this.getInventory()).getTab(i);
    }

    public CompartmentTab getCurrentTab() {
        return this.getTab(this.currentTab);
    }

    private class SearchButton
    extends ControlButton {
        public SearchButton(Control controlCompartment, int compartmentWidth, int compartmentPageHeight) {
            super(controlCompartment, compartmentWidth - 24 - 64 - 8, compartmentPageHeight, 64.0f, 16.0f, I18N.localise("binniecore.machine.storage.search"));
        }

        @Override
        protected void onMouseClick(EventMouse.Down event) {
            WindowCompartment.this.createSearchDialog();
        }

        @Override
        public void onRenderBackground() {
            CraftGUITexture texture = this.isMouseOver() ? CraftGUITexture.TabHighlighted : CraftGUITexture.Tab;
            CraftGUI.render.texture(CraftGUI.render.getTexture((Object)texture).crop(Position.BOTTOM, 8.0f), this.getArea());
        }
    }
}

