/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.inoculator;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.PackageGeneticBase;
import binnie.genetics.machine.inoculator.BacteriaVectorValidator;
import binnie.genetics.machine.inoculator.IndividualInoculateValidator;
import binnie.genetics.machine.inoculator.Inoculator;
import binnie.genetics.machine.inoculator.InoculatorComponentFX;
import binnie.genetics.machine.inoculator.InoculatorComponentLogic;
import binnie.genetics.machine.inoculator.SerumSlotValidator;
import net.minecraft.item.ItemStack;

public class InoculatorPackage
extends PackageGeneticBase
implements IMachineInformation {
    public InoculatorPackage() {
        super("inoculator", GeneticsTexture.Inoculator, 14819893, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.Inoculator);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        SerumSlotValidator serumValid = new SerumSlotValidator();
        InventorySlot slotSerumVial = inventory.addSlot(0, "serum.active");
        slotSerumVial.forbidInteraction();
        slotSerumVial.setReadOnly();
        slotSerumVial.setValidator(serumValid);
        inventory.addSlotArray(Inoculator.SLOT_SERUM_RESERVE, "serum.input");
        for (InventorySlot slot : inventory.getSlots(Inoculator.SLOT_SERUM_RESERVE)) {
            slot.setValidator(serumValid);
            slot.forbidExtraction();
        }
        inventory.addSlotArray(Inoculator.SLOT_SERUM_EXPENDED, "serum.output");
        for (InventorySlot slot : inventory.getSlots(Inoculator.SLOT_SERUM_EXPENDED)) {
            slot.setValidator(serumValid);
            slot.setReadOnly();
        }
        inventory.addSlotArray(Inoculator.SLOT_RESERVE, "input");
        for (InventorySlot slot : inventory.getSlots(Inoculator.SLOT_RESERVE)) {
            slot.forbidExtraction();
            slot.setValidator(new IndividualInoculateValidator());
        }
        inventory.addSlot(9, "process");
        inventory.getSlot(9).setValidator(new IndividualInoculateValidator());
        inventory.getSlot(9).setReadOnly();
        inventory.getSlot(9).forbidInteraction();
        inventory.addSlotArray(Inoculator.SLOT_FINISHED, "output");
        for (InventorySlot slot : inventory.getSlots(Inoculator.SLOT_FINISHED)) {
            slot.setReadOnly();
            slot.forbidInsertion();
            slot.setValidator(new IndividualInoculateValidator());
        }
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Inoculator.SLOT_RESERVE, 9, 1);
        transfer.addRestock(Inoculator.SLOT_SERUM_RESERVE, 0);
        transfer.addStorage(0, Inoculator.SLOT_SERUM_EXPENDED, new ComponentInventoryTransfer.Condition(){

            @Override
            public boolean fufilled(ItemStack stack) {
                return Engineering.getCharges(stack) == 0;
            }
        });
        transfer.addStorage(9, Inoculator.SLOT_FINISHED, new ComponentInventoryTransfer.Condition(){

            @Override
            public boolean fufilled(ItemStack stack) {
                return stack != null && this.transfer.getMachine().getMachineUtil().getStack(0) != null && this.transfer.getMachine().getInterface(InoculatorComponentLogic.class).isValidSerum() != null;
            }
        });
        new ComponentPowerReceptor(machine, 15000);
        new InoculatorComponentLogic(machine);
        new InoculatorComponentFX(machine);
        new ComponentTankContainer(machine).addTank(0, "input", 1000).setValidator(new BacteriaVectorValidator());
    }
}

