/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.ManagerBase;
import binnie.core.block.MultipassBlockRenderer;
import binnie.core.block.TileEntityMetadata;
import binnie.core.craftgui.minecraft.ModuleCraftGUI;
import binnie.core.gui.BinnieCoreGUI;
import binnie.core.gui.BinnieGUIHandler;
import binnie.core.gui.IBinnieGUID;
import binnie.core.item.ItemGenesis;
import binnie.core.item.ModuleItems;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.storage.ModuleStorage;
import binnie.core.mod.parser.FieldParser;
import binnie.core.mod.parser.ItemParser;
import binnie.core.network.BinnieCorePacketID;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.proxy.BinnieProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.triggers.ModuleTrigger;
import binnie.genetics.item.ItemFieldKit;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryEvent;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="BinnieCore", name="Binnie Core", version="2.5.23", useMetadata=true, dependencies="after:Forestry@[4.2,),required-after:gtnhlib@[0.0.10,)")
public class BinnieCore
extends AbstractMod {
    public static final String CORE_MODID = "BinnieCore";
    public static final String CORE_MOD_NAME = "Binnie Core";
    @Mod.Instance(value="BinnieCore")
    public static BinnieCore instance;
    @SidedProxy(clientSide="binnie.core.proxy.BinnieProxyClient", serverSide="binnie.core.proxy.BinnieProxyServer")
    public static BinnieProxy proxy;
    public static int multipassRenderID;
    private static final List<AbstractMod> modList;
    public static MachineGroup packageCompartment;
    public static ItemGenesis genesis;
    public static ItemFieldKit fieldKit;

    public BinnieCore() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        for (ManagerBase baseManager : Binnie.Managers) {
            this.addModule(baseManager);
        }
        this.addModule(new ModuleCraftGUI());
        this.addModule(new ModuleStorage());
        this.addModule(new ModuleItems());
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            this.addModule(new ModuleTrigger());
        }
        this.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.postInit();
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return BinnieCoreGUI.values();
    }

    @Override
    public void preInit() {
        instance = this;
        for (FluidContainer container : FluidContainer.values()) {
            ItemFluidContainer item = new ItemFluidContainer(container);
            GameRegistry.registerItem((Item)item, (String)item.func_77658_a().substring(5));
        }
        FieldParser.parsers.add(new ItemParser());
        super.preInit();
    }

    @Override
    public void init() {
        super.init();
        for (AbstractMod mod : BinnieCore.getActiveMods()) {
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)mod, (IGuiHandler)new BinnieGUIHandler(mod));
        }
        multipassRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new MultipassBlockRenderer());
        GameRegistry.registerTileEntity(TileEntityMetadata.class, (String)"binnie.tile.metadata");
    }

    public static boolean isLepidopteryActive() {
        return PluginManager.Module.LEPIDOPTEROLOGY.isEnabled();
    }

    public static boolean isApicultureActive() {
        return PluginManager.Module.APICULTURE.isEnabled();
    }

    public static boolean isArboricultureActive() {
        return PluginManager.Module.ARBORICULTURE.isEnabled();
    }

    public static boolean isExtraBeesActive() {
        return BinnieCore.isApicultureActive();
    }

    public static boolean isExtraTreesActive() {
        return BinnieCore.isArboricultureActive();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    static void registerMod(AbstractMod mod) {
        modList.add(mod);
    }

    private static List<AbstractMod> getActiveMods() {
        ArrayList<AbstractMod> list = new ArrayList<AbstractMod>();
        for (AbstractMod mod : modList) {
            if (!mod.isActive()) continue;
            list.add(mod);
        }
        return list;
    }

    @Override
    public String getChannel() {
        return "BIN";
    }

    @Override
    public IBinnieProxy getProxy() {
        return proxy;
    }

    @Override
    public String getModID() {
        return "binniecore";
    }

    @Override
    public IPacketID[] getPacketIDs() {
        return BinnieCorePacketID.values();
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    static {
        modList = new ArrayList<AbstractMod>();
    }

    public static class EventHandler {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void handleSpeciesDiscovered(ForestryEvent.SpeciesDiscovered event) {
            try {
                EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(event.username.getName());
                if (player == null) {
                    return;
                }
                event.tracker.synchToPlayer((EntityPlayer)player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void handleTextureRemap(TextureStitchEvent.Pre event) {
            if (event.map.func_130086_a() == 0) {
                Binnie.Liquid.reloadIcons((IIconRegister)event.map);
            }
            Binnie.Resource.registerIcons((IIconRegister)event.map, event.map.func_130086_a());
        }
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(instance);
        }
    }
}

