/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.common;

import blockrenderer6343.BlockRenderer6343;
import blockrenderer6343.api.utils.BlockPosition;
import blockrenderer6343.client.renderer.ImmediateWorldSceneRenderer;
import blockrenderer6343.client.renderer.WorldSceneRenderer;
import blockrenderer6343.client.utils.GuiText;
import blockrenderer6343.client.world.DummyWorld;
import blockrenderer6343.client.world.TrackedDummyWorld;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.math.MathHelper;
import codechicken.nei.NEIClientUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public abstract class GUI_MultiblocksHandler<T> {
    protected static ImmediateWorldSceneRenderer renderer;
    public static final int SLOT_SIZE = 18;
    protected static final int RECIPE_LAYOUT_X = 8;
    protected static final int RECIPE_LAYOUT_Y = 50;
    protected static final int RECIPE_WIDTH = 160;
    protected static final int sceneHeight = 150;
    protected static final int ICON_SIZE_X = 20;
    protected static final int ICON_SIZE_Y = 12;
    protected static final int MOUSE_OFFSET_X = 5;
    protected static final int MOUSE_OFFSET_Y = 43;
    protected static final int LAYER_BUTTON_X = -5;
    protected static final int LAYER_BUTTON_Y = 135;
    protected static final float DEFAULT_RANGE_MULTIPLIER = 3.5f;
    protected static int guiMouseX;
    protected static int guiMouseY;
    protected static int lastGuiMouseX;
    protected static int lastGuiMouseY;
    protected static Vector3f center;
    protected static float rotationYaw;
    protected static float rotationPitch;
    protected static float zoom;
    protected static ItemStack tooltipBlockStack;
    protected static BlockPosition selectedBlock;
    protected static int layerIndex;
    protected static int guiColorBg;
    protected static int guiColorFont;
    protected static int buttonColorEnabled;
    protected static int buttonColorDisabled;
    protected static int buttonColorHovered;
    protected static String guiTextLayer;
    protected static String guiLayerButtonTitle;
    protected static int initialLayerButtonTitleWidth;
    protected ClearGuiButton previousLayerButton;
    protected ClearGuiButton nextLayerButton;
    protected List<ItemStack> ingredients = new ArrayList<ItemStack>();
    protected Consumer<List<ItemStack>> onIngredientChanged;
    protected static final Map<GuiButton, Runnable> buttons;
    protected T renderingController;
    protected ItemStack stackForm;
    protected T lastRenderingController;
    private int scrolled = 0;

    public GUI_MultiblocksHandler() {
        buttons.clear();
        this.previousLayerButton = new ClearGuiButton(0, -5, 135, 20, 12, "<");
        this.nextLayerButton = new ClearGuiButton(0, 15, 135, 20, 12, ">");
        buttons.put(this.previousLayerButton, this::togglePreviousLayer);
        buttons.put(this.nextLayerButton, this::toggleNextLayer);
    }

    protected void setLocalizationAndColor() {
        guiTextLayer = GuiText.Layer.getLocal();
        guiColorBg = GuiText.BgColor.getColor();
        guiColorFont = GuiText.FontColor.getColor();
        buttonColorEnabled = GuiText.ButtonEnabledColor.getColor();
        buttonColorDisabled = GuiText.ButtonDisabledColor.getColor();
        buttonColorHovered = GuiText.ButtonHoveredColor.getColor();
        this.previousLayerButton.setColors(buttonColorEnabled, buttonColorDisabled, buttonColorHovered);
        this.nextLayerButton.setColors(buttonColorEnabled, buttonColorDisabled, buttonColorHovered);
        guiLayerButtonTitle = this.getLayerButtonTitle();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        initialLayerButtonTitleWidth = fontRenderer.func_78256_a(guiLayerButtonTitle);
        this.nextLayerButton.field_146128_h = 15 + initialLayerButtonTitleWidth - fontRenderer.func_78256_a("<") / 2;
    }

    public void loadMultiblock(T multiblock, ItemStack stackForm) {
        this.setLocalizationAndColor();
        this.renderingController = multiblock;
        this.stackForm = stackForm;
        if (this.lastRenderingController != this.renderingController) {
            this.loadNewMultiblock();
        } else {
            this.loadPreviousMultiblockAgain();
        }
    }

    protected void loadNewMultiblock() {
        layerIndex = -1;
        this.initializeSceneRenderer(true);
        this.lastRenderingController = this.renderingController;
    }

    protected void loadPreviousMultiblockAgain() {
        this.initializeSceneRenderer(false);
    }

    public void setOnIngredientChanged(Consumer<List<ItemStack>> callback) {
        this.onIngredientChanged = callback;
    }

    private void toggleNextLayer() {
        int height = (int)((TrackedDummyWorld)GUI_MultiblocksHandler.renderer.world).getSize().getY() - 1;
        if (++layerIndex > height) {
            layerIndex = -1;
        }
        this.setNextLayer(layerIndex);
    }

    private void togglePreviousLayer() {
        int height = (int)((TrackedDummyWorld)GUI_MultiblocksHandler.renderer.world).getSize().getY() - 1;
        if (layerIndex == -1) {
            layerIndex = height;
        } else if (--layerIndex < 0) {
            layerIndex = -1;
        }
        this.setNextLayer(layerIndex);
    }

    private void setNextLayer(int newLayer) {
        layerIndex = newLayer;
        if (renderer != null) {
            Set<BlockPosition> renderBlocks;
            TrackedDummyWorld world = (TrackedDummyWorld)GUI_MultiblocksHandler.renderer.world;
            this.resetCenter();
            GUI_MultiblocksHandler.renderer.renderedBlocks.clear();
            int minY = (int)world.getMinPos().getY();
            if (newLayer == -1) {
                renderBlocks = world.placedBlocks;
                renderer.setRenderAllFaces(false);
            } else {
                renderBlocks = world.placedBlocks.stream().filter(pos -> pos.y - minY == newLayer).collect(Collectors.toSet());
                renderer.setRenderAllFaces(true);
            }
            renderer.addRenderedBlocks(renderBlocks);
            this.scanIngredients();
            guiLayerButtonTitle = this.getLayerButtonTitle();
        }
    }

    private void resetCenter() {
        TrackedDummyWorld world = (TrackedDummyWorld)GUI_MultiblocksHandler.renderer.world;
        Vector3f size = world.getSize();
        Vector3f minPos = world.getMinPos();
        center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        renderer.setCameraLookAt(center, zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
    }

    public void drawMultiblock() {
        guiMouseX = GuiDraw.getMousePosition().x;
        guiMouseY = GuiDraw.getMousePosition().y;
        int k = (NEIClientUtils.getGuiContainer().field_146294_l - 176) / 2;
        int l = (NEIClientUtils.getGuiContainer().field_146295_m - Math.min(Math.max(NEIClientUtils.getGuiContainer().field_146295_m - 68, 166), 370)) / 2;
        renderer.render(8 + k, 50 + l, 160, 150, lastGuiMouseX, lastGuiMouseY);
        this.drawMultiblockName();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tooltipBlockStack = null;
        MovingObjectPosition rayTraceResult = renderer.getLastTraceResult();
        boolean insideView = guiMouseX >= k + 8 && guiMouseY >= l + 50 && guiMouseX < k + 8 + 160 && guiMouseY < l + 50 + 150;
        boolean leftClickHeld = Mouse.isButtonDown((int)0);
        boolean rightClickHeld = Mouse.isButtonDown((int)1);
        boolean middleClickHeld = Mouse.isButtonDown((int)2);
        if (insideView) {
            int mouseDeltaY;
            if (leftClickHeld) {
                rotationPitch += (float)(guiMouseX - lastGuiMouseX + 360);
                rotationPitch %= 360.0f;
                rotationYaw = (float)MathHelper.clip((double)(rotationYaw + (float)(guiMouseY - lastGuiMouseY)), (double)-89.9, (double)89.9);
            } else if (rightClickHeld && Math.abs(mouseDeltaY = guiMouseY - lastGuiMouseY) > 1) {
                zoom = (float)MathHelper.clip((double)((double)zoom + (mouseDeltaY > 0 ? 0.15 : -0.15)), (double)3.0, (double)999.0);
            }
            if (middleClickHeld) {
                int mouseDeltaX = guiMouseX - lastGuiMouseX;
                int mouseDeltaY2 = guiMouseY - lastGuiMouseY;
                Vector3f lookAt = renderer.getLookAt();
                Vector3f eyePos = renderer.getEyePos();
                Vector3f worldUp = renderer.getWorldUp();
                Vector3f lookDir = Vector3f.sub((Vector3f)lookAt, (Vector3f)eyePos, null);
                Vector3f rightDir = Vector3f.cross((Vector3f)lookDir, (Vector3f)worldUp, null);
                rightDir.normalise();
                Vector3f upDir = Vector3f.cross((Vector3f)rightDir, (Vector3f)lookDir, null);
                upDir.normalise();
                Vector3f offset = new Vector3f((float)(-mouseDeltaX) * rightDir.x + (float)mouseDeltaY2 * upDir.x, (float)(-mouseDeltaX) * rightDir.y + (float)mouseDeltaY2 * upDir.y, (float)(-mouseDeltaX) * rightDir.z + (float)mouseDeltaY2 * upDir.z);
                offset.scale(0.15f);
                Vector3f.add((Vector3f)center, (Vector3f)offset, (Vector3f)center);
            }
            if (this.scrolled != 0) {
                zoom = (float)MathHelper.clip((double)(zoom - (float)(this.scrolled * 5)), (double)3.0, (double)999.0);
                this.scrolled = 0;
            }
            renderer.setCameraLookAt(center, zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
        }
        for (GuiButton button : buttons.keySet()) {
            button.func_146112_a(Minecraft.func_71410_x(), guiMouseX - k - 5, guiMouseY - l - 43);
        }
        this.drawButtonsTitle();
        if (!(leftClickHeld || rightClickHeld || rayTraceResult == null || GUI_MultiblocksHandler.renderer.world.func_147437_c(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d))) {
            Block block = GUI_MultiblocksHandler.renderer.world.func_147439_a(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d);
            tooltipBlockStack = block.getPickBlock(rayTraceResult, GUI_MultiblocksHandler.renderer.world, rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        lastGuiMouseX = guiMouseX;
        lastGuiMouseY = guiMouseY;
    }

    private void drawMultiblockName() {
        String localizedName = this.getMultiblockName();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List lines = fontRenderer.func_78271_c(localizedName, 150);
        for (int i = 0; i < lines.size(); ++i) {
            fontRenderer.func_78276_b((String)lines.get(i), (160 - fontRenderer.func_78256_a((String)lines.get(i))) / 2, fontRenderer.field_78288_b * i, guiColorFont);
        }
    }

    protected abstract String getMultiblockName();

    protected String getLayerButtonTitle() {
        return guiTextLayer + ": " + (layerIndex == -1 ? "A" : Integer.toString(layerIndex + 1));
    }

    protected void drawButtonsTitle() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(guiLayerButtonTitle, 15 + (initialLayerButtonTitleWidth - fontRenderer.func_78256_a(guiLayerButtonTitle)) / 2, 137, guiColorFont);
    }

    protected void initializeSceneRenderer(boolean resetCamera) {
        Vector3f eyePos = new Vector3f();
        Vector3f lookAt = new Vector3f();
        Vector3f worldUp = new Vector3f();
        if (!resetCamera) {
            try {
                eyePos = renderer.getEyePos();
                lookAt = renderer.getLookAt();
                worldUp = renderer.getWorldUp();
            }
            catch (NullPointerException e) {
                BlockRenderer6343.error("please reset camera on your first renderer call!");
            }
        }
        renderer = new ImmediateWorldSceneRenderer(new TrackedDummyWorld());
        ((DummyWorld)GUI_MultiblocksHandler.renderer.world).updateEntitiesForNEI();
        renderer.setClearColor(guiColorBg);
        this.placeMultiblock();
        Vector3f size = ((TrackedDummyWorld)GUI_MultiblocksHandler.renderer.world).getSize();
        Vector3f minPos = ((TrackedDummyWorld)GUI_MultiblocksHandler.renderer.world).getMinPos();
        center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        GUI_MultiblocksHandler.renderer.renderedBlocks.clear();
        renderer.addRenderedBlocks(((TrackedDummyWorld)GUI_MultiblocksHandler.renderer.world).placedBlocks);
        renderer.setOnLookingAt(ray -> {});
        renderer.setOnWorldRender(this::onRendererRender);
        selectedBlock = null;
        this.onBlockSelected();
        this.setNextLayer(layerIndex);
        if (resetCamera) {
            float max = Math.max(Math.max(Math.max(size.x, size.y), size.z), 1.0f);
            if (size.x >= 30.0f || size.y >= 30.0f || size.z >= 30.0f) {
                zoom = (float)(14.0 * Math.sqrt(max));
            }
            zoom = size.x >= 15.0f && size.y >= 15.0f && size.z >= 11.0f ? (float)(7.0 * Math.sqrt(max)) : (float)(3.5 * Math.sqrt(max));
            rotationYaw = 20.0f;
            rotationPitch = 50.0f;
            if (renderer != null) {
                this.resetCenter();
            }
        } else {
            renderer.setCameraLookAt(eyePos, lookAt, worldUp);
        }
    }

    protected abstract void placeMultiblock();

    public void handleMouseScrollUp(int scrolled) {
        this.scrolled = scrolled;
    }

    public void onRendererRender(WorldSceneRenderer renderer) {
        BlockPosition look;
        BlockPosition blockPosition = look = renderer.getLastTraceResult() == null ? null : new BlockPosition(renderer.getLastTraceResult().field_72311_b, renderer.getLastTraceResult().field_72312_c, renderer.getLastTraceResult().field_72309_d);
        if (look != null && look.equals(selectedBlock)) {
            this.renderBlockOverLay(selectedBlock, Blocks.field_150359_w.func_149691_a(0, 6));
            return;
        }
        this.renderBlockOverLay(look, Blocks.field_150399_cn.func_149691_a(0, 7));
        this.renderBlockOverLay(selectedBlock, Blocks.field_150399_cn.func_149691_a(0, 14));
    }

    private void scanIngredients() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (BlockPosition renderedBlock : GUI_MultiblocksHandler.renderer.renderedBlocks) {
            Block block = GUI_MultiblocksHandler.renderer.world.func_147439_a(renderedBlock.x, renderedBlock.y, renderedBlock.z);
            if (block.equals(Blocks.field_150350_a)) continue;
            int meta = GUI_MultiblocksHandler.renderer.world.func_72805_g(renderedBlock.x, renderedBlock.y, renderedBlock.z);
            ArrayList itemstacks = block.getDrops(GUI_MultiblocksHandler.renderer.world, renderedBlock.x, renderedBlock.y, renderedBlock.z, meta, 0);
            if (itemstacks.size() == 0) {
                itemstacks.add(new ItemStack(block));
            }
            boolean added = false;
            for (ItemStack ingredient : ingredients) {
                if (!NEIClientUtils.areStacksSameTypeWithNBT((ItemStack)ingredient, (ItemStack)((ItemStack)itemstacks.get(0)))) continue;
                ++ingredient.field_77994_a;
                added = true;
                break;
            }
            if (added) continue;
            ingredients.add((ItemStack)itemstacks.get(0));
        }
        this.ingredients = ingredients;
        if (this.onIngredientChanged != null) {
            this.onIngredientChanged.accept(ingredients);
        }
    }

    private void renderBlockOverLay(BlockPosition pos, IIcon icon) {
        if (pos == null) {
            return;
        }
        RenderBlocks bufferBuilder = new RenderBlocks();
        bufferBuilder.field_147845_a = GUI_MultiblocksHandler.renderer.world;
        bufferBuilder.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        bufferBuilder.field_147837_f = true;
        Block block = GUI_MultiblocksHandler.renderer.world.func_147439_a(pos.x, pos.y, pos.z);
        bufferBuilder.func_147792_a(block, pos.x, pos.y, pos.z, icon);
    }

    public boolean mouseClicked(int button) {
        for (Map.Entry<GuiButton, Runnable> buttons : GUI_MultiblocksHandler.buttons.entrySet()) {
            int k = (NEIClientUtils.getGuiContainer().field_146294_l - 176) / 2;
            int l = (NEIClientUtils.getGuiContainer().field_146295_m - Math.min(Math.max(NEIClientUtils.getGuiContainer().field_146295_m - 68, 166), 370)) / 2;
            if (!buttons.getKey().func_146116_c(Minecraft.func_71410_x(), guiMouseX - k - 5, guiMouseY - l - 43)) continue;
            buttons.getValue().run();
            selectedBlock = null;
            this.onBlockSelected();
            return true;
        }
        if (button == 1 && renderer != null) {
            if (renderer.getLastTraceResult() == null) {
                if (selectedBlock != null) {
                    selectedBlock = null;
                    this.onBlockSelected();
                    return true;
                }
                return false;
            }
            selectedBlock = new BlockPosition(GUI_MultiblocksHandler.renderer.getLastTraceResult().field_72311_b, GUI_MultiblocksHandler.renderer.getLastTraceResult().field_72312_c, GUI_MultiblocksHandler.renderer.getLastTraceResult().field_72309_d);
            this.onBlockSelected();
        }
        return false;
    }

    protected abstract void onBlockSelected();

    public List<String> handleTooltip() {
        if (tooltipBlockStack != null) {
            return tooltipBlockStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        return null;
    }

    static {
        layerIndex = -1;
        buttons = new HashMap<GuiButton, Runnable>();
    }

    protected class ClearGuiButton
    extends GuiButton {
        private int colorEnabled;
        private int colorDisabled;
        private int colorHovered;

        public ClearGuiButton(int p_i1021_1_, int p_i1021_2_, int p_i1021_3_, int p_i1021_4_, int p_i1021_5_, String p_i1021_6_) {
            super(p_i1021_1_, p_i1021_2_, p_i1021_3_, p_i1021_4_, p_i1021_5_, p_i1021_6_);
        }

        public void setColors(int clrEnabled, int clrDisabled, int clrHovered) {
            this.colorEnabled = clrEnabled;
            this.colorDisabled = clrDisabled;
            this.colorHovered = clrHovered;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = p_146112_1_.field_71466_p;
                this.field_146123_n = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                int l = this.colorEnabled;
                if (this.packedFGColour != 0) {
                    l = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    l = this.colorDisabled;
                } else if (this.field_146123_n) {
                    l = this.colorHovered;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
            }
        }
    }
}

