/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.nei;

import blockrenderer6343.ClientProxy;
import blockrenderer6343.integration.gregtech.GT_GUI_MultiblocksHandler;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class GT_NEI_MultiblocksHandler
extends TemplateRecipeHandler {
    public static List<IConstructable> multiblocksList = new ArrayList<IConstructable>();
    private static final GT_GUI_MultiblocksHandler baseHandler = ClientProxy.guiMultiblocksHandler;
    public static final int CANDIDATE_SLOTS_X = 150;
    public static final int CANDIDATE_SLOTS_Y = 20;
    public static final int CANDIDATE_IN_COlUMN = 6;
    private List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private final List<PositionedStack> positionedIngredients = new ArrayList<PositionedStack>();
    private int lastRecipeHeight;
    private final RecipeCacher recipeCacher = new RecipeCacher();

    public GT_NEI_MultiblocksHandler() {
        for (IMetaTileEntity mte : GregTech_API.METATILEENTITIES) {
            if (!(mte instanceof IConstructable)) continue;
            multiblocksList.add((IConstructable)mte);
        }
    }

    public TemplateRecipeHandler newInstance() {
        return new GT_NEI_MultiblocksHandler();
    }

    public String getOverlayIdentifier() {
        return "gregtech.nei.multiblockhandler";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        this.tryLoadMultiblocks(result);
        super.loadCraftingRecipes(result);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.tryLoadMultiblocks(ingredient);
        super.loadUsageRecipes(ingredient);
    }

    public String getGuiTexture() {
        return Mods.GregTech.getResourcePath(new String[]{"textures", "gui/void.png"});
    }

    public String getRecipeName() {
        return "Multiblocks Structure";
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        baseHandler.drawMultiblock();
        if (this.lastRecipeHeight != RecipeCatalysts.getHeight()) {
            this.resetPositionedIngredients();
            this.lastRecipeHeight = RecipeCatalysts.getHeight();
        }
    }

    public void drawForeground(int recipe) {
        super.drawForeground(recipe);
    }

    private void tryLoadMultiblocks(ItemStack candidate) {
        for (IConstructable multiblock : multiblocksList) {
            ItemStack stackForm = ((IMetaTileEntity)multiblock).getStackForm(1L);
            if (!NEIClientUtils.areStacksSameType((ItemStack)stackForm, (ItemStack)candidate)) continue;
            baseHandler.setOnIngredientChanged(ingredients -> {
                this.ingredients = ingredients;
                this.resetPositionedIngredients();
            });
            baseHandler.setOnCandidateChanged(this::setResults);
            baseHandler.loadMultiblock(multiblock, stackForm);
            return;
        }
    }

    public void resetPositionedIngredients() {
        this.positionedIngredients.clear();
        int rowCount = RecipeCatalysts.getRowCount((int)RecipeCatalysts.getHeight(), (int)this.ingredients.size());
        for (int index = 0; index < this.ingredients.size(); ++index) {
            ItemStack catalyst = this.ingredients.get(index);
            int column = index / rowCount;
            int row = index % rowCount;
            this.positionedIngredients.add(new PositionedStack((Object)catalyst, -column * 16, row * 16));
        }
        Map catalystMap = RecipeCatalysts.getPositionedRecipeCatalystMap();
        catalystMap.put("gregtech.nei.multiblockhandler", this.positionedIngredients);
    }

    public void setResults(List<List<ItemStack>> results) {
        this.arecipes.clear();
        this.recipeCacher.setResults(results);
        this.arecipes.add(this.recipeCacher);
    }

    static {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new MB_RectHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new MB_RectHandler());
    }

    public class RecipeCacher
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> positionedResults;

        public RecipeCacher() {
            super((TemplateRecipeHandler)GT_NEI_MultiblocksHandler.this);
            this.positionedResults = new ArrayList<PositionedStack>();
        }

        public void setResults(List<List<ItemStack>> results) {
            this.positionedResults.clear();
            int columnCount = results.size() / 6 + 1;
            int realCandidateInColumn = results.size() % columnCount == 0 ? results.size() / columnCount : results.size() / columnCount + 1;
            for (int i = 0; i < results.size(); ++i) {
                PositionedStack result = new PositionedStack(results.get(i), 150 - (columnCount - 1) * 18 + i / realCandidateInColumn * 18, 20 + i % realCandidateInColumn * 18);
                result.generatePermutations();
                this.positionedResults.add(result);
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(GT_NEI_MultiblocksHandler.this.cycleticks / 20, this.positionedResults);
        }
    }

    public static class MB_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean canHandle(GuiContainer gui) {
            return gui instanceof GuiUsageRecipe && ((GuiUsageRecipe)gui).getHandler() instanceof GT_NEI_MultiblocksHandler || gui instanceof GuiCraftingRecipe && ((GuiCraftingRecipe)gui).getHandler() instanceof GT_NEI_MultiblocksHandler;
        }

        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            if (this.canHandle(gui)) {
                return baseHandler.mouseClicked(button);
            }
            return false;
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            if (this.canHandle(gui) && baseHandler.handleTooltip() != null) {
                currenttip.addAll(baseHandler.handleTooltip());
            }
            return currenttip;
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            baseHandler.handleMouseScrollUp(scrolled);
        }

        public void onMouseDragged(GuiContainer gui, int amousex, int amousey, int button, long heldTime) {
        }
    }
}

