/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort.color;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.common.sort.color.ColorThief;
import com.cleanroommc.modularui.utils.Color;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.awt.image.BufferedImage;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemColored;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.Nullable;

public class ItemColorHelper {
    private static final Object2IntMap<ItemStack> ITEM_COLORS = new Object2IntOpenCustomHashMap(BogoSortAPI.ITEM_META_NBT_HASH_STRATEGY);

    public static int getHue(int color) {
        if (color == 0) {
            return 0;
        }
        float r = Color.getRedF((int)color);
        float g = Color.getGreenF((int)color);
        float b = Color.getBlueF((int)color);
        if (r == g && r == b) {
            return 0;
        }
        float min = Math.min(r, Math.min(g, b));
        float hue = r >= g && r >= b ? (g - b) / (r - min) % 6.0f : (g >= r && g >= b ? (b - r) / (g - min) + 2.0f : (r - g) / (b - min) + 4.0f);
        if ((hue *= 60.0f) < 0.0f) {
            hue += 360.0f;
        }
        return (int)hue;
    }

    public static int getItemColorHue(ItemStack item) {
        int hue;
        if (item == null) {
            return 362;
        }
        if (ITEM_COLORS.containsKey((Object)item)) {
            return ITEM_COLORS.getInt((Object)item);
        }
        try {
            hue = ItemColorHelper.getHue(ItemColorHelper.getAverageItemColor(item));
        }
        catch (Exception e) {
            hue = 361;
        }
        ITEM_COLORS.put((Object)item, hue);
        return hue;
    }

    public static int getAverageItemColor(ItemStack item) {
        if (item.func_77973_b() instanceof ItemBlock) {
            return ItemColorHelper.getBlockColors(item, ((ItemBlock)item.func_77973_b()).field_150939_a);
        }
        return ItemColorHelper.getItemColors(item);
    }

    private static int getItemColors(ItemStack itemStack) {
        try {
            ItemColored itemColors = new ItemColored(((ItemBlock)Objects.requireNonNull(itemStack.func_77973_b())).field_150939_a, false);
            int renderColor = itemColors.func_82790_a(itemStack, 0);
            TextureAtlasSprite textureAtlasSprite = ItemColorHelper.getTextureAtlasSprite(itemStack);
            return ItemColorHelper.getColors(textureAtlasSprite, renderColor);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private static int getBlockColors(ItemStack itemStack, Block block) {
        Block State2;
        int meta = itemStack.func_77960_j();
        try {
            State2 = Block.func_149729_e((int)meta);
        }
        catch (LinkageError | RuntimeException ignored) {
            State2 = block;
        }
        int renderColor = -1;
        try {
            State2.func_149720_d(null, 0, 0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static int getColors(TextureAtlasSprite textureAtlasSprite, int renderColor) {
        BufferedImage bufferedImage;
        int[] color = textureAtlasSprite == null ? new int[]{0, 0, 0} : ((bufferedImage = ItemColorHelper.getBufferedImage(textureAtlasSprite)) == null ? new int[]{0, 0, 0} : ColorThief.getColor(bufferedImage, 10, true));
        if (color == null) {
            return 0;
        }
        int red = (int)((float)(color[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
        int green = (int)((float)(color[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
        int blue = (int)((float)(color[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
        red = MathHelper.func_76125_a((int)red, (int)0, (int)255);
        green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        blue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
        return Color.rgb((int)red, (int)green, (int)blue);
    }

    @Nullable
    private static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(Block block) {
        IIcon icon;
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureMap textureMap = minecraft.func_147117_R();
        TextureAtlasSprite textureAtlasSprite = textureMap.getTextureExtry((icon = block.func_149733_h(0)).func_94215_i());
        if (textureAtlasSprite == textureMap.func_110572_b("missingno")) {
            return null;
        }
        return textureAtlasSprite;
    }

    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        return null;
    }
}

