/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.config;

import com.gtnewhorizon.gtnhlib.config.Config;
import yalter.mousetweaks.Main;

@Config(modid="MouseTweaks")
public class MTConfig {
    @Config.Comment(value={"Like vanilla right click dragging, but dragging over a slot multiple times puts the item there multiple times."})
    @Config.Name(value="RMB tweak")
    public static boolean rmbTweak = true;
    @Config.Comment(value={"Left click and drag with an item to \"left click\" items of the same type."})
    @Config.Name(value="LMB tweak with item")
    public static boolean lmbTweakWithItem = true;
    @Config.Comment(value={"Hold shift, left click and drag without an item to \"shift left click\" items."})
    @Config.Name(value="LMB tweak without item")
    public static boolean lmbTweakWithoutItem = true;
    @Config.Comment(value={"Scroll over items to move them between inventories."})
    @Config.Name(value="Wheel tweak")
    public static boolean wheelTweak = true;
    @Config.Comment(value={"How to pick the source slot when pulling items via scrolling."})
    @Config.Name(value="Wheel tweak search order")
    public static WheelSearchOrder wheelSearchOrder = WheelSearchOrder.LAST_TO_FIRST;
    @Config.Comment(value={"Inventory position aware means scroll up to push items from the bottom inventory and pull into the top inventory, and vice versa."})
    @Config.Name(value="Wheel tweak scroll direction")
    public static WheelScrollDirection wheelScrollDirection = WheelScrollDirection.NORMAL;
    @Config.Comment(value={"This determines how many items are moved when you scroll. On some setups (notably macOS), scrolling the wheel with different speeds results in different distances scrolled per wheel \"bump\". To make those setups play nicely with Mouse Tweaks, set this option to \"Always exactly one item\"."})
    @Config.Name(value="Scroll item scaling")
    public static ScrollItemScaling scrollItemScaling = ScrollItemScaling.PROPORTIONAL;

    public static enum WheelSearchOrder {
        FIRST_TO_LAST("First to last"),
        LAST_TO_FIRST("Last to first");

        private final String id;

        private WheelSearchOrder(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.id;
        }

        public static WheelSearchOrder fromId(int ordinal) {
            return ordinal == 0 ? FIRST_TO_LAST : LAST_TO_FIRST;
        }

        public String toString() {
            return this.getValue();
        }
    }

    public static enum WheelScrollDirection {
        NORMAL("Down to push, up to pull"),
        INVERTED("Up to push, down to pull"),
        INVENTORY_POSITION_AWARE("Inventory position aware"),
        INVENTORY_POSITION_AWARE_INVERTED("Inventory position aware, inverted");

        private final String id;
        private static final WheelScrollDirection[] values;

        private WheelScrollDirection(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.id;
        }

        public static WheelScrollDirection fromId(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return NORMAL;
                }
                case 1: {
                    return INVERTED;
                }
                case 2: {
                    return INVENTORY_POSITION_AWARE;
                }
            }
            return INVENTORY_POSITION_AWARE_INVERTED;
        }

        public boolean isInverted() {
            return this.ordinal() % 2 == 1;
        }

        public boolean isPositionAware() {
            return this.ordinal() > 1;
        }

        public String toString() {
            return this.getValue();
        }

        static {
            values = WheelScrollDirection.values();
        }
    }

    public static enum ScrollItemScaling {
        PROPORTIONAL("Relative to scroll amount"),
        ALWAYS_ONE("Always exactly one item");

        public static final int scrollStep = 120;
        private final String id;

        private ScrollItemScaling(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.id;
        }

        public static ScrollItemScaling fromId(int ordinal) {
            return ordinal == 0 ? PROPORTIONAL : ALWAYS_ONE;
        }

        public int scale(int scrollDelta) {
            switch (this) {
                case PROPORTIONAL: {
                    return !Main.isLwjgl3Loaded() ? scrollDelta : Integer.signum(scrollDelta) * 120;
                }
                case ALWAYS_ONE: {
                    return Integer.signum(scrollDelta) * 120;
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            return this.getValue();
        }
    }
}

