/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.DockingStation;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class StationIndex {
    public BlockIndex index = new BlockIndex();
    public ForgeDirection side = ForgeDirection.UNKNOWN;

    protected StationIndex() {
    }

    public StationIndex(ForgeDirection iSide, int x, int y, int z) {
        this.side = iSide;
        this.index = new BlockIndex(x, y, z);
    }

    public StationIndex(DockingStation station) {
        this.side = station.side();
        this.index = station.index();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StationIndex compareId = (StationIndex)obj;
        return this.index.equals(compareId.index) && this.side == compareId.side;
    }

    public int hashCode() {
        return this.index.hashCode() * 37 + this.side.ordinal();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.func_74782_a("index", (NBTBase)indexNBT);
        nbt.func_74774_a("side", (byte)this.side.ordinal());
    }

    protected void readFromNBT(NBTTagCompound nbt) {
        this.index = new BlockIndex(nbt.func_74775_l("index"));
        this.side = ForgeDirection.values()[nbt.func_74771_c("side")];
    }
}

