/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.config.Property;

public class Version
implements Runnable {
    public static final String VERSION = "7.1.38";
    public static EnumUpdateState currentVersion = EnumUpdateState.CURRENT;
    private static final String REMOTE_CHANGELOG_ROOT = "https://raw.githubusercontent.com/BuildCraft/BuildCraft/master/buildcraft_resources/changelog/";
    private static String recommendedVersion;
    private static String[] cachedChangelog;
    private static Version instance;
    private static boolean sentIMCOutdatedMessage;

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isOutdated() {
        return currentVersion == EnumUpdateState.OUTDATED;
    }

    public static boolean needsUpdateNoticeAndMarkAsSeen() {
        if (!Version.isOutdated() || sentIMCOutdatedMessage) {
            return false;
        }
        Property property = BuildCraftCore.mainConfiguration.get("vars", "version.seen", VERSION);
        property.comment = "indicates the last version the user has been informed about and will suppress further notices on it.";
        String seenVersion = property.getString();
        if (recommendedVersion == null || recommendedVersion.equals(seenVersion)) {
            return false;
        }
        property.set(recommendedVersion);
        BuildCraftCore.mainConfiguration.save();
        return true;
    }

    public static String getRecommendedVersion() {
        return recommendedVersion;
    }

    public static String[] getChangelog() {
        if (cachedChangelog == null) {
            cachedChangelog = Version.grabChangelog(recommendedVersion);
        }
        return cachedChangelog;
    }

    public static String[] grabChangelog(String version) {
        try {
            String line;
            String location = REMOTE_CHANGELOG_ROOT + version;
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                if (conn != null) {
                    ((HttpURLConnection)conn).disconnect();
                }
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            if (conn == null) {
                throw new NullPointerException();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            ArrayList<String> changelog = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                changelog.add(line);
            }
            ((HttpURLConnection)conn).disconnect();
            return changelog.toArray(new String[changelog.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BCLog.logger.warn("Unable to read changelog from remote site.");
            return new String[]{String.format("Unable to retrieve changelog for %s %s", "BuildCraft", version)};
        }
    }

    @Override
    public void run() {
    }

    public static void sendIMCOutdatedMessage() {
        if (Loader.isModLoaded((String)"VersionChecker")) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("modDisplayName", "BuildCraft");
            compound.func_74778_a("oldVersion", VERSION);
            compound.func_74778_a("newVersion", Version.getRecommendedVersion());
            compound.func_74778_a("updateUrl", "http://www.mod-buildcraft.com/download/");
            compound.func_74757_a("isDirectLink", false);
            StringBuilder stringBuilder = new StringBuilder();
            for (String changeLogLine : Version.getChangelog()) {
                stringBuilder.append(changeLogLine).append("\n");
            }
            compound.func_74778_a("changeLog", stringBuilder.toString());
            FMLInterModComms.sendRuntimeMessage((Object)"BuildCraft|Core", (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)compound);
            sentIMCOutdatedMessage = true;
        }
    }

    public static void displayChangelog(ICommandSender sender) {
        sender.func_145747_a(new ChatComponentTranslation("command.buildcraft.changelog_header", new Object[]{Version.getRecommendedVersion()}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY).func_150227_a(Boolean.valueOf(true))));
        for (String updateLine : Version.getChangelog()) {
            EnumChatFormatting format = EnumChatFormatting.BLUE;
            if (updateLine.startsWith("*")) {
                format = EnumChatFormatting.WHITE;
            } else if (updateLine.trim().endsWith(":")) {
                format = EnumChatFormatting.GOLD;
            }
            sender.func_145747_a(new ChatComponentText(updateLine).func_150255_a(new ChatStyle().func_150238_a(format)));
        }
    }

    public static void check() {
        new Thread(instance).start();
    }

    static {
        instance = new Version();
        sentIMCOutdatedMessage = false;
    }

    public static enum EnumUpdateState {
        CURRENT,
        OUTDATED,
        CONNECTION_ERROR;

    }
}

