/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.api.transport.IStripesPipe;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.statements.ActionPipeDirection;
import buildcraft.transport.utils.TransportUtils;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

public class PipeItemsStripes
extends Pipe<PipeTransportItems>
implements IEnergyHandler,
IStripesPipe {
    private RFBattery battery = new RFBattery(16000, 640, 0);
    private ForgeDirection actionDir = ForgeDirection.UNKNOWN;

    public PipeItemsStripes(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.battery.getEnergyStored() >= 10) {
            ForgeDirection o = this.actionDir;
            if (o == ForgeDirection.UNKNOWN) {
                o = this.getOpenOrientation();
            }
            if (o != ForgeDirection.UNKNOWN) {
                Position p = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, o);
                p.moveForwards(1.0);
                if (!BlockUtils.isUnbreakableBlock(this.getWorld(), (int)p.x, (int)p.y, (int)p.z)) {
                    Block block = this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z);
                    int metadata = this.getWorld().func_72805_g((int)p.x, (int)p.y, (int)p.z);
                    if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
                        return;
                    }
                    ItemStack stack = new ItemStack(block, 1, metadata);
                    EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), (int)p.x, (int)p.y, (int)p.z).get();
                    if (this.battery.useEnergy(10, 10, false) != 10) {
                        return;
                    }
                    for (IStripesHandler handler : PipeManager.stripesHandlers) {
                        if (handler.getType() != IStripesHandler.StripesHandlerType.BLOCK_BREAK || !handler.shouldHandle(stack) || !handler.handle(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, o, stack, player, this)) continue;
                        return;
                    }
                    ArrayList stacks = block.getDrops(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, metadata, 0);
                    if (stacks != null) {
                        for (ItemStack s : stacks) {
                            if (s == null) continue;
                            this.sendItem(s, o.getOpposite());
                        }
                    }
                    this.getWorld().func_147468_f((int)p.x, (int)p.y, (int)p.z);
                }
            }
            return;
        }
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        ForgeDirection direction = this.actionDir;
        if (direction == ForgeDirection.UNKNOWN) {
            direction = event.direction;
        }
        Position p = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, direction);
        p.moveForwards(1.0);
        ItemStack stack = event.entity.func_92059_d();
        EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), (int)p.x, (int)p.y, (int)p.z).get();
        switch (direction) {
            case DOWN: {
                player.field_70125_A = 90.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case UP: {
                player.field_70125_A = 270.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case NORTH: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case WEST: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 90.0f;
                break;
            }
            case EAST: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 270.0f;
                break;
            }
        }
        for (IStripesHandler handler : PipeManager.stripesHandlers) {
            if (handler.getType() != IStripesHandler.StripesHandlerType.ITEM_USE || !handler.shouldHandle(stack) || !handler.handle(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, direction, stack, player, this)) continue;
            event.entity = null;
            return;
        }
    }

    @Override
    public void dropItem(ItemStack itemStack, ForgeDirection direction) {
        Position p = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, direction);
        p.moveForwards(1.0);
        InvUtils.dropItems(this.getWorld(), itemStack, (int)p.x, (int)p.y, (int)p.z);
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> action = super.getActions();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        this.actionDir = ForgeDirection.UNKNOWN;
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeDirection)) continue;
            this.actionDir = ((ActionPipeDirection)action.statement).direction;
            break;
        }
    }

    @Override
    public void sendItem(ItemStack itemStack, ForgeDirection direction) {
        Position pos = new Position((double)this.container.field_145851_c + 0.5, (float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(itemStack), (double)this.container.field_145849_e + 0.5, direction);
        pos.moveBackwards(0.25);
        TravelingItem newItem = TravelingItem.make(pos.x, pos.y, pos.z, itemStack);
        ((PipeTransportItems)this.transport).injectItem(newItem, direction);
    }

    @Override
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return PipeIconProvider.TYPE.Stripes.ordinal();
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        IPipeTile tilePipe;
        if (tile instanceof IPipeTile && (tilePipe = (IPipeTile)tile).getPipe() instanceof PipeItemsStripes) {
            return false;
        }
        return super.canPipeConnect(tile, side);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 10;
    }
}

