/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftMod;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.compat.CompatModuleAMT;
import buildcraft.compat.CompatModuleAgriCraft;
import buildcraft.compat.CompatModuleAquaTweaks;
import buildcraft.compat.CompatModuleBase;
import buildcraft.compat.CompatModuleBigReactors;
import buildcraft.compat.CompatModuleBinnie;
import buildcraft.compat.CompatModuleBundledRedstone;
import buildcraft.compat.CompatModuleCarpentersBlocks;
import buildcraft.compat.CompatModuleEnderIO;
import buildcraft.compat.CompatModuleEnderStorage;
import buildcraft.compat.CompatModuleFMP;
import buildcraft.compat.CompatModuleFactorization;
import buildcraft.compat.CompatModuleForbiddenMagic;
import buildcraft.compat.CompatModuleForestry;
import buildcraft.compat.CompatModuleImmersiveEngineering;
import buildcraft.compat.CompatModuleImmibisMicroblocks;
import buildcraft.compat.CompatModuleIronChest;
import buildcraft.compat.CompatModuleMFR;
import buildcraft.compat.CompatModuleMagicCrops;
import buildcraft.compat.CompatModuleMineTweaker3;
import buildcraft.compat.CompatModuleNEI;
import buildcraft.compat.CompatModuleNatura;
import buildcraft.compat.CompatModulePamHarvestCraft;
import buildcraft.compat.CompatModuleRailcraft;
import buildcraft.compat.CompatModuleRedLogic;
import buildcraft.compat.CompatModuleRemainInMotion;
import buildcraft.compat.CompatModuleThermalExpansion;
import buildcraft.compat.CompatModuleWAILA;
import buildcraft.compat.CompatModuleWitchery;
import buildcraft.compat.forestry.pipes.network.PacketGenomeFilterChange;
import buildcraft.compat.forestry.pipes.network.PacketRequestFilterSet;
import buildcraft.compat.forestry.pipes.network.PacketTypeFilterChange;
import buildcraft.core.lib.network.ChannelHandler;
import buildcraft.gui.CompatGuiHandler;
import buildcraft.network.PacketHandlerCompat;
import buildcraft.texture.TextureManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@Mod(name="BuildCraft Compat", version="7.1.16", useMetadata=false, modid="BuildCraft|Compat", acceptedMinecraftVersions="[1.7.10,1.8)", dependencies="required-after:Forge@[10.13.0.1179,);required-after:BuildCraft|Core;after:Forestry;after:BuildCraft|Transport;after:BuildCraft|Builders;after:ThermalExpansion")
public class BuildCraftCompat
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Compat")
    public static BuildCraftCompat instance;
    private static Configuration config;
    private static final HashSet<CompatModuleBase> modules;
    private static final HashSet<String> moduleNames;
    private static ChannelHandler compatChannelHandler;

    public Configuration getConfig() {
        return config;
    }

    private void offerModule(CompatModuleBase module) {
        Property prop = config.get("modules", module.name(), true);
        if (module.canLoad() && prop.getBoolean(true)) {
            modules.add(module);
            moduleNames.add(module.name());
        }
    }

    public static boolean isLoaded(String module) {
        return moduleNames.contains(module);
    }

    public static EntityPlayer getFakePlayerAbove(World world, int x, int y, int z) {
        EntityPlayer player = (EntityPlayer)BuildCraftAPI.proxy.getBuildCraftPlayer((WorldServer)world).get();
        if (player != null) {
            player.field_70165_t = x;
            player.field_70163_u = (float)y + 1.5f;
            player.field_70161_v = z;
        }
        return player;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        config = new Configuration(new File(new File(evt.getSuggestedConfigurationFile().getParentFile(), "buildcraft"), "compat.cfg"));
        config.load();
        this.offerModule(new CompatModuleWitchery());
        this.offerModule(new CompatModuleAMT());
        this.offerModule(new CompatModuleAquaTweaks());
        this.offerModule(new CompatModuleFMP());
        this.offerModule(new CompatModuleForestry());
        this.offerModule(new CompatModuleRailcraft());
        this.offerModule(new CompatModuleRedLogic());
        this.offerModule(new CompatModuleImmibisMicroblocks());
        this.offerModule(new CompatModuleMFR());
        this.offerModule(new CompatModuleMineTweaker3());
        this.offerModule(new CompatModuleNEI());
        this.offerModule(new CompatModuleCarpentersBlocks());
        this.offerModule(new CompatModuleIronChest());
        this.offerModule(new CompatModuleWAILA());
        this.offerModule(new CompatModuleBundledRedstone());
        this.offerModule(new CompatModuleAgriCraft());
        this.offerModule(new CompatModulePamHarvestCraft());
        this.offerModule(new CompatModuleBinnie());
        this.offerModule(new CompatModuleEnderIO());
        this.offerModule(new CompatModuleBigReactors());
        this.offerModule(new CompatModuleFactorization());
        this.offerModule(new CompatModuleImmersiveEngineering());
        this.offerModule(new CompatModuleEnderStorage());
        this.offerModule(new CompatModuleThermalExpansion());
        this.offerModule(new CompatModuleRemainInMotion());
        this.offerModule(new CompatModuleMagicCrops());
        this.offerModule(new CompatModuleNatura());
        this.offerModule(new CompatModuleForbiddenMagic());
        config.save();
        for (CompatModuleBase m : modules) {
            m.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new CompatGuiHandler());
        compatChannelHandler = new ChannelHandler();
        MinecraftForge.EVENT_BUS.register((Object)this);
        compatChannelHandler.registerPacketType(PacketGenomeFilterChange.class);
        compatChannelHandler.registerPacketType(PacketTypeFilterChange.class);
        compatChannelHandler.registerPacketType(PacketRequestFilterSet.class);
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-COMPAT", new io.netty.channel.ChannelHandler[]{compatChannelHandler, new PacketHandlerCompat()});
        for (CompatModuleBase m : modules) {
            BCLog.logger.info("Loading compat module " + m.name());
            m.init();
        }
        config.save();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        for (CompatModuleBase m : modules) {
            m.postInit();
        }
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        CompatModuleForestry.missingMapping(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            TextureManager.getInstance().initIcons((IIconRegister)event.map);
        }
    }

    public static boolean hasModule(String module) {
        return moduleNames.contains(module);
    }

    static {
        modules = new HashSet();
        moduleNames = new HashSet();
    }
}

