/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks;

import com.thecodewarrior.catwalks.block.BlockCagedLadder;
import com.thecodewarrior.catwalks.block.BlockCatwalk;
import com.thecodewarrior.catwalks.block.BlockScaffold;
import com.thecodewarrior.catwalks.block.BlockSturdyRail;
import com.thecodewarrior.catwalks.block.BlockSturdyRailActivator;
import com.thecodewarrior.catwalks.block.BlockSturdyRailBooster;
import com.thecodewarrior.catwalks.block.BlockSturdyRailDetector;
import com.thecodewarrior.catwalks.block.BlockSupportColumn;
import com.thecodewarrior.catwalks.item.ItemBlockScaffold;
import com.thecodewarrior.catwalks.item.ItemBlockSupportColumn;
import com.thecodewarrior.catwalks.item.ItemBlowtorch;
import com.thecodewarrior.catwalks.item.ItemCautionTape;
import com.thecodewarrior.catwalks.item.ItemRopeLight;
import com.thecodewarrior.catwalks.item.ItemSteelGrate;
import com.thecodewarrior.catwalks.util.CatwalkOptions;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import com.thecodewarrior.catwalks.util.CommonProxy;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="catwalks", name="Catwalks", version="2.0.4")
public class CatwalkMod {
    public static final String MODID = "catwalks";
    public static final String MODNAME = "Catwalks";
    public static final String MODVER = "2.0.4";
    public static final String loggerName = "Catwalks";
    public static Logger l;
    @Mod.Instance(value="catwalks")
    public static CatwalkMod instance;
    public static CatwalkOptions options;
    public static CreativeTabs catwalkTab;
    public static Block.SoundType catwalkSounds;
    public static Block.SoundType ladderSounds;
    public static Block sturdyTrack;
    public static Block sturdyPoweredTrack;
    public static Block sturdyDetectorTrack;
    public static Block sturdyActivatorTrack;
    public static Block supportColumn;
    public static Block scaffold;
    public static Block defaultCatwalk;
    public static Map<Boolean, Map<Boolean, Map<Boolean, Block>>> catwalks;
    public static Block defaultLadder;
    public static Map<ForgeDirection, Map<Boolean, Map<Boolean, Map<Boolean, Block>>>> ladders;
    public static Item itemBlowtorch;
    public static Item itemRopeLight;
    public static Item itemCautionTape;
    public static Item itemSteelGrate;
    public static int speedEffectLevel;
    public static AttributeModifier speedModifier;
    @SidedProxy(clientSide="com.thecodewarrior.catwalks.util.ClientProxy", serverSide="com.thecodewarrior.catwalks.util.CommonProxy")
    public static CommonProxy proxy;
    public static int catwalkRenderType;
    public static int ladderRenderType;
    public static int inAndOutRenderType;
    public static int supportRenderType;
    public static int lightLevel;

    public static Logger logger(String ... name) {
        if (name.length > 0) {
            return LogManager.getLogger((String)("Catwalks][" + StringUtils.join((Object[])name, (String)"][")));
        }
        return LogManager.getLogger((String)"Catwalks");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        l = CatwalkMod.logger(new String[0]);
        CatwalkUtil.init();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        options.init();
        options.load(config);
        catwalkTab = new CreativeTabs(MODID){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return Item.func_150898_a((Block)scaffold);
            }
        };
        catwalkRenderType = RenderingRegistry.getNextAvailableRenderId();
        ladderRenderType = RenderingRegistry.getNextAvailableRenderId();
        inAndOutRenderType = RenderingRegistry.getNextAvailableRenderId();
        supportRenderType = RenderingRegistry.getNextAvailableRenderId();
        catwalkSounds = Block.field_149777_j;
        ladderSounds = Block.field_149774_o;
        FMLCommonHandler.instance().bus().register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        speedModifier = new AttributeModifier("catwalkmod.speedup", (double)0.2f, 2);
        speedModifier.func_111168_a(false);
        this.registerItems();
    }

    public void registerItems() {
        boolean[] trueFalse = new boolean[]{true, false};
        sturdyTrack = new BlockSturdyRail();
        GameRegistry.registerBlock((Block)sturdyTrack, (String)"sturdy_rail");
        sturdyPoweredTrack = new BlockSturdyRailBooster();
        GameRegistry.registerBlock((Block)sturdyPoweredTrack, (String)"sturdy_rail_powered");
        sturdyDetectorTrack = new BlockSturdyRailDetector();
        GameRegistry.registerBlock((Block)sturdyDetectorTrack, (String)"sturdy_rail_detector");
        sturdyActivatorTrack = new BlockSturdyRailActivator();
        GameRegistry.registerBlock((Block)sturdyActivatorTrack, (String)"sturdy_rail_activator");
        supportColumn = new BlockSupportColumn();
        GameRegistry.registerBlock((Block)supportColumn, ItemBlockSupportColumn.class, (String)"support_column");
        scaffold = new BlockScaffold();
        GameRegistry.registerBlock((Block)scaffold, ItemBlockScaffold.class, (String)"scaffold");
        catwalks = new HashMap<Boolean, Map<Boolean, Map<Boolean, Block>>>();
        for (boolean lights : trueFalse) {
            HashMap lightMap = new HashMap();
            catwalks.put(lights, lightMap);
            for (boolean bottom : trueFalse) {
                HashMap<Boolean, BlockCatwalk> bottomMap = new HashMap<Boolean, BlockCatwalk>();
                lightMap.put(bottom, bottomMap);
                for (boolean tape : trueFalse) {
                    BlockCatwalk b = new BlockCatwalk(lights, bottom, tape);
                    bottomMap.put(tape, b);
                    String id = "catwalk";
                    id = id + (lights ? "_lit" : "_unlit");
                    if (!bottom) {
                        id = id + "_nobottom";
                    }
                    if (tape) {
                        id = id + "_tape";
                    }
                    GameRegistry.registerBlock((Block)b, (String)id);
                }
            }
        }
        defaultCatwalk = catwalks.get(false).get(true).get(false);
        ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
        ladders = new HashMap<ForgeDirection, Map<Boolean, Map<Boolean, Map<Boolean, Block>>>>();
        for (ForgeDirection dir : directions) {
            HashMap dirMap = new HashMap();
            ladders.put(dir, dirMap);
            for (boolean lights : trueFalse) {
                HashMap lightMap = new HashMap();
                dirMap.put(lights, lightMap);
                for (boolean bottomOpen : trueFalse) {
                    HashMap<Boolean, BlockCagedLadder> bottomMap = new HashMap<Boolean, BlockCagedLadder>();
                    lightMap.put(bottomOpen, bottomMap);
                    for (boolean tape : trueFalse) {
                        BlockCagedLadder b = new BlockCagedLadder(dir, lights, bottomOpen, tape);
                        bottomMap.put(tape, b);
                        String id = "cagedLadder";
                        if (dir == ForgeDirection.NORTH) {
                            id = id + "_north";
                        }
                        if (dir == ForgeDirection.SOUTH) {
                            id = id + "_south";
                        }
                        if (dir == ForgeDirection.WEST) {
                            id = id + "_west";
                        }
                        if (dir == ForgeDirection.EAST) {
                            id = id + "_east";
                        }
                        id = lights ? id + "_lit" : id + "_unlit";
                        if (bottomOpen) {
                            id = id + "_nobottom";
                        }
                        if (tape) {
                            id = id + "_tape";
                        }
                        GameRegistry.registerBlock((Block)b, (String)id);
                    }
                }
            }
        }
        defaultLadder = ladders.get(ForgeDirection.NORTH).get(false).get(false).get(false);
        itemBlowtorch = new ItemBlowtorch();
        itemRopeLight = new ItemRopeLight();
        itemCautionTape = new ItemCautionTape();
        itemSteelGrate = new ItemSteelGrate();
        GameRegistry.registerItem((Item)itemBlowtorch, (String)"blowtorch");
        GameRegistry.registerItem((Item)itemRopeLight, (String)"ropeLight");
        GameRegistry.registerItem((Item)itemCautionTape, (String)"cautionTape");
        GameRegistry.registerItem((Item)itemSteelGrate, (String)"steelgrate");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemBlowtorch), new Object[]{"FXX", "XIX", "XXI", Character.valueOf('F'), Items.field_151033_d, Character.valueOf('I'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemCautionTape, 16), new Object[]{"dyeYellow", "dyeBlack", "slimeball"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemRopeLight, 8), new Object[]{"GSG", Character.valueOf('G'), "dustGlowstone", Character.valueOf('S'), Items.field_151007_F}));
        if (CatwalkMod.options.altGrateRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemSteelGrate, 16), new Object[]{"IXI", "BBB", "IXI", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), Blocks.field_150411_aY}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemSteelGrate, 16), new Object[]{"IXI", "XIX", "IXI", Character.valueOf('I'), "ingotIron"}));
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(defaultCatwalk, 3), (Object[])new Object[]{"GXG", "XGX", Character.valueOf('G'), itemSteelGrate});
        GameRegistry.addRecipe((ItemStack)new ItemStack(defaultLadder, 3), (Object[])new Object[]{"GLG", "XGX", Character.valueOf('G'), itemSteelGrate, Character.valueOf('L'), Item.func_150898_a((Block)Blocks.field_150468_ap)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(scaffold, 4), (Object[])new Object[]{"GG", "GG", Character.valueOf('G'), itemSteelGrate});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(scaffold, 1, 1), (Object[])new Object[]{new ItemStack(scaffold, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(scaffold, 1, 0), (Object[])new Object[]{new ItemStack(scaffold, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(supportColumn, 4), (Object[])new Object[]{"G", "G", Character.valueOf('G'), itemSteelGrate});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(sturdyTrack, 1), (Object[])new Object[]{itemSteelGrate, Blocks.field_150448_aq});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(sturdyPoweredTrack, 1), (Object[])new Object[]{itemSteelGrate, Blocks.field_150318_D});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(sturdyDetectorTrack, 1), (Object[])new Object[]{itemSteelGrate, Blocks.field_150319_E});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(sturdyActivatorTrack, 1), (Object[])new Object[]{itemSteelGrate, Blocks.field_150408_cc});
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        options.postInit();
    }

    static {
        options = new CatwalkOptions();
        speedEffectLevel = 2;
        lightLevel = 12;
    }
}

