/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.render;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.TesselatorVertexState;
import org.joml.Matrix4dStack;
import org.joml.Vector3d;

public class TransformingTessellator {
    private static final ThreadLocal<TransformingTessellator> instance = ThreadLocal.withInitial(TransformingTessellator::new);
    private final Matrix4dStack matrixStack = new Matrix4dStack(16);
    private Tessellator t = null;
    private final Vector3d tempVec = new Vector3d();

    public static TransformingTessellator getInstance() {
        return instance.get().setTessellator(Tessellator.field_78398_a);
    }

    private TransformingTessellator setTessellator(Tessellator t) {
        this.t = t;
        return this;
    }

    public void pushMatrix() {
        this.matrixStack.pushMatrix();
    }

    public void popMatrix() {
        this.matrixStack.popMatrix();
    }

    public void translate(double x, double y, double z) {
        this.matrixStack.translate(x, y, z);
    }

    public void scale(double x, double y, double z) {
        this.matrixStack.scale(x, y, z);
    }

    public void rotate(double angle, double x, double y, double z) {
        angle = angle / 180.0 * Math.PI;
        this.matrixStack.rotate(angle, x, y, z);
    }

    public TesselatorVertexState getVertexState(float x, float y, float z) {
        Vector3d vec = this.get(x, y, z);
        return this.t.func_147564_a((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        this.t.func_78385_a(u, v);
        this.addVertex(x, y, z);
    }

    public void addVertex(double x, double y, double z) {
        Vector3d vec = this.get(x, y, z);
        this.t.func_78377_a(vec.x, vec.y, vec.z);
    }

    public void setNormal(float x, float y, float z) {
        Vector3d vec = this.getN(x, y, z);
        this.t.func_78375_b((float)vec.x, (float)vec.y, (float)vec.z);
    }

    Vector3d get(double x, double y, double z) {
        this.tempVec.set(x, y, z);
        this.apply(this.tempVec);
        return this.tempVec;
    }

    Vector3d getN(double x, double y, double z) {
        Vector3d vec = this.get(x, y, z);
        this.applyN(vec);
        return vec;
    }

    public void apply(Vector3d vec) {
        this.matrixStack.transformPosition(vec);
    }

    public void applyN(Vector3d vec) {
        this.apply(vec);
        vec.normalize();
    }

    public int draw() {
        return this.t.func_78381_a();
    }

    public void setVertexState(TesselatorVertexState p_147565_1_) {
        this.t.func_147565_a(p_147565_1_);
    }

    public void startDrawingQuads() {
        this.t.func_78382_b();
    }

    public void startDrawing(int p_78371_1_) {
        this.t.func_78371_b(p_78371_1_);
    }

    public void setTextureUV(double p_78385_1_, double p_78385_3_) {
        this.t.func_78385_a(p_78385_1_, p_78385_3_);
    }

    public void setBrightness(int p_78380_1_) {
        this.t.func_78380_c(p_78380_1_);
    }

    public void setColorOpaque_F(float p_78386_1_, float p_78386_2_, float p_78386_3_) {
        this.t.func_78386_a(p_78386_1_, p_78386_2_, p_78386_3_);
    }

    public void setColorRGBA_F(float p_78369_1_, float p_78369_2_, float p_78369_3_, float p_78369_4_) {
        this.t.func_78369_a(p_78369_1_, p_78369_2_, p_78369_3_, p_78369_4_);
    }

    public void setColorOpaque(int p_78376_1_, int p_78376_2_, int p_78376_3_) {
        this.t.func_78376_a(p_78376_1_, p_78376_2_, p_78376_3_);
    }

    public void setColorRGBA(int p_78370_1_, int p_78370_2_, int p_78370_3_, int p_78370_4_) {
        this.t.func_78370_a(p_78370_1_, p_78370_2_, p_78370_3_, p_78370_4_);
    }

    public void func_154352_a(byte p_154352_1_, byte p_154352_2_, byte p_154352_3_) {
        this.t.func_154352_a(p_154352_1_, p_154352_2_, p_154352_3_);
    }

    public void setColorOpaque_I(int p_78378_1_) {
        this.t.func_78378_d(p_78378_1_);
    }

    public void setColorRGBA_I(int p_78384_1_, int p_78384_2_) {
        this.t.func_78384_a(p_78384_1_, p_78384_2_);
    }

    public void disableColor() {
        this.t.func_78383_c();
    }

    public void setTranslation(double p_78373_1_, double p_78373_3_, double p_78373_5_) {
        this.t.func_78373_b(p_78373_1_, p_78373_3_, p_78373_5_);
    }

    public void addTranslation(float p_78372_1_, float p_78372_2_, float p_78372_3_) {
        this.t.func_78372_c(p_78372_1_, p_78372_2_, p_78372_3_);
    }
}

