/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.util;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class ResourceManager {
    static List<IIcon[]> particleIcons = new ArrayList<IIcon[]>();
    static ResourceLocation particles = new ResourceLocation("catwalks", "textures/particles.png");
    static ResourceLocation defaultParticles;

    public static void refreshIcons() {
        particleIcons = new ArrayList<IIcon[]>();
        float widthPer = 1.0f / (float)ResourceManager.getParticleCount();
        float heightPer = 1.0f / (float)ResourceManager.getParticleFrames();
        for (int i = 0; i < ResourceManager.getParticleCount(); ++i) {
            IIcon[] arr = new IIcon[ResourceManager.getParticleLength(i)];
            particleIcons.add(arr);
            for (int f = 0; f < ResourceManager.getParticleLength(i); ++f) {
                BasicIcon icon = new BasicIcon((float)i * widthPer, (float)f * heightPer, (float)(i + 1) * widthPer, (float)(f + 1) * heightPer, 8, 8);
                arr[f] = icon;
            }
        }
    }

    public static int getParticleCount() {
        return 8;
    }

    public static int getParticleFrames() {
        return 8;
    }

    public static int getParticleLength(int particle) {
        switch (particle) {
            case 0: {
                return 8;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 8;
            }
        }
        return 1;
    }

    public static IIcon[] getParticle(int position) {
        if (ResourceManager.getParticleCount() != particleIcons.size()) {
            ResourceManager.refreshIcons();
        }
        if (position >= particleIcons.size()) {
            return ResourceManager.getParticle(0);
        }
        return particleIcons.get(position);
    }

    public static void bindParticles() {
        ResourceManager.bindTexture(particles);
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void bindDefaultParticles() {
        if (defaultParticles == null) {
            try {
                defaultParticles = (ResourceLocation)ReflectionHelper.getPrivateValue(EffectRenderer.class, null, (String[])new String[]{"particleTextures", "field_110737_b"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultParticles != null) {
            ResourceManager.bindTexture(defaultParticles);
        }
    }

    public static class BasicIcon
    implements IIcon {
        float minU;
        float minV;
        float maxU;
        float maxV;
        int width;
        int height;

        public BasicIcon(float minU, float minV, float maxU, float maxV, int width, int height) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            this.width = width;
            this.height = height;
        }

        public int func_94211_a() {
            return this.width;
        }

        public int func_94216_b() {
            return this.height;
        }

        public float func_94209_e() {
            return this.minU;
        }

        public float func_94212_f() {
            return this.maxU;
        }

        public float func_94214_a(double d) {
            return (float)((double)this.minU + (double)(this.maxU - this.minU) * d);
        }

        public float func_94206_g() {
            return this.minV;
        }

        public float func_94210_h() {
            return this.maxV;
        }

        public float func_94207_b(double d) {
            return (float)((double)this.minV + (double)(this.maxV - this.minV) * d);
        }

        public String func_94215_i() {
            return "[BASIC ICON " + Integer.toHexString(this.hashCode()) + "]";
        }
    }
}

