/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization.transformercache.full;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.Persistence;
import makamys.coretweaks.optimization.transformercache.full.WrappedTransformerList;
import makamys.coretweaks.util.Util;
import makamys.coretweaks.util.WrappedAddListenableMap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class CachingTransformer
implements IClassTransformer,
WrappedAddListenableMap.MapAddListener<String, Class<?>> {
    private WrappedTransformerList<IClassTransformer> wrappedTransformers;
    private WrappedAddListenableMap<String, Class<?>> wrappedCachedClasses;
    private Map<String, Optional<byte[]>> cache = new ConcurrentHashMap<String, Optional<byte[]>>();
    private static final int QUEUE_SIZE = Config.recentCacheSize;
    Optional<Cache<String, byte[]>> recentCache = QUEUE_SIZE < 0 ? Optional.empty() : Optional.of(CacheBuilder.newBuilder().maximumSize((long)QUEUE_SIZE).build());
    private SaveThread saveThread = new SaveThread(this);
    private Set<String> badTransformers = new HashSet<String>(Arrays.stream(Config.badTransformers.split(",")).collect(Collectors.toList()));
    private Set<String> badClasses = new HashSet<String>(Arrays.stream(Config.badClasses.split(",")).collect(Collectors.toList()));
    public static final boolean DEBUG_PRINT = Config.verbosity == 2;
    private static boolean printSave = Config.verbosity >= 1;
    private int lastSaveSize = 0;
    private BlockingQueue<String> dirtyClasses = new LinkedBlockingQueue<String>();
    private static final File CLASS_CACHE_DAT_OLD = Util.childFile(CoreTweaks.CACHE_DIR, "classCache.dat");
    private static final File CLASS_CACHE_DAT = Util.childFile(CoreTweaks.CACHE_DIR, "classTransformerFull.cache");
    private static final File CLASS_CACHE_DAT_ERRORED = Util.childFile(CoreTweaks.CACHE_DIR, "classTransformerFull.cache.errored");
    private static final File CLASS_CACHE_DAT_TMP = Util.childFile(CoreTweaks.CACHE_DIR, "classTransformerFull.cache~");
    private static final boolean FORCE_REBUILD_CACHE = Boolean.parseBoolean(System.getProperty("coretweaks.transformerCache.full.forceRebuild", "false"));

    public CachingTransformer(List<IClassTransformer> transformers, WrappedTransformerList<IClassTransformer> wrappedTransformers, WrappedAddListenableMap<String, Class<?>> wrappedCachedClasses) {
        CoreTweaks.LOGGER.info("Initializing cache transformer");
        this.wrappedTransformers = wrappedTransformers;
        this.wrappedCachedClasses = wrappedCachedClasses;
        wrappedCachedClasses.addListener(this);
        if (FORCE_REBUILD_CACHE || Persistence.modsChanged()) {
            this.clearCache(FORCE_REBUILD_CACHE ? "forceRebuild JVM flag was set." : "mods have changed.");
        } else {
            this.loadCache();
        }
        this.saveThread.start();
    }

    private void clearCache(String reason) {
        CoreTweaks.LOGGER.info("Rebuilding class cache, because " + reason);
        CLASS_CACHE_DAT.delete();
        Persistence.erroredClassesLog.clear();
    }

    public void doSave() {
        this.saveCache();
        Persistence.erroredClassesLog.flush();
        Persistence.debugLog.flush();
    }

    private void loadCache() {
        File inFile = CLASS_CACHE_DAT;
        if (CLASS_CACHE_DAT_OLD.exists() && !CLASS_CACHE_DAT.exists()) {
            CoreTweaks.LOGGER.info("Migrating class cache: " + CLASS_CACHE_DAT_OLD + " -> " + CLASS_CACHE_DAT);
            CLASS_CACHE_DAT_OLD.renameTo(CLASS_CACHE_DAT);
        }
        if (inFile.exists()) {
            CoreTweaks.LOGGER.info("Loading class cache.");
            this.cache.clear();
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile)));
                try {
                    try {
                        while (true) {
                            String className = in.readUTF();
                            int classLength = in.readInt();
                            byte[] classData = new byte[classLength];
                            int bytesRead = in.read(classData, 0, classLength);
                            if (bytesRead != classLength) {
                                throw new RuntimeException("Length of " + className + " doesn't match advertised length of " + classLength);
                            }
                            this.cache.put(className, Optional.of(classData));
                            this.superDebug("Loaded " + className);
                        }
                    }
                    catch (EOFException eOFException) {
                        in.close();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                CoreTweaks.LOGGER.error("There was an error reading the transformer cache. A new one will be created. The previous one has been saved as " + CLASS_CACHE_DAT_ERRORED.getName() + " for inspection.");
                CLASS_CACHE_DAT.renameTo(CLASS_CACHE_DAT_ERRORED);
                e.printStackTrace();
                this.cache.clear();
            }
            CoreTweaks.LOGGER.info("Loaded " + this.cache.size() + " cached classes.");
            this.lastSaveSize = this.cache.size();
        } else {
            CoreTweaks.LOGGER.info("Couldn't find class cache file");
        }
    }

    private void saveCacheFully() {
        File outFile = CLASS_CACHE_DAT;
        File outFileTmp = CLASS_CACHE_DAT_TMP;
        CoreTweaks.LOGGER.info("Performing full save of class cache (size: " + this.cache.size() + ")");
        this.saveCacheChunk(this.cache.keySet(), outFileTmp, false);
        try {
            Files.move((File)outFileTmp, (File)outFile);
        }
        catch (IOException e) {
            CoreTweaks.LOGGER.error("Failed to finish saving class cache");
            e.printStackTrace();
        }
    }

    private void saveCache() {
        if (this.dirtyClasses.isEmpty()) {
            return;
        }
        File outFile = CLASS_CACHE_DAT;
        try {
            outFile.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ArrayList<String> classesToSave = new ArrayList<String>();
        this.dirtyClasses.drainTo(classesToSave);
        if (printSave) {
            CoreTweaks.LOGGER.info("Saving class cache (size: " + this.lastSaveSize + " -> " + this.cache.size() + " | +" + classesToSave.size() + ")");
        }
        this.saveCacheChunk(classesToSave, outFile, true);
        this.lastSaveSize += classesToSave.size();
    }

    private void saveCacheChunk(Collection<String> classesToSave, File outFile, boolean append) {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile, append)));){
            for (String name : classesToSave) {
                Optional<byte[]> data = this.cache.get(name);
                if (data == null || !data.isPresent()) continue;
                out.writeUTF(name);
                out.writeInt(data.get().length);
                out.write(data.get());
            }
            if (printSave) {
                CoreTweaks.LOGGER.info("Saved class cache");
            }
        }
        catch (IOException e) {
            CoreTweaks.LOGGER.info("Exception saving class cache");
            e.printStackTrace();
        }
    }

    private String describeBytecode(byte[] basicClass) {
        return basicClass == null ? "null" : String.format("length: %d, hash: %x", basicClass.length, basicClass.hashCode());
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        byte[] result = null;
        this.superDebug(String.format("Starting loading class %s (%s) (%s)", name, transformedName, this.describeBytecode(basicClass)));
        try {
            boolean dontCache = false;
            for (String badPrefix : this.badClasses) {
                if (!transformedName.startsWith(badPrefix)) continue;
                dontCache = true;
                break;
            }
            if (this.cache.containsKey(transformedName) && !dontCache) {
                this.superDebug("Yay, we have it cached!");
                if (this.cache.get(transformedName).isPresent()) {
                    result = this.cache.get(transformedName).get();
                    if (this.recentCache.isPresent()) {
                        this.cache.put(transformedName, Optional.empty());
                        this.recentCache.get().put((Object)transformedName, (Object)result);
                    }
                } else if (this.recentCache.isPresent() && (result = (byte[])this.recentCache.get().getIfPresent((Object)transformedName)) == null) {
                    CoreTweaks.LOGGER.warn("Couldn't find " + transformedName + " in cache. Is recent queue too small? (" + QUEUE_SIZE + ")");
                }
            }
            if (result == null) {
                for (IClassTransformer transformer : this.wrappedTransformers.original) {
                    if (transformer == this) {
                        CoreTweaks.LOGGER.info("oops,");
                    }
                    if (this.isBadTransformer(transformer)) {
                        this.wrappedTransformers.alt = null;
                    }
                    this.superDebug(String.format("Before transformer: %s (%s)", transformer.getClass().getName(), this.describeBytecode(basicClass)));
                    basicClass = transformer.transform(name, transformedName, basicClass);
                    this.superDebug(String.format("After transformer: %s (%s)", transformer.getClass().getName(), this.describeBytecode(basicClass)));
                    if (this.wrappedTransformers.alt != null) continue;
                    this.wrappedTransformers.alt = this;
                }
                if (basicClass != null && !dontCache) {
                    this.cache.put(transformedName, Optional.of(basicClass));
                    this.dirtyClasses.add(transformedName);
                }
                result = basicClass;
            }
            if (result != null && this.recentCache.isPresent() && !dontCache) {
                this.recentCache.get().put((Object)transformedName, (Object)result);
            }
        }
        catch (Exception e) {
            if (DEBUG_PRINT) {
                Persistence.erroredClassesLog.write(transformedName + " / " + e.getClass().getName() + " / " + e.getMessage());
            }
            throw e;
        }
        finally {
            this.wrappedTransformers.alt = this;
        }
        this.superDebug(String.format("Finished loading class %s (%s) (%s)", name, transformedName, this.describeBytecode(basicClass)));
        return result;
    }

    private boolean isBadTransformer(IClassTransformer transformer) {
        for (String badPattern : this.badTransformers) {
            Class<?> baseClass;
            if (!(badPattern.endsWith("+") ? (baseClass = this.wrappedCachedClasses.get(badPattern.substring(0, badPattern.length() - 1))) != null && baseClass.isInstance(transformer) : badPattern.contentEquals(transformer.getClass().getName()))) continue;
            return true;
        }
        return false;
    }

    private void superDebug(String msg) {
        if (DEBUG_PRINT) {
            CoreTweaks.LOGGER.trace(msg);
            Persistence.debugLog.write(msg);
        }
    }

    public static CachingTransformer register() {
        CachingTransformer cacheTransformer = null;
        try {
            LaunchClassLoader lcl = Launch.classLoader;
            Field transformersField = LaunchClassLoader.class.getDeclaredField("transformers");
            transformersField.setAccessible(true);
            List transformers = (List)transformersField.get(lcl);
            WrappedTransformerList<IClassTransformer> wrappedTransformers = new WrappedTransformerList<IClassTransformer>(transformers);
            transformersField.set(lcl, wrappedTransformers);
            Field cachedClassesField = LaunchClassLoader.class.getDeclaredField("cachedClasses");
            cachedClassesField.setAccessible(true);
            Map cachedClasses = (Map)cachedClassesField.get(lcl);
            WrappedAddListenableMap wrappedCachedClasses = new WrappedAddListenableMap(cachedClasses);
            cachedClassesField.set(lcl, wrappedCachedClasses);
            cacheTransformer = new CachingTransformer(transformers, wrappedTransformers, wrappedCachedClasses);
            wrappedTransformers.alt = cacheTransformer;
            CoreTweaks.LOGGER.info("Finished initializing cache transformer");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            CoreTweaks.LOGGER.info("Exception registering cache transformer.");
            e.printStackTrace();
        }
        return cacheTransformer;
    }

    @Override
    public boolean onPut(Map<String, Class<?>> delegateMap, String key, Class<?> value) {
        return !this.cache.keySet().contains(key);
    }

    static class SaveThread
    extends Thread {
        private CachingTransformer cacheTransformer;
        private int saveInterval = 10000;

        public SaveThread(CachingTransformer ct) {
            this.cacheTransformer = ct;
            this.setName("CacheTransformer save thread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.saveInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.cacheTransformer.doSave();
            }
        }
    }
}

