/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.DiscordStatus;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class SystemUtils {
    public int TIMER = 0;
    public String OS_NAME;
    public String OS_ARCH;
    public String USER_DIR;
    public boolean IS_LINUX = false;
    public boolean IS_MAC = false;
    public boolean IS_WINDOWS = false;
    public boolean IS_64_BIT = false;
    public boolean HAS_LOADED = false;
    public boolean HAS_GAME_LOADED = false;
    public long CURRENT_TIMESTAMP;
    private boolean isTiming = false;
    private boolean refreshedCallbacks = false;
    private long BEGINNING_TIMESTAMP;
    private long ELAPSED_TIME;

    public SystemUtils() {
        try {
            this.OS_NAME = System.getProperty("os.name");
            this.OS_ARCH = System.getProperty("os.arch");
            this.USER_DIR = System.getProperty("user.dir");
            this.IS_LINUX = this.OS_NAME.startsWith("Linux") || this.OS_NAME.startsWith("LINUX");
            this.IS_MAC = this.OS_NAME.startsWith("Mac");
            this.IS_WINDOWS = this.OS_NAME.startsWith("Windows");
            this.CURRENT_TIMESTAMP = System.currentTimeMillis();
            this.ELAPSED_TIME = 0L;
            ArrayList x64 = Lists.newArrayList((Object[])new String[]{"amd64", "x86_64"});
            this.IS_64_BIT = x64.contains(this.OS_ARCH);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.system", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
    }

    void onTick() {
        this.ELAPSED_TIME = (System.currentTimeMillis() - this.CURRENT_TIMESTAMP) / 1000L;
        if (this.TIMER > 0) {
            if (!this.isTiming) {
                this.startTimer();
            } else {
                this.checkTimer();
            }
        }
        if (this.ELAPSED_TIME % (long)CraftPresence.CONFIG.refreshRate == 0L) {
            if (!this.refreshedCallbacks) {
                if (!this.HAS_LOADED && CraftPresence.CLIENT.STATUS == DiscordStatus.Ready) {
                    this.HAS_LOADED = true;
                }
                if (this.HAS_LOADED && !this.HAS_GAME_LOADED && CraftPresence.instance.field_71462_r != null) {
                    this.HAS_GAME_LOADED = true;
                }
                CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
                this.refreshedCallbacks = true;
            }
        } else {
            this.refreshedCallbacks = false;
        }
    }

    private void startTimer() {
        this.BEGINNING_TIMESTAMP = System.currentTimeMillis() + (long)this.TIMER * 1000L;
        this.isTiming = true;
    }

    private void checkTimer() {
        if (this.TIMER > 0) {
            long remainingTime = (this.BEGINNING_TIMESTAMP - System.currentTimeMillis()) / 1000L;
            this.TIMER = (int)remainingTime;
        } else if (this.isTiming) {
            this.isTiming = false;
        }
    }
}

