/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.discord;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.integrations.curse.CurseUtils;
import com.gitlab.cdagaming.craftpresence.integrations.mcupdater.MCUpdaterUtils;
import com.gitlab.cdagaming.craftpresence.integrations.multimc.MultiMCUtils;
import com.gitlab.cdagaming.craftpresence.integrations.technic.TechnicUtils;
import com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.ModIPCListener;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCClient;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.DiscordBuild;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.PartyPrivacy;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.RichPresence;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.User;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.PipeStatus;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import java.util.List;

public class DiscordUtils {
    private final List<Pair<String, String>> messageData = Lists.newArrayList();
    private final List<Pair<String, String>> iconData = Lists.newArrayList();
    private final List<Pair<String, String>> modsArgs = Lists.newArrayList();
    private final List<Pair<String, String>> playerInfoArgs = Lists.newArrayList();
    public User CURRENT_USER;
    public User REQUESTER_USER;
    public DiscordStatus STATUS = DiscordStatus.Disconnected;
    public String GAME_STATE;
    public String DETAILS;
    public String SMALL_IMAGE_KEY;
    public String SMALL_IMAGE_TEXT;
    public String LARGE_IMAGE_KEY;
    public String LARGE_IMAGE_TEXT;
    public String CLIENT_ID;
    public boolean AUTO_REGISTER;
    public long START_TIMESTAMP;
    public String PARTY_ID;
    public int PARTY_SIZE;
    public int PARTY_MAX;
    public PartyPrivacy PARTY_PRIVACY = PartyPrivacy.Public;
    public String JOIN_SECRET;
    public long END_TIMESTAMP;
    public String MATCH_SECRET;
    public String SPECTATE_SECRET;
    public JsonArray BUTTONS = new JsonArray();
    public byte INSTANCE;
    public List<Pair<String, String>> generalArgs = Lists.newArrayList();
    public IPCClient ipcInstance;
    public boolean awaitingReply = false;
    private Pair<String, String> lastRequestedImageData = new Pair();
    private RichPresence currentPresence;

    public synchronized void setup() {
        Thread shutdownThread = new Thread("CraftPresence-ShutDown-Handler"){

            @Override
            public void run() {
                CraftPresence.closing = true;
                CraftPresence.timerObj.cancel();
                DiscordUtils.this.shutDown();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    public synchronized void init(boolean updateTimestamp) {
        try {
            if (updateTimestamp) {
                this.updateTimestamp();
            }
            this.ipcInstance = new IPCClient(Long.parseLong(this.CLIENT_ID), ModUtils.IS_DEV, ModUtils.IS_VERBOSE, this.AUTO_REGISTER, this.CLIENT_ID);
            this.ipcInstance.setListener(new ModIPCListener());
            this.ipcInstance.connect(new DiscordBuild[0]);
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN);
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN_REQUEST);
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_SPECTATE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initArgument(false, "&MAINMENU&", "&BRAND&", "&MCVERSION&", "&IGN&", "&MODS&", "&PACK&", "&DIMENSION&", "&BIOME&", "&SERVER&", "&SCREEN&", "&TILEENTITY&", "&TARGETENTITY&", "&ATTACKINGENTITY&", "&RIDINGENTITY&");
        this.initArgument(true, "&DEFAULT&", "&MAINMENU&", "&PACK&", "&DIMENSION&", "&BIOME&", "&SERVER&");
        CommandUtils.isInMainMenu = false;
        this.modsArgs.add(new Pair<String, String>("&MODCOUNT&", Integer.toString(FileUtils.getModCount())));
        this.playerInfoArgs.add(new Pair<String, String>("&NAME&", ModUtils.USERNAME));
        this.generalArgs.add(new Pair<String, String>("&MCVERSION&", ModUtils.TRANSLATOR.translate("craftpresence.defaults.state.mc.version", ModUtils.MCVersion)));
        this.generalArgs.add(new Pair<String, String>("&BRAND&", ModUtils.BRAND));
        this.generalArgs.add(new Pair<String, String>("&MODS&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.modsPlaceholderMessage, this.modsArgs)));
        this.generalArgs.add(new Pair<String, String>("&IGN&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.outerPlayerPlaceholderMessage, this.playerInfoArgs)));
        for (Pair<String, String> generalArgument : this.generalArgs) {
            this.syncArgument(generalArgument.getFirst(), generalArgument.getSecond(), false);
        }
        this.syncArgument("&DEFAULT&", CraftPresence.CONFIG.defaultIcon, true);
        this.syncPackArguments();
    }

    public void updateTimestamp() {
        if (CraftPresence.CONFIG.showTime) {
            this.START_TIMESTAMP = CraftPresence.SYSTEM.CURRENT_TIMESTAMP / 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncArgument(String argumentName, String insertString, boolean isIconData) {
        if (!StringUtils.isNullOrEmpty(argumentName)) {
            if (isIconData) {
                List<Pair<String, String>> list = this.iconData;
                synchronized (list) {
                    if (this.iconData.removeIf(e -> ((String)e.getFirst()).equalsIgnoreCase(argumentName) && !((String)e.getSecond()).equalsIgnoreCase(insertString))) {
                        this.iconData.add(new Pair<String, String>(argumentName, insertString));
                    }
                }
            }
            List<Pair<String, String>> list = this.messageData;
            synchronized (list) {
                if (this.messageData.removeIf(e -> ((String)e.getFirst()).equalsIgnoreCase(argumentName) && !((String)e.getSecond()).equalsIgnoreCase(insertString))) {
                    this.messageData.add(new Pair<String, String>(argumentName, insertString));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initArgument(boolean isIconData, String ... args) {
        if (isIconData) {
            for (String argumentName : args) {
                List<Pair<String, String>> list = this.iconData;
                synchronized (list) {
                    this.iconData.removeIf(e -> ((String)e.getFirst()).equalsIgnoreCase(argumentName));
                    this.iconData.add(new Pair<String, String>(argumentName, ""));
                }
            }
        } else {
            for (String argumentName : args) {
                List<Pair<String, String>> list = this.messageData;
                synchronized (list) {
                    this.messageData.removeIf(e -> ((String)e.getFirst()).equalsIgnoreCase(argumentName));
                    this.messageData.add(new Pair<String, String>(argumentName, ""));
                }
            }
        }
    }

    public void initArgument(String ... args) {
        this.initArgument(false, args);
        this.initArgument(true, args);
    }

    private void syncPackArguments() {
        String foundPackName = "";
        String foundPackIcon = "";
        if (ModUtils.BRAND.contains("vivecraft")) {
            CraftPresence.packFound = true;
            foundPackName = CraftPresence.CONFIG.vivecraftMessage;
            foundPackIcon = "vivecraft";
        } else if (!StringUtils.isNullOrEmpty(CurseUtils.INSTANCE_NAME)) {
            foundPackIcon = foundPackName = CurseUtils.INSTANCE_NAME;
        } else if (!StringUtils.isNullOrEmpty(MultiMCUtils.INSTANCE_NAME)) {
            foundPackName = MultiMCUtils.INSTANCE_NAME;
            foundPackIcon = MultiMCUtils.ICON_KEY;
        } else if (MCUpdaterUtils.instance != null && !StringUtils.isNullOrEmpty(MCUpdaterUtils.instance.getPackName())) {
            foundPackIcon = foundPackName = MCUpdaterUtils.instance.getPackName();
        } else if (!StringUtils.isNullOrEmpty(TechnicUtils.PACK_NAME)) {
            foundPackName = TechnicUtils.PACK_NAME;
            foundPackIcon = TechnicUtils.ICON_NAME;
        } else if (!StringUtils.isNullOrEmpty(CraftPresence.CONFIG.fallbackPackPlaceholderMessage)) {
            foundPackIcon = foundPackName = CraftPresence.CONFIG.fallbackPackPlaceholderMessage;
        }
        this.syncArgument("&PACK&", StringUtils.formatWord(StringUtils.replaceAnyCase(CraftPresence.CONFIG.packPlaceholderMessage, "&NAME&", !StringUtils.isNullOrEmpty(foundPackName) ? foundPackName : ""), !CraftPresence.CONFIG.formatWords), false);
        this.syncArgument("&PACK&", !StringUtils.isNullOrEmpty(foundPackIcon) ? StringUtils.formatAsIcon(foundPackIcon) : "", true);
    }

    public void updatePresence(RichPresence presence) {
        if (!(presence == null || this.currentPresence != null && presence.toJson().toString().equals(this.currentPresence.toJson().toString()) || this.ipcInstance.getStatus() != PipeStatus.CONNECTED)) {
            this.ipcInstance.sendRichPresence(presence);
            this.currentPresence = presence;
        }
    }

    public String imageOf(String evalString, String alternativeString, boolean allowNull) {
        if (DiscordAssetUtils.syncCompleted) {
            if (StringUtils.isNullOrEmpty(this.lastRequestedImageData.getFirst()) || !this.lastRequestedImageData.getFirst().equalsIgnoreCase(evalString)) {
                String defaultIcon = DiscordAssetUtils.contains(CraftPresence.CONFIG.defaultIcon) ? CraftPresence.CONFIG.defaultIcon : DiscordAssetUtils.getRandomAsset();
                this.lastRequestedImageData.setFirst(evalString);
                String finalKey = evalString;
                if (!DiscordAssetUtils.contains(finalKey)) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.fallback", evalString, alternativeString), new Object[0]);
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.request", evalString), new Object[0]);
                    if (DiscordAssetUtils.contains(alternativeString)) {
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.fallback", evalString, alternativeString), new Object[0]);
                        finalKey = alternativeString;
                    } else if (allowNull) {
                        finalKey = "";
                    } else {
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.default", evalString, defaultIcon), new Object[0]);
                        finalKey = defaultIcon;
                    }
                }
                this.lastRequestedImageData.setSecond(finalKey);
                return finalKey;
            }
            return this.lastRequestedImageData.getSecond();
        }
        return "";
    }

    public void clearPartyData(boolean clearRequesterData, boolean updateRPC) {
        if (clearRequesterData) {
            this.awaitingReply = false;
            this.REQUESTER_USER = null;
            CraftPresence.SYSTEM.TIMER = 0;
        }
        this.JOIN_SECRET = null;
        this.PARTY_ID = null;
        this.PARTY_SIZE = 0;
        this.PARTY_MAX = 0;
        if (updateRPC) {
            this.updatePresence(this.buildRichPresence());
        }
    }

    public void clearPresenceData(Tuple<Boolean, Boolean, Boolean> partyClearArgs) {
        this.GAME_STATE = "";
        this.DETAILS = "";
        this.LARGE_IMAGE_KEY = "";
        this.LARGE_IMAGE_TEXT = "";
        this.SMALL_IMAGE_KEY = "";
        this.SMALL_IMAGE_TEXT = "";
        if (partyClearArgs.getFirst().booleanValue()) {
            this.clearPartyData(partyClearArgs.getSecond(), partyClearArgs.getThird());
        }
    }

    public synchronized void shutDown() {
        if (CraftPresence.SYSTEM.HAS_LOADED) {
            try {
                this.ipcInstance.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.STATUS = DiscordStatus.Disconnected;
            this.currentPresence = null;
            this.clearPresenceData(new Tuple<Boolean, Boolean, Boolean>(true, true, false));
            this.CURRENT_USER = null;
            this.lastRequestedImageData = new Pair();
            CraftPresence.DIMENSIONS.clearClientData();
            CraftPresence.TILE_ENTITIES.clearClientData();
            CraftPresence.ENTITIES.clearClientData();
            CraftPresence.BIOMES.clearClientData();
            CraftPresence.SERVER.clearClientData();
            CraftPresence.GUIS.clearClientData();
            CraftPresence.SYSTEM.HAS_LOADED = false;
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.shutdown", new Object[0]), new Object[0]);
        }
    }

    public RichPresence buildRichPresence() {
        this.DETAILS = StringUtils.formatWord(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.detailsMessage, this.messageData), !CraftPresence.CONFIG.formatWords, true, 1);
        this.GAME_STATE = StringUtils.formatWord(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.gameStateMessage, this.messageData), !CraftPresence.CONFIG.formatWords, true, 1);
        this.LARGE_IMAGE_KEY = StringUtils.formatAsIcon(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.largeImageKey, this.iconData));
        this.SMALL_IMAGE_KEY = StringUtils.formatAsIcon(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.smallImageKey, this.iconData));
        this.LARGE_IMAGE_TEXT = StringUtils.formatWord(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.largeImageMessage, this.messageData), !CraftPresence.CONFIG.formatWords, true, 1);
        this.SMALL_IMAGE_TEXT = StringUtils.formatWord(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.smallImageMessage, this.messageData), !CraftPresence.CONFIG.formatWords, true, 1);
        RichPresence newRPCData = new RichPresence.Builder().setState(this.GAME_STATE).setDetails(this.DETAILS).setStartTimestamp(this.START_TIMESTAMP).setEndTimestamp(this.END_TIMESTAMP).setLargeImage(this.LARGE_IMAGE_KEY, this.LARGE_IMAGE_TEXT).setSmallImage(this.SMALL_IMAGE_KEY, this.SMALL_IMAGE_TEXT).setParty(this.PARTY_ID, this.PARTY_SIZE, this.PARTY_MAX, this.PARTY_PRIVACY.getPartyIndex()).setMatchSecret(this.MATCH_SECRET).setJoinSecret(this.JOIN_SECRET).setSpectateSecret(this.SPECTATE_SECRET).setButtons(this.BUTTONS).build();
        this.GAME_STATE = StringUtils.getConvertedString(this.GAME_STATE, "UTF-8", false);
        this.DETAILS = StringUtils.getConvertedString(this.DETAILS, "UTF-8", false);
        this.LARGE_IMAGE_KEY = StringUtils.getConvertedString(this.LARGE_IMAGE_KEY, "UTF-8", false);
        this.SMALL_IMAGE_KEY = StringUtils.getConvertedString(this.SMALL_IMAGE_KEY, "UTF-8", false);
        this.LARGE_IMAGE_TEXT = StringUtils.getConvertedString(this.LARGE_IMAGE_TEXT, "UTF-8", false);
        this.SMALL_IMAGE_TEXT = StringUtils.getConvertedString(this.SMALL_IMAGE_TEXT, "UTF-8", false);
        return newRPCData;
    }
}

