/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities;

import com.gitlab.cdagaming.craftpresence.utils.StringUtils;

public enum PartyPrivacy {
    Private(0),
    Public(1);

    private final String displayName;
    private final int partyIndex;

    private PartyPrivacy(int partyIndex) {
        this.partyIndex = partyIndex;
        this.displayName = StringUtils.formatWord(this.name());
    }

    private PartyPrivacy(int partyIndex, String displayName) {
        this.partyIndex = partyIndex;
        this.displayName = displayName;
    }

    public static PartyPrivacy from(int partyIndex) {
        for (PartyPrivacy value : PartyPrivacy.values()) {
            if (value.getPartyIndex() != partyIndex) continue;
            return value;
        }
        return Public;
    }

    public static PartyPrivacy from(String displayName) {
        for (PartyPrivacy value : PartyPrivacy.values()) {
            if (value.getDisplayName() == null || !value.getDisplayName().equals(displayName)) continue;
            return value;
        }
        return Public;
    }

    public static PartyPrivacy from(int partyIndex, String displayName) {
        for (PartyPrivacy value : PartyPrivacy.values()) {
            if (value.getDisplayName() == null || !value.getDisplayName().equals(displayName) || value.getPartyIndex() != partyIndex) continue;
            return value;
        }
        return Public;
    }

    public int getPartyIndex() {
        return this.partyIndex;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

