/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCClient;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCListener;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.Callback;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.DiscordBuild;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.Packet;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.User;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.MacPipe;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.PipeStatus;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.UnixPipe;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.WindowsPipe;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.exceptions.NoDiscordClientException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public abstract class Pipe {
    private static final int VERSION = 1;
    private static final String[] unixPaths = new String[]{"XDG_RUNTIME_DIR", "TMPDIR", "TMP", "TEMP"};
    final IPCClient ipcClient;
    private final HashMap<String, Callback> callbacks;
    PipeStatus status = PipeStatus.CONNECTING;
    IPCListener listener;
    private DiscordBuild build;
    private User currentUser;

    Pipe(IPCClient ipcClient, HashMap<String, Callback> callbacks) {
        this.ipcClient = ipcClient;
        this.callbacks = callbacks;
    }

    public static Pipe openPipe(IPCClient ipcClient, long clientId, HashMap<String, Callback> callbacks, DiscordBuild ... preferredOrder) throws NoDiscordClientException {
        int i;
        if (preferredOrder == null || preferredOrder.length == 0) {
            preferredOrder = new DiscordBuild[]{DiscordBuild.ANY};
        }
        Pipe pipe = null;
        Pipe[] open = new Pipe[DiscordBuild.values().length];
        for (i = 0; i < 10; ++i) {
            try {
                String location = Pipe.getPipeLocation(i);
                if (ipcClient.isDebugMode()) {
                    ModUtils.LOG.debugInfo(String.format("Searching for IPC: %s", location), new Object[0]);
                }
                if ((pipe = Pipe.createPipe(ipcClient, callbacks, location)) == null) continue;
                JsonObject finalObject = new JsonObject();
                finalObject.addProperty("v", (Number)1);
                finalObject.addProperty("client_id", Long.toString(clientId));
                pipe.send(Packet.OpCode.HANDSHAKE, finalObject, null);
                Packet p = pipe.read();
                JsonObject parsedData = p.getJson();
                JsonObject data = parsedData.getAsJsonObject("data");
                JsonObject userData = data.getAsJsonObject("user");
                pipe.build = DiscordBuild.from(data.getAsJsonObject("config").get("api_endpoint").getAsString());
                pipe.currentUser = new User(userData.getAsJsonPrimitive("username").getAsString(), userData.getAsJsonPrimitive("discriminator").getAsString(), Long.parseLong(userData.getAsJsonPrimitive("id").getAsString()), userData.has("avatar") && userData.get("avatar").isJsonPrimitive() ? userData.getAsJsonPrimitive("avatar").getAsString() : null);
                if (ipcClient.isDebugMode()) {
                    ModUtils.LOG.debugInfo(String.format("Found a valid client (%s) with packet: %s", pipe.build.name(), p), new Object[0]);
                    ModUtils.LOG.debugInfo(String.format("Found a valid user (%s) with id: %s", pipe.currentUser.getName(), pipe.currentUser.getId()), new Object[0]);
                }
                if (pipe.build == preferredOrder[0] || DiscordBuild.ANY == preferredOrder[0]) {
                    if (!ipcClient.isDebugMode()) break;
                    ModUtils.LOG.debugInfo(String.format("Found preferred client: %s", pipe.build.name()), new Object[0]);
                    break;
                }
                open[pipe.build.ordinal()] = pipe;
                open[DiscordBuild.ANY.ordinal()] = pipe;
                pipe.build = null;
                pipe = null;
                continue;
            }
            catch (JsonParseException | IOException ex) {
                pipe = null;
            }
        }
        if (pipe == null) {
            for (i = 1; i < preferredOrder.length; ++i) {
                DiscordBuild cb = preferredOrder[i];
                if (ipcClient.isDebugMode()) {
                    ModUtils.LOG.debugInfo(String.format("Looking for client build: %s", cb.name()), new Object[0]);
                }
                if (open[cb.ordinal()] == null) continue;
                pipe = open[cb.ordinal()];
                open[cb.ordinal()] = null;
                if (cb == DiscordBuild.ANY) {
                    for (int k = 0; k < open.length; ++k) {
                        if (open[k] != pipe) continue;
                        pipe.build = DiscordBuild.values()[k];
                        open[k] = null;
                    }
                } else {
                    pipe.build = cb;
                }
                if (!ipcClient.isDebugMode()) break;
                ModUtils.LOG.debugInfo(String.format("Found preferred client: %s", pipe.build.name()), new Object[0]);
                break;
            }
            if (pipe == null) {
                throw new NoDiscordClientException();
            }
        }
        for (i = 0; i < open.length; ++i) {
            if (i == DiscordBuild.ANY.ordinal() || open[i] == null) continue;
            try {
                open[i].close();
                continue;
            }
            catch (IOException ex) {
                if (!ipcClient.isDebugMode()) continue;
                ModUtils.LOG.debugError(String.format("Failed to close an open IPC pipe: %s", ex), new Object[0]);
            }
        }
        pipe.status = PipeStatus.CONNECTED;
        return pipe;
    }

    private static Pipe createPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, String location) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            WindowsPipe attemptedPipe = new WindowsPipe(ipcClient, callbacks, location);
            return attemptedPipe.file != null ? attemptedPipe : null;
        }
        if (osName.contains("linux") || osName.contains("mac")) {
            try {
                return osName.contains("mac") ? new MacPipe(ipcClient, callbacks, location) : new UnixPipe(ipcClient, callbacks, location);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unsupported OS: " + osName);
    }

    private static String generateNonce() {
        return UUID.randomUUID().toString();
    }

    private static String getPipeLocation(int index) {
        String str;
        String tmpPath = null;
        String pipePath = "discord-ipc-" + index;
        if (System.getProperty("os.name").contains("Win")) {
            return "\\\\?\\pipe\\" + pipePath;
        }
        String[] stringArray = unixPaths;
        int n = stringArray.length;
        for (int i = 0; i < n && (tmpPath = System.getenv(str = stringArray[i])) == null; ++i) {
        }
        if (tmpPath == null) {
            tmpPath = "/tmp";
        } else {
            String snapPath = tmpPath + "/snap.discord";
            String flatpakPath = tmpPath + "/app/com.discordapp.Discord";
            File snapFile = new File(snapPath);
            File flatpakFile = new File(flatpakPath);
            if (snapFile.exists() && snapFile.isDirectory()) {
                tmpPath = snapPath;
            } else if (flatpakFile.exists() && flatpakFile.isDirectory()) {
                tmpPath = flatpakPath;
            }
        }
        return tmpPath + "/" + pipePath;
    }

    public void send(Packet.OpCode op, JsonObject data, Callback callback) {
        try {
            String nonce = Pipe.generateNonce();
            data.addProperty("nonce", nonce);
            Packet p = new Packet(op, data, this.ipcClient.getEncoding());
            if (callback != null && !callback.isEmpty()) {
                this.callbacks.put(nonce, callback);
            }
            this.write(p.toBytes());
            if (this.ipcClient.isDebugMode()) {
                ModUtils.LOG.debugInfo(String.format("Sent packet: %s", p.toDecodedString()), new Object[0]);
            }
            if (this.listener != null) {
                this.listener.onPacketSent(this.ipcClient, p);
            }
        }
        catch (IOException ex) {
            ModUtils.LOG.error("Encountered an IOException while sending a packet and disconnected!", new Object[0]);
            this.status = PipeStatus.DISCONNECTED;
        }
    }

    public Packet receive(Packet.OpCode op, byte[] data) {
        JsonObject packetData = FileUtils.parseJson(new String(data));
        Packet p = new Packet(op, packetData, this.ipcClient.getEncoding());
        if (this.ipcClient.isDebugMode()) {
            ModUtils.LOG.debugInfo(String.format("Received packet: %s", p), new Object[0]);
        }
        if (this.listener != null) {
            this.listener.onPacketReceived(this.ipcClient, p);
        }
        return p;
    }

    public abstract Packet read() throws IOException, JsonParseException;

    public abstract void write(byte[] var1) throws IOException;

    public abstract void registerApp(String var1, String var2);

    public abstract void registerSteamGame(String var1, String var2);

    public PipeStatus getStatus() {
        return this.status;
    }

    public void setStatus(PipeStatus status) {
        this.status = status;
    }

    public void setListener(IPCListener listener) {
        this.listener = listener;
    }

    public abstract void close() throws IOException;

    public DiscordBuild getDiscordBuild() {
        return this.build;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }
}

