/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.client.avatar.Avatar;
import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.client.rendering.RenderHelper2D;
import com.creativemd.creativecore.common.gui.controls.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.GuiItemStackSelector;
import java.util.ArrayList;
import javax.vecmath.Vector4d;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiInvSelector
extends GuiComboBox {
    public ArrayList<ItemStack> stacks = new ArrayList();
    public boolean onlyBlocks;
    public String search;

    public GuiInvSelector(String name, int x, int y, int width, EntityPlayer player, boolean onlyBlocks, String search) {
        super(name, x, y, width, new ArrayList<String>());
        this.search = search;
        this.onlyBlocks = onlyBlocks;
        this.updateItems(player);
    }

    public GuiInvSelector(String name, int x, int y, int width, EntityPlayer player, boolean onlyBlocks) {
        this(name, x, y, width, player, onlyBlocks, "");
    }

    public void updateItems(EntityPlayer player) {
        boolean shouldSearch = this.search.equals("");
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null) continue;
            newStacks.add(player.field_71071_by.field_70462_a[i].func_77946_l());
        }
        for (Item item : Item.field_150901_e) {
            if (item == null || item.func_77640_w() == null) continue;
            item.func_150895_a(item, (CreativeTabs)null, newStacks);
        }
        this.stacks.clear();
        this.lines.clear();
        for (int i = 0; i < newStacks.size(); ++i) {
            if (!GuiItemStackSelector.shouldShowItem(this.onlyBlocks, this.search, (ItemStack)newStacks.get(i))) continue;
            this.stacks.add((ItemStack)newStacks.get(i));
            this.lines.add(GuiItemStackSelector.getItemName((ItemStack)newStacks.get(i)));
        }
        if (this.lines.size() > 0) {
            this.index = 0;
            this.caption = (String)this.lines.get(0);
        } else {
            this.caption = "";
            this.index = -1;
        }
    }

    public void addAndSelectStack(ItemStack stack) {
        try {
            this.lines.add(stack.func_82833_r());
        }
        catch (Exception e) {
            this.lines.add(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        }
        this.stacks.add(stack.func_77946_l());
        this.caption = (String)this.lines.get(this.lines.size() - 1);
        this.index = this.lines.size() - 1;
    }

    @Override
    public void drawControl(FontRenderer renderer) {
        Vector4d black = new Vector4d(0.0, 0.0, 0.0, 255.0);
        RenderHelper2D.drawGradientRect(0, 0, this.width, this.height, black, black);
        Vector4d color = new Vector4d(60.0, 60.0, 60.0, 255.0);
        RenderHelper2D.drawGradientRect(1, 1, this.width - 1, this.height - 1, color, color);
        if (this.index != -1 && this.stacks.size() > this.index && this.stacks.get(this.index) != null) {
            AvatarItemStack avatar = new AvatarItemStack(this.stacks.get(this.index));
            GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
            ((Avatar)avatar).handleRendering(mc, renderer, 18, 18);
        }
        renderer.func_78276_b(this.caption, 24, this.height / 2 - renderer.field_78288_b / 2, 0xE0E0E0);
    }

    @Override
    public void openBox() {
        this.extension = new GuiItemStackSelector(this.name + "extension", this.parent.container.player, this.posX, this.posY + this.height, this.width, 200, this, this.onlyBlocks, this.search);
        this.parent.controls.add(this.extension);
        this.extension.parent = this.parent;
        this.extension.moveControlToTop();
        this.extension.init();
        this.parent.refreshControls();
        this.extension.rotation = this.rotation;
    }

    public ItemStack getStack() {
        if (this.index != -1) {
            return this.stacks.get(this.index);
        }
        return null;
    }
}

