/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.overlay;

import com.caedis.duradisplay.DuraDisplay;
import com.caedis.duradisplay.config.ConfigDurabilityLike;
import com.caedis.duradisplay.overlay.Overlay;
import com.caedis.duradisplay.render.BarRenderer;
import com.caedis.duradisplay.render.OverlayRenderer;
import com.caedis.duradisplay.render.TextRenderer;
import com.caedis.duradisplay.render.VerticalBarRenderer;
import com.caedis.duradisplay.utils.DurabilityFormatter;
import com.caedis.duradisplay.utils.DurabilityLikeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OverlayDurabilityLike
extends Overlay<ConfigDurabilityLike> {
    @NotNull
    protected final ConfigDurabilityLike config;
    @NotNull
    private final @NotNull ArrayList<Pair<@NotNull Class<?>, @NotNull Function<@NotNull ItemStack, @Nullable DurabilityLikeInfo>>> handlers = new ArrayList();

    protected OverlayDurabilityLike(@NotNull ConfigDurabilityLike config) {
        this.config = config;
    }

    private void addHandler(@Nullable Class<?> clazz, @NotNull @NotNull Function<@NotNull ItemStack, @Nullable DurabilityLikeInfo> handler) {
        if (clazz != null) {
            this.handlers.add(Pair.of(clazz, handler));
        }
    }

    protected final void addHandler(@NotNull String className, @NotNull @NotNull Function<@NotNull ItemStack, @Nullable DurabilityLikeInfo> handler) {
        try {
            this.addHandler(Class.forName(className), handler);
        }
        catch (ClassNotFoundException e) {
            DuraDisplay.LOG.info(String.format("Class %s not found, Overlay won't be added", className));
        }
    }

    @NotNull
    protected DurabilityLikeInfo getDurabilityLikeInfo(@NotNull ItemStack itemStack) {
        return this.handlers.stream().filter(p -> ((Class)p.getLeft()).isInstance(itemStack.func_77973_b())).findFirst().map(classFunctionPair -> (DurabilityLikeInfo)((Function)classFunctionPair.getRight()).apply(itemStack)).orElse(new DurabilityLikeInfo(0.0, 0.0));
    }

    protected int getColor(DurabilityLikeInfo info) {
        return ((ConfigDurabilityLike)this.config()).colorType.get(info.percent(), (ConfigDurabilityLike)this.config());
    }

    protected String getValue(DurabilityLikeInfo info) {
        return DurabilityFormatter.format(info.current, info.max, ((ConfigDurabilityLike)this.config()).textFormat);
    }

    @Override
    @Nullable
    public OverlayRenderer getRenderer(@NotNull ItemStack itemStack) {
        if (!((ConfigDurabilityLike)this.config()).enabled) {
            return null;
        }
        DurabilityLikeInfo info = this.getDurabilityLikeInfo(itemStack);
        if (info.isNaN()) {
            return null;
        }
        if (!((ConfigDurabilityLike)this.config()).showWhenEmpty && info.isEmpty()) {
            return null;
        }
        if (!((ConfigDurabilityLike)this.config()).showWhenFull && info.isFull()) {
            return null;
        }
        if (Objects.requireNonNull(((ConfigDurabilityLike)this.config()).style) == Style.Bar) {
            return new BarRenderer(this.getColor(info), info.percent(), ((ConfigDurabilityLike)this.config()).smoothBar, ((ConfigDurabilityLike)this.config()).barOffset, ((ConfigDurabilityLike)this.config()).showBackground);
        }
        if (Objects.requireNonNull(((ConfigDurabilityLike)this.config()).style) == Style.VerticalBar) {
            return new VerticalBarRenderer(this.getColor(info), info.percent(), ((ConfigDurabilityLike)this.config()).smoothBar, ((ConfigDurabilityLike)this.config()).barOffset, ((ConfigDurabilityLike)this.config()).showBackground);
        }
        return new TextRenderer(this.getValue(info), this.getColor(info), ((ConfigDurabilityLike)this.config()).numPadPosition);
    }

    public static enum Style {
        Text,
        Bar,
        VerticalBar;

    }
}

