/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.particle;

import ganymedes01.etfuturum.client.OpenGLHelper;
import ganymedes01.etfuturum.core.utils.RandomXoshiro256StarStar;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class EtFuturumFXParticle
extends EntityFX {
    protected int color;
    protected int textures;
    protected int currentTexture = 0;
    protected float entityBrightness;
    private boolean fadingColor;
    protected boolean fadeAway;
    private float fadeTargetRed;
    private float fadeTargetGreen;
    private float fadeTargetBlue;
    float particleAngle;
    float prevParticleAngle;
    protected boolean usesSheet;
    protected final ResourceLocation[] resourceLocations;
    protected static final Random particleRand = new RandomXoshiro256StarStar();

    public EtFuturumFXParticle(World world, double x, double y, double z, double mx, double my, double mz, int maxAge, float scale, int color, String texture, int textures) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_70146_Z = particleRand;
        this.textures = textures;
        this.resourceLocations = this.loadTextures(world, x, y, z, texture == null ? null : new ResourceLocation(texture));
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.field_70159_w = this.field_70159_w * (double)0.01f + mx;
        this.field_70181_x = this.field_70181_x * (double)0.01f + my;
        this.field_70179_y = this.field_70179_y * (double)0.01f + mz;
        this.field_70547_e = maxAge;
        this.field_70145_X = true;
        this.color = color;
        this.field_70544_f = scale;
        this.fadingColor = false;
        this.field_82339_as = (float)(this.color >> 24 & 0xFF) / 255.0f;
        this.field_70552_h = (float)(this.color >> 16 & 0xFF) / 255.0f;
        this.field_70553_i = (float)(this.color >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(this.color & 0xFF) / 255.0f;
    }

    protected ResourceLocation[] loadTextures(World world, double x, double y, double z, ResourceLocation texture) {
        this.usesSheet = texture != null && texture.toString().equals("minecraft:textures/particle/particles.png");
        ResourceLocation[] newRS = new ResourceLocation[this.usesSheet ? 1 : this.textures];
        if (this.textures == 1 || this.usesSheet) {
            newRS[0] = texture;
        } else {
            for (int i = 0; i < this.textures; ++i) {
                String textureName = texture.toString();
                int length = textureName.length();
                newRS[i] = new ResourceLocation(textureName.substring(0, length - 4) + "_" + i + textureName.substring(length - 4));
            }
        }
        return newRS;
    }

    public void func_70539_a(Tessellator tessellator, float partialTicks, float rx, float rxz, float rz, float ryz, float rxy) {
        double f9;
        double f8;
        double f7;
        double f6;
        int prevTex = GL11.glGetInteger((int)32873);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resourceLocations[this.usesSheet ? 0 : this.currentTexture % this.textures]);
        OpenGLHelper.enableBlend();
        OpenGLHelper.blendFunc(770, 771);
        GL11.glPushMatrix();
        float ipx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTicks - EntityFX.field_70556_an);
        float ipy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTicks - EntityFX.field_70554_ao);
        float ipz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTicks - EntityFX.field_70555_ap);
        if (this.particleAngle != 0.0f) {
            Vec3 ipNormVec = Vec3.func_72443_a((double)ipx, (double)ipy, (double)ipz).func_72432_b();
            double angle = Math.toDegrees(this.prevParticleAngle + (this.particleAngle - this.prevParticleAngle) * partialTicks);
            GL11.glTranslatef((float)ipx, (float)ipy, (float)ipz);
            GL11.glRotated((double)angle, (double)ipNormVec.field_72450_a, (double)ipNormVec.field_72448_b, (double)ipNormVec.field_72449_c);
            GL11.glTranslatef((float)(-ipx), (float)(-ipy), (float)(-ipz));
        }
        double f10 = 0.1 * (double)this.field_70544_f;
        if (this.usesSheet) {
            f6 = (double)this.field_94054_b / 16.0;
            f7 = f6 + 0.0624375;
            f8 = (double)this.field_94055_c / 16.0;
            f9 = f8 + 0.0624375;
        } else {
            f9 = 1.0;
            f7 = 1.0;
            f8 = 0.0;
            f6 = 0.0;
        }
        tessellator.func_78382_b();
        tessellator.func_78380_c(this.func_70070_b(this.entityBrightness));
        tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        tessellator.func_78374_a((double)ipx - (double)rx * f10 - (double)ryz * f10, (double)ipy - (double)rxz * f10, (double)ipz - (double)rz * f10 - (double)rxy * f10, f7, f9);
        tessellator.func_78374_a((double)ipx - (double)rx * f10 + (double)ryz * f10, (double)ipy + (double)rxz * f10, (double)ipz - (double)rz * f10 + (double)rxy * f10, f7, f8);
        tessellator.func_78374_a((double)ipx + (double)rx * f10 + (double)ryz * f10, (double)ipy + (double)rxz * f10, (double)ipz + (double)rz * f10 + (double)rxy * f10, f6, f8);
        tessellator.func_78374_a((double)ipx + (double)rx * f10 - (double)ryz * f10, (double)ipy - (double)rxz * f10, (double)ipz + (double)rz * f10 - (double)rxy * f10, f6, f9);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        OpenGLHelper.disableBlend();
        GL11.glBindTexture((int)3553, (int)prevTex);
    }

    public void func_70536_a(int p_70536_1_) {
        if (!this.usesSheet) {
            throw new RuntimeException("Invalid call to Particle.setMiscTex");
        }
        this.field_94054_b = p_70536_1_ % 16;
        this.field_94055_c = p_70536_1_ / 16;
    }

    public int func_70537_b() {
        return 3;
    }

    public void setColorFade(int rgb) {
        this.fadeTargetRed = (float)((rgb & 0xFF0000) >> 16) / 255.0f;
        this.fadeTargetGreen = (float)((rgb & 0xFF00) >> 8) / 255.0f;
        this.fadeTargetBlue = (float)(rgb & 0xFF) / 255.0f;
        this.fadingColor = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevParticleAngle = this.particleAngle;
        this.entityBrightness = this.field_70170_p.func_72801_o((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        if (this.field_70546_d > this.field_70547_e / 2) {
            if (this.fadeAway) {
                this.func_82338_g(1.0f - ((float)this.field_70546_d - (float)(this.field_70547_e / 2)) / (float)this.field_70547_e);
            }
            if (this.fadingColor) {
                this.field_70552_h += (this.fadeTargetRed - this.field_70552_h) * 0.2f;
                this.field_70553_i += (this.fadeTargetGreen - this.field_70553_i) * 0.2f;
                this.field_70551_j += (this.fadeTargetBlue - this.field_70551_j) * 0.2f;
            }
        }
    }
}

