/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class RandomXoshiro256StarStar
extends Random {
    private static final long serialVersionUID = -2837799889588687855L;
    private static final AtomicLong uniq = new AtomicLong(System.nanoTime());
    private static final long SPLITMIX1_MAGIC = -7046029254386353131L;
    private long s0;
    private long s1;
    private long s2;
    private long s3;

    private static long nextUniq() {
        return RandomXoshiro256StarStar.splitmix64_2(uniq.addAndGet(-7046029254386353131L));
    }

    public RandomXoshiro256StarStar() {
        this(System.nanoTime() ^ RandomXoshiro256StarStar.nextUniq());
    }

    public RandomXoshiro256StarStar(long seed) {
        super(seed);
    }

    public RandomXoshiro256StarStar(long s1, long s2, long s3, long s4) {
        this.setState(s1, s2, s3, s4);
    }

    private static long splitmix64_1(long x) {
        return x + -7046029254386353131L;
    }

    private static long splitmix64_2(long z) {
        z = (z ^ z >> 30) * -4658895280553007687L;
        z = (z ^ z >> 27) * -7723592293110705685L;
        return z ^ z >> 31;
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        long sms = RandomXoshiro256StarStar.splitmix64_1(seed);
        this.s0 = RandomXoshiro256StarStar.splitmix64_2(sms);
        sms = RandomXoshiro256StarStar.splitmix64_1(sms);
        this.s1 = RandomXoshiro256StarStar.splitmix64_2(sms);
        sms = RandomXoshiro256StarStar.splitmix64_1(sms);
        this.s2 = RandomXoshiro256StarStar.splitmix64_2(sms);
        sms = RandomXoshiro256StarStar.splitmix64_1(sms);
        this.s3 = RandomXoshiro256StarStar.splitmix64_2(sms);
    }

    public void setState(long s0, long s1, long s2, long s4) {
        if (s0 == 0L && s1 == 0L && s2 == 0L && s4 == 0L) {
            throw new IllegalArgumentException("xoshiro256** state cannot be all zeroes");
        }
        this.s0 = s0;
        this.s1 = s1;
        this.s2 = s2;
        this.s3 = s4;
    }

    @Override
    protected int next(int bits) {
        return (int)(this.nextLong() & (1L << bits) - 1L);
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int bound) {
        return (int)this.nextLong(bound);
    }

    @Override
    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (this.nextLong() & Long.MAX_VALUE) % bound;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return (this.nextLong() & 1L) != 0L;
    }

    @Override
    public void nextBytes(byte[] buf) {
        this.nextBytes(buf, 0, buf.length);
    }

    public void nextBytes(byte[] buf, int ofs, int len) {
        if (ofs < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset " + ofs + " is negative");
        }
        if (ofs >= buf.length) {
            throw new ArrayIndexOutOfBoundsException("Offset " + ofs + " is greater than buffer length");
        }
        if (ofs + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException("Length " + len + " with offset " + ofs + " is past end of buffer");
        }
        int j = 8;
        long l = 0L;
        for (int i = ofs; i < ofs + len; ++i) {
            if (j >= 8) {
                l = this.nextLong();
                j = 0;
            }
            buf[i] = (byte)(l & 0xFFL);
            l >>>= 8;
            ++j;
        }
    }

    private static long rotl(long x, int k) {
        return x << k | x >>> 64 - k;
    }

    @Override
    public long nextLong() {
        long result_starstar = RandomXoshiro256StarStar.rotl(this.s1 * 5L, 7) * 9L;
        long t = this.s1 << 17;
        this.s2 ^= this.s0;
        this.s3 ^= this.s1;
        this.s1 ^= this.s2;
        this.s0 ^= this.s3;
        this.s2 ^= t;
        this.s3 = RandomXoshiro256StarStar.rotl(this.s3, 45);
        return result_starstar;
    }
}

