/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.nether.biome.decorator;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.world.generate.feature.WorldGenBasaltPillars;
import ganymedes01.etfuturum.world.generate.feature.WorldGenNetherFossil;
import ganymedes01.etfuturum.world.nether.biome.decorator.NetherBiomeDecorator;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenerator;

public class SoulSandValleyDecorator
extends NetherBiomeDecorator {
    private final WorldGenerator crimsonGrassGenerator = new WorldGenFlowers(ModBlocks.NETHER_ROOTS.get());
    private WorldGenerator netherFossilGenerator;
    private final WorldGenerator pillarGenerator = new WorldGenBasaltPillars();

    @Override
    public void populate(World world, Random rand, int chunkX, int chunkZ) {
        if (ModBlocks.NETHER_ROOTS.isEnabled() && rand.nextInt(3) == 0) {
            int x = chunkX + rand.nextInt(16) + 8;
            int y = MathHelper.func_76136_a((Random)rand, (int)32, (int)(world.field_73011_w.getActualHeight() - 8));
            int z = chunkZ + rand.nextInt(16) + 8;
            this.crimsonGrassGenerator.func_76484_a(world, rand, x, y, z);
        }
    }

    @Override
    public void decorate(World world, Random rand, int chunkX, int chunkZ) {
        if (this.netherFossilGenerator == null && ConfigWorld.fossilBlock != null) {
            this.netherFossilGenerator = new WorldGenNetherFossil();
        }
        if (ConfigWorld.fossilBlock != null) {
            for (int attempt = 0; attempt < 3; ++attempt) {
                int x = chunkX + rand.nextInt(16) + 8;
                int y = MathHelper.func_76136_a((Random)rand, (int)32, (int)(world.field_73011_w.getActualHeight() - 8));
                int z = chunkZ + rand.nextInt(16) + 8;
                this.netherFossilGenerator.func_76484_a(world, rand, x, y, z);
            }
        }
        if (ModBlocks.BASALT.isEnabled() && rand.nextInt(6) == 0) {
            int x = chunkX + rand.nextInt(16) + 8;
            int y = MathHelper.func_76136_a((Random)rand, (int)32, (int)(world.field_73011_w.getActualHeight() - 8));
            int z = chunkZ + rand.nextInt(16) + 8;
            while (y++ <= world.field_73011_w.getActualHeight() - 8 && world.func_147437_c(x, y, z)) {
            }
            this.pillarGenerator.func_76484_a(world, rand, x, y - 1, z);
        }
    }
}

