/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.proxy;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.client.gui.inventory.GuiAnvil;
import ganymedes01.etfuturum.client.gui.inventory.GuiBarrel;
import ganymedes01.etfuturum.client.gui.inventory.GuiBlastFurnace;
import ganymedes01.etfuturum.client.gui.inventory.GuiEnchantment;
import ganymedes01.etfuturum.client.gui.inventory.GuiNewBrewingStand;
import ganymedes01.etfuturum.client.gui.inventory.GuiShulkerBox;
import ganymedes01.etfuturum.client.gui.inventory.GuiSmithingTable;
import ganymedes01.etfuturum.client.gui.inventory.GuiSmoker;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.handlers.EntityEventHandler;
import ganymedes01.etfuturum.core.handlers.SculkEventHandler;
import ganymedes01.etfuturum.core.handlers.ServerEventHandler;
import ganymedes01.etfuturum.core.handlers.WorldEventHandler;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.entities.EntityArmourStand;
import ganymedes01.etfuturum.entities.EntityBee;
import ganymedes01.etfuturum.entities.EntityBoostingFireworkRocket;
import ganymedes01.etfuturum.entities.EntityBrownMooshroom;
import ganymedes01.etfuturum.entities.EntityEndermite;
import ganymedes01.etfuturum.entities.EntityFox;
import ganymedes01.etfuturum.entities.EntityHusk;
import ganymedes01.etfuturum.entities.EntityItemUninflammable;
import ganymedes01.etfuturum.entities.EntityLingeringEffect;
import ganymedes01.etfuturum.entities.EntityLingeringPotion;
import ganymedes01.etfuturum.entities.EntityNewBoat;
import ganymedes01.etfuturum.entities.EntityNewBoatSeat;
import ganymedes01.etfuturum.entities.EntityNewBoatWithChest;
import ganymedes01.etfuturum.entities.EntityNewSnowGolem;
import ganymedes01.etfuturum.entities.EntityPlacedEndCrystal;
import ganymedes01.etfuturum.entities.EntityRabbit;
import ganymedes01.etfuturum.entities.EntityRespawnedDragon;
import ganymedes01.etfuturum.entities.EntityShulker;
import ganymedes01.etfuturum.entities.EntityShulkerBullet;
import ganymedes01.etfuturum.entities.EntityStray;
import ganymedes01.etfuturum.entities.EntityTippedArrow;
import ganymedes01.etfuturum.entities.EntityZombieVillager;
import ganymedes01.etfuturum.entities.ModEntityList;
import ganymedes01.etfuturum.inventory.ContainerAnvil;
import ganymedes01.etfuturum.inventory.ContainerBlastFurnace;
import ganymedes01.etfuturum.inventory.ContainerChestGeneric;
import ganymedes01.etfuturum.inventory.ContainerEnchantment;
import ganymedes01.etfuturum.inventory.ContainerNewBrewingStand;
import ganymedes01.etfuturum.inventory.ContainerSmithingTable;
import ganymedes01.etfuturum.inventory.ContainerSmoker;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import ganymedes01.etfuturum.tileentities.TileEntityBanner;
import ganymedes01.etfuturum.tileentities.TileEntityBarrel;
import ganymedes01.etfuturum.tileentities.TileEntityBeeHive;
import ganymedes01.etfuturum.tileentities.TileEntityBlastFurnace;
import ganymedes01.etfuturum.tileentities.TileEntityCauldronPotion;
import ganymedes01.etfuturum.tileentities.TileEntityCaveVines;
import ganymedes01.etfuturum.tileentities.TileEntityGateway;
import ganymedes01.etfuturum.tileentities.TileEntityGlowLichen;
import ganymedes01.etfuturum.tileentities.TileEntityNewBeacon;
import ganymedes01.etfuturum.tileentities.TileEntityNewBrewingStand;
import ganymedes01.etfuturum.tileentities.TileEntitySculkCatalyst;
import ganymedes01.etfuturum.tileentities.TileEntityShulkerBox;
import ganymedes01.etfuturum.tileentities.TileEntitySmoker;
import ganymedes01.etfuturum.tileentities.TileEntityWoodSign;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.ArrayUtils;

public class CommonProxy
implements IGuiHandler {
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)EntityEventHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)ServerEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ServerEventHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)WorldEventHandler.INSTANCE);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)WorldEventHandler.INSTANCE);
        if (ConfigMixins.enableSpectatorMode) {
            FMLCommonHandler.instance().bus().register((Object)SpectatorMode.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)SpectatorMode.INSTANCE);
        }
        if (ModBlocks.SCULK_CATALYST.isEnabled()) {
            FMLCommonHandler.instance().bus().register((Object)SculkEventHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)SculkEventHandler.INSTANCE);
        }
        if (ModItems.DEBUGGING_TOOL.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)ModItems.DEBUGGING_TOOL.get());
        }
    }

    public void registerEntities() {
        if (ModBlocks.BREWING_STAND.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityNewBrewingStand.class, (String)Utils.getUnlocalisedName("brewing_stand"));
        }
        if (ModBlocks.BEACON.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityNewBeacon.class, (String)Utils.getUnlocalisedName("beacon"));
        }
        if (ModBlocks.BARREL.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityBarrel.class, (String)Utils.getUnlocalisedName("barrel"));
        }
        if (ModBlocks.SMOKER.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntitySmoker.class, (String)Utils.getUnlocalisedName("smoker"));
        }
        if (ModBlocks.BLAST_FURNACE.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityBlastFurnace.class, (String)Utils.getUnlocalisedName("blast_furnace"));
        }
        if (ConfigBlocksItems.enableVanillaSigns) {
            GameRegistry.registerTileEntity(TileEntityWoodSign.class, (String)Utils.getUnlocalisedName("sign"));
        }
        if (ModBlocks.SCULK_CATALYST.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntitySculkCatalyst.class, (String)Utils.getUnlocalisedName("sculk_catalyst"));
        }
        if (ModBlocks.END_GATEWAY.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityGateway.class, (String)Utils.getUnlocalisedName("end_gateway"));
        }
        if (ModBlocks.SHULKER_BOX.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityShulkerBox.class, (String)Utils.getUnlocalisedName("shulker_box"));
        }
        if (ModBlocks.POTION_CAULDRON.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityCauldronPotion.class, (String)Utils.getUnlocalisedName("potion_cauldron"));
        }
        if (ModBlocks.BANNER.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityBanner.class, (String)Utils.getUnlocalisedName("banner"));
        }
        if (ModBlocks.BEEHIVE.isEnabled() || ModBlocks.BEE_NEST.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityBeeHive.class, (String)Utils.getUnlocalisedName("hive"));
        }
        if (ModBlocks.GLOW_LICHEN.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityGlowLichen.class, (String)Utils.getUnlocalisedName("glow_lichen"));
        }
        if (ModBlocks.CAVE_VINE.isEnabled()) {
            GameRegistry.registerTileEntity(TileEntityCaveVines.class, (String)Utils.getUnlocalisedName("cave_vines"));
        }
        if (ConfigEntities.enableRabbit) {
            ModEntityList.registerEntity(EntityRabbit.class, "rabbit", 3, EtFuturum.instance, 80, 3, true, 10051392, 7555121);
            EntityRegistry.addSpawn(EntityRabbit.class, (int)3, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
            Object[] array = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY);
            array = (BiomeGenBase[])ArrayUtils.addAll((Object[])array, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            array = (BiomeGenBase[])ArrayUtils.addAll((Object[])array, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            for (BiomeGenBase biome : (BiomeGenBase[])ArrayUtils.clone((Object[])array)) {
                if (!biome.getClass().getName().toLowerCase().contains("divinerpg")) continue;
                ArrayUtils.removeElement((Object[])array, (Object)biome);
            }
            EntityRegistry.addSpawn(EntityRabbit.class, (int)6, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])array);
        }
        if (ConfigBlocksItems.enableArmourStand) {
            ModEntityList.registerEntity(EntityArmourStand.class, "wooden_armorstand", 0, EtFuturum.instance, 64, 1, true);
        }
        if (ConfigEntities.enableEndermite) {
            ModEntityList.registerEntity(EntityEndermite.class, "endermite", 1, EtFuturum.instance, 64, 1, true, 0x161616, 0x6E6E6E);
        }
        if (ConfigBlocksItems.enableTippedArrows) {
            ModEntityList.registerEntity(EntityTippedArrow.class, "tipped_arrow", 2, EtFuturum.instance, 64, 20, true);
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLClientHandler.instance().hasOptifine()) {
            if (!ConfigWorld.oldHuskSpawning) {
                Logger.warn("OptiFine detected, old husk spawn logic will be enabled since OptiFine is stupid and breaks the default behavior.");
                ConfigWorld.oldHuskSpawning = true;
            }
            if (!ConfigWorld.oldStraySpawning) {
                Logger.warn("OptiFine detected, old stray spawn logic will be enabled since OptiFine is stupid and breaks the default behavior.");
                ConfigWorld.oldStraySpawning = true;
            }
        }
        if (ConfigEntities.enableHusk) {
            ModEntityList.registerEntity(EntityHusk.class, "husk", 4, EtFuturum.instance, 80, 3, true, 7828833, 14735761);
            if (ConfigWorld.oldHuskSpawning) {
                ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SANDY)));
                biomes.retainAll(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.DRY)));
                biomes.retainAll(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.HOT)));
                BiomeGenBase[] biomeArray = (BiomeGenBase[])ArrayUtils.addAll((Object[])new BiomeGenBase[0], (Object[])biomes.toArray());
                EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomeArray);
                EntityRegistry.addSpawn(EntityZombie.class, (int)20, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomeArray);
                EntityRegistry.addSpawn(EntityHusk.class, (int)80, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomeArray);
            }
        }
        if (ConfigEntities.enableStray) {
            ModEntityList.registerEntity(EntityStray.class, "stray", 5, EtFuturum.instance, 80, 3, true, 6387576, 0xE6EAEA);
            if (ConfigWorld.oldStraySpawning) {
                EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                EntityRegistry.addSpawn(EntitySkeleton.class, (int)20, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                EntityRegistry.addSpawn(EntityStray.class, (int)80, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
            }
        }
        if (ConfigEntities.enableNetherEndermen) {
            EntityRegistry.addSpawn(EntityEnderman.class, (int)1, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76778_j});
        }
        if (ConfigBlocksItems.enableLingeringPotions) {
            ModEntityList.registerEntity(EntityLingeringPotion.class, "lingering_potion", 6, EtFuturum.instance, 64, 10, true);
            ModEntityList.registerEntity(EntityLingeringEffect.class, "lingering_effect", 7, EtFuturum.instance, 64, 1, true);
        }
        if (ConfigEntities.enableVillagerZombies) {
            ModEntityList.registerEntity(EntityZombieVillager.class, "villager_zombie", 8, EtFuturum.instance, 80, 3, true, 44975, 7969893);
        }
        if (ConfigEntities.enableDragonRespawn) {
            ModEntityList.registerEntity(EntityPlacedEndCrystal.class, "end_crystal", 9, EtFuturum.instance, 256, Integer.MAX_VALUE, false);
            ModEntityList.registerEntity(EntityRespawnedDragon.class, "ender_dragon", 10, EtFuturum.instance, 160, 3, true);
        }
        if (ConfigEntities.enableShearableSnowGolems) {
            ModEntityList.registerEntity(EntityNewSnowGolem.class, "snow_golem", 11, EtFuturum.instance, 80, 3, true);
        }
        if (ConfigEntities.enableBrownMooshroom) {
            ModEntityList.registerEntity(EntityBrownMooshroom.class, "brown_mooshroom", 12, EtFuturum.instance, 80, 3, true);
        }
        ModEntityList.registerEntity(EntityItemUninflammable.class, "fireproof_item", 15, EtFuturum.instance, 64, 1, true);
        if (ConfigEntities.enableShulker) {
            ModEntityList.registerEntity(EntityShulker.class, "shulker", 16, EtFuturum.instance, 80, 1, false, 9725844, 5060690);
            ModEntityList.registerEntity(EntityShulkerBullet.class, "shulker_candy", 17, EtFuturum.instance, 64, 1, true);
            if (ConfigTweaks.shulkersSpawnAnywhere) {
                EntityRegistry.addSpawn(EntityShulker.class, (int)1, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END));
            }
        }
        if (ConfigBlocksItems.enableNewBoats) {
            ModEntityList.registerEntity(EntityNewBoat.class, "new_boat", 13, EtFuturum.instance, 64, 1, true);
            ModEntityList.registerEntity(EntityNewBoatWithChest.class, "chest_boat", 19, EtFuturum.instance, 64, 1, true);
            ModEntityList.registerEntity(EntityNewBoatSeat.class, "new_boat_seat", 14, EtFuturum.instance, 64, 1, false);
        }
        if (ConfigMixins.enableElytra) {
            ModEntityList.registerEntity(EntityBoostingFireworkRocket.class, "boosting_firework_rocket", 20, EtFuturum.instance, 64, 1, true);
        }
        if (ConfigEntities.enableBees) {
            ModEntityList.registerEntity(EntityBee.class, "bee", 21, EtFuturum.instance, 80, 1, true, 15582019, 4400155);
        }
        if (ConfigEntities.enableFoxes) {
            ModEntityList.registerEntity(EntityFox.class, "fox", 22, EtFuturum.instance, 64, 1, true, 14005919, 13396256);
            EntityRegistry.addSpawn(EntityFox.class, (int)8, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS));
        }
        EntityRegistry.removeSpawn(EntityMagmaCube.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76778_j});
        EntityRegistry.addSpawn(EntityMagmaCube.class, (int)2, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76778_j});
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Object object;
        switch (ID) {
            case 0: {
                object = new ContainerEnchantment(player.field_71071_by, world, x, y, z);
                break;
            }
            case 1: {
                object = new ContainerAnvil(player, world, x, y, z);
                break;
            }
            case 2: {
                object = new ContainerNewBrewingStand(player.field_71071_by, (TileEntityNewBrewingStand)world.func_147438_o(x, y, z));
                break;
            }
            case 3: {
                object = new ContainerChestGeneric((IInventory)player.field_71071_by, (TileEntityBarrel)world.func_147438_o(x, y, z), ((TileEntityBarrel)world.func_147438_o(x, y, z)).getRowSize(), ((TileEntityBarrel)world.func_147438_o(x, y, z)).func_70302_i_() != 27);
                break;
            }
            case 4: {
                object = new ContainerSmoker(player.field_71071_by, (TileEntitySmoker)world.func_147438_o(x, y, z));
                break;
            }
            case 5: {
                object = new ContainerBlastFurnace(player.field_71071_by, (TileEntityBlastFurnace)world.func_147438_o(x, y, z));
                break;
            }
            case 6: {
                object = new ContainerChestGeneric((IInventory)player.field_71071_by, (TileEntityShulkerBox)world.func_147438_o(x, y, z), ((TileEntityShulkerBox)world.func_147438_o(x, y, z)).getRowSize(), ((TileEntityShulkerBox)world.func_147438_o(x, y, z)).func_70302_i_() != 27);
                break;
            }
            case 7: {
                object = new ContainerSmithingTable(player.field_71071_by, world);
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Object object;
        switch (ID) {
            case 0: {
                object = new GuiEnchantment(player.field_71071_by, world, null);
                break;
            }
            case 1: {
                object = new GuiAnvil(player, world, x, y, z);
                break;
            }
            case 2: {
                object = new GuiNewBrewingStand(player.field_71071_by, (TileEntityNewBrewingStand)world.func_147438_o(x, y, z));
                break;
            }
            case 3: {
                object = new GuiBarrel((IInventory)player.field_71071_by, (TileEntityBarrel)world.func_147438_o(x, y, z));
                break;
            }
            case 4: {
                object = new GuiSmoker(player.field_71071_by, (TileEntitySmoker)world.func_147438_o(x, y, z));
                break;
            }
            case 5: {
                object = new GuiBlastFurnace(player.field_71071_by, (TileEntityBlastFurnace)world.func_147438_o(x, y, z));
                break;
            }
            case 6: {
                object = new GuiShulkerBox((IInventory)player.field_71071_by, (TileEntityShulkerBox)world.func_147438_o(x, y, z));
                break;
            }
            case 7: {
                object = new GuiSmithingTable(new ContainerSmithingTable(player.field_71071_by, world));
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public void registerRenderers() {
    }
}

