/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.feature;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.structurenbt.EFRBlockStateConverter;
import ganymedes01.etfuturum.core.utils.structurenbt.NBTStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenFossil
extends WorldGenerator {
    private final List<Pair<NBTStructure, NBTStructure>> fossils = Lists.newArrayList();

    public WorldGenFossil() {
        for (int i = 1; i <= 4; ++i) {
            this.fossils.add((Pair<NBTStructure, NBTStructure>)new ImmutablePair((Object)new NBTStructure("/data/structure/fossil/skull_" + i + ".nbt", EFRBlockStateConverter.INSTANCE), (Object)new NBTStructure("/data/structure/fossil/skull_" + i + "_coal.nbt", EFRBlockStateConverter.INSTANCE)));
            this.fossils.add((Pair<NBTStructure, NBTStructure>)new ImmutablePair((Object)new NBTStructure("/data/structure/fossil/spine_" + i + ".nbt", EFRBlockStateConverter.INSTANCE), (Object)new NBTStructure("/data/structure/fossil/spine_" + i + "_coal.nbt", EFRBlockStateConverter.INSTANCE)));
        }
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Pair<NBTStructure, NBTStructure> fossilPair = this.fossils.get(rand.nextInt(this.fossils.size()));
        ForgeDirection dir = ForgeDirection.getOrientation((int)(rand.nextInt(4) + 2));
        if (!this.canFossilGenerateHere(world, x, y, z, ((NBTStructure)fossilPair.getLeft()).getSize(dir))) {
            return false;
        }
        ((NBTStructure)fossilPair.getLeft()).placeStructure(world, rand, x, y, z, dir, 0.9f);
        ((NBTStructure)fossilPair.getRight()).placeStructure(world, rand, x, y, z, dir, 0.1f);
        return true;
    }

    protected boolean canFossilGenerateHere(World world, int x, int y, int z, BlockPos corners) {
        int air = 0;
        if (!this.validCorner(world, x, y, z)) {
            ++air;
        }
        if (!this.validCorner(world, x + corners.getX(), y, z)) {
            ++air;
        }
        if (!this.validCorner(world, x, y, z + corners.getZ())) {
            ++air;
        }
        if (!this.validCorner(world, x + corners.getX(), y, z + corners.getZ())) {
            ++air;
        }
        if (!this.validCorner(world, x, y + corners.getY(), z)) {
            ++air;
        }
        if (!this.validCorner(world, x + corners.getX(), y + corners.getY(), z) && air++ >= 5) {
            return false;
        }
        if (!this.validCorner(world, x, y + corners.getY(), z + corners.getZ()) && air++ >= 5) {
            return false;
        }
        if (!this.validCorner(world, x + corners.getX(), y + corners.getY(), z + corners.getZ()) && air++ >= 5) {
            return false;
        }
        return air < 5;
    }

    protected boolean validCorner(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block != Blocks.field_150350_a && block.func_149662_c();
    }
}

