/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.network;

import com.gtnh.findit.FindIt;
import com.gtnh.findit.network.KIFoundItMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class PlzFindItMessage
implements IMessage {
    static WeakHashMap<EntityPlayerMP, Long> lastCalled = new WeakHashMap();
    private ItemStack stack;

    public PlzFindItMessage(ItemStack stack) {
        this.stack = stack;
    }

    public PlzFindItMessage() {
    }

    public static List<ChunkPosition> getBlockPosInAABB(AxisAlignedBB axisAlignedBB) {
        ArrayList<ChunkPosition> blocks = new ArrayList<ChunkPosition>();
        int maxY = (int)Math.round(axisAlignedBB.field_72337_e);
        int maxX = (int)Math.round(axisAlignedBB.field_72336_d);
        int maxZ = (int)Math.round(axisAlignedBB.field_72334_f);
        for (int y = (int)Math.round(axisAlignedBB.field_72338_b); y < maxY; ++y) {
            for (int x = (int)Math.round(axisAlignedBB.field_72340_a); x < maxX; ++x) {
                for (int z = (int)Math.round(axisAlignedBB.field_72339_c); z < maxZ; ++z) {
                    blocks.add(new ChunkPosition(x, y, z));
                }
            }
        }
        return blocks;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.stack = null;
        try {
            this.stack = packetBuffer.func_150791_c();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        try {
            packetBuffer.func_150788_a(this.stack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Handler
    implements IMessageHandler<PlzFindItMessage, KIFoundItMessage> {
        public KIFoundItMessage onMessage(PlzFindItMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            long time = world.func_82737_E();
            Long lastCalled = PlzFindItMessage.lastCalled.get(player);
            if (lastCalled != null && time - lastCalled < 10L) {
                return null;
            }
            Item toFind = message.stack.func_77973_b();
            int metaToFind = message.stack.func_77960_j();
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            int r = FindIt.SEARCH_RADIUS;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - (double)r), (double)(y - (double)r), (double)(z - (double)r), (double)(x + (double)r), (double)(y + (double)r), (double)(z + (double)r));
            ArrayList<ChunkPosition> posList = new ArrayList<ChunkPosition>();
            for (ChunkPosition pos : PlzFindItMessage.getBlockPosInAABB(box)) {
                try {
                    Item tileItem;
                    TileEntity tileEntity = world.func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                    if (tileEntity == null || (tileItem = Item.func_150898_a((Block)tileEntity.func_145838_q())) == null) continue;
                    int tileMeta = tileEntity instanceof IGregTechTileEntity ? ((IGregTechTileEntity)tileEntity).getMetaTileID() : world.func_72805_g(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                    if (!toFind.equals(tileItem) || metaToFind != tileMeta) continue;
                    posList.add(pos);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
            if (!posList.isEmpty()) {
                FindIt.NETWORK.sendTo((IMessage)new KIFoundItMessage(posList), player);
            }
            return null;
        }
    }
}

