/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.network;

import com.gtnh.findit.proxy.client.ParticlePosition;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class KIFoundItMessage
implements IMessage {
    private List<ChunkPosition> positions;

    public KIFoundItMessage(List<ChunkPosition> positions) {
        this.positions = positions;
    }

    public KIFoundItMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.positions = new ArrayList<ChunkPosition>();
        for (int amount = packetBuffer.readInt(); amount > 0; --amount) {
            int x = packetBuffer.readInt();
            short y = packetBuffer.readUnsignedByte();
            int z = packetBuffer.readInt();
            this.positions.add(new ChunkPosition(x, (int)y, z));
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.writeInt(this.positions.size());
        for (ChunkPosition pos : this.positions) {
            packetBuffer.writeInt(pos.field_151329_a);
            packetBuffer.writeByte(pos.field_151327_b);
            packetBuffer.writeInt(pos.field_151328_c);
        }
    }

    public static class Handler
    implements IMessageHandler<KIFoundItMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(KIFoundItMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            for (ChunkPosition pos : message.positions) {
                for (int i = 0; i < 2; ++i) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new ParticlePosition(Minecraft.func_71410_x().field_71439_g.field_70170_p, (double)pos.field_151329_a + (0.5 + (world.field_73012_v.nextDouble() - 0.5) * world.field_73012_v.nextDouble()), (double)pos.field_151327_b + (0.5 + (world.field_73012_v.nextDouble() - 0.5) * world.field_73012_v.nextDouble()), (double)pos.field_151328_c + (0.5 + (world.field_73012_v.nextDouble() - 0.5) * world.field_73012_v.nextDouble())));
                }
            }
            return null;
        }
    }
}

