/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.itemfinder;

import codechicken.nei.api.API;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import com.gtnh.findit.FindIt;
import com.gtnh.findit.FindItNetwork;
import com.gtnh.findit.fx.ParticlePosition;
import com.gtnh.findit.fx.SlotHighlighter;
import com.gtnh.findit.service.itemfinder.FindItemRequest;
import com.gtnh.findit.service.itemfinder.HighlightSlotsPacket;
import com.gtnh.findit.service.itemfinder.ItemFindService;
import com.gtnh.findit.service.itemfinder.ItemFoundResponse;
import com.gtnh.findit.util.AbstractStackFinder;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientItemFindService
extends ItemFindService {
    private ContainerHighlightData highlightData = null;

    public ClientItemFindService() {
        if (!FindIt.isExtraUtilitiesLoaded()) {
            API.addKeyBind((String)"gui.findit.find_item", (int)20);
        }
        GuiContainerManager.addInputHandler((IContainerInputHandler)new ItemFindInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GuiListener());
        FMLCommonHandler.instance().bus().register((Object)new TickListener());
    }

    public void handleResponse(EntityClientPlayerMP player, ItemFoundResponse response) {
        World world = player.field_70170_p;
        player.func_71053_j();
        ParticlePosition.highlightBlocks(world, response.getPositions());
    }

    public void handleSlotHighlight(HighlightSlotsPacket packet) {
        this.highlightData = new ContainerHighlightData(packet.getWindowId(), packet.getTargetStack(), packet.getTargetSlots());
    }

    public static ClientItemFindService getInstance() {
        return (ClientItemFindService)FindIt.getItemFindService();
    }

    private static class ContainerHighlightData {
        private final int windowId;
        private final ItemStack targetStack;
        private final List<Integer> targetSlots;
        private final List<Integer> highlightedSlots = new ArrayList<Integer>();

        public ContainerHighlightData(int windowId, ItemStack targetStack, List<Integer> targetSlots) {
            this.windowId = windowId;
            this.targetStack = targetStack;
            this.targetSlots = targetSlots;
        }

        public void updateHighlightedSlots(GuiContainer gui) {
            this.highlightedSlots.clear();
            List slots = gui.field_147002_h.field_75151_b;
            Item targetItem = this.targetStack.func_77973_b();
            int targetMeta = this.targetStack.func_77960_j();
            for (int slotId : this.targetSlots) {
                Slot slot;
                ItemStack stack;
                if (slotId >= slots.size() || (stack = (slot = (Slot)slots.get(slotId)).func_75211_c()) == null || stack.func_77973_b() != targetItem || stack.func_77960_j() != targetMeta) continue;
                this.highlightedSlots.add(slotId);
            }
        }
    }

    private static class ItemFindInputHandler
    extends AbstractStackFinder {
        private ItemFindInputHandler() {
        }

        @Override
        protected String getKeyBindId() {
            return FindIt.isExtraUtilitiesLoaded() ? "gui.xu_ping" : "gui.findit.find_item";
        }

        @Override
        protected boolean findStack(ItemStack stack) {
            FindItNetwork.CHANNEL.sendToServer((IMessage)new FindItemRequest(stack));
            return true;
        }
    }

    public class GuiListener {
        @SubscribeEvent
        public void onGuiPostRender(GuiScreenEvent.DrawScreenEvent.Pre event) {
            if (!(event.gui instanceof GuiContainer)) {
                return;
            }
            GuiContainer gui = (GuiContainer)event.gui;
            if (ClientItemFindService.this.highlightData != null && ClientItemFindService.this.highlightData.windowId == gui.field_147002_h.field_75152_c) {
                SlotHighlighter.highlightSlots(gui, ClientItemFindService.this.highlightData.highlightedSlots, -30938);
            }
        }
    }

    public class TickListener {
        @SubscribeEvent
        public void onClientPostTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (!(screen instanceof GuiContainer)) {
                return;
            }
            GuiContainer gui = (GuiContainer)screen;
            if (ClientItemFindService.this.highlightData != null) {
                if (ClientItemFindService.this.highlightData.windowId == gui.field_147002_h.field_75152_c) {
                    ClientItemFindService.this.highlightData.updateHighlightedSlots(gui);
                } else {
                    ClientItemFindService.this.highlightData = null;
                }
            }
        }
    }
}

