/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.itemfinder;

import com.gtnh.findit.FindIt;
import com.gtnh.findit.FindItConfig;
import com.gtnh.findit.FindItNetwork;
import com.gtnh.findit.service.itemfinder.FindItemRequest;
import com.gtnh.findit.service.itemfinder.HighlightSlotsPacket;
import com.gtnh.findit.service.itemfinder.ItemFoundResponse;
import com.gtnh.findit.util.WorldUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;

public class ItemFindService {
    private final Map<EntityPlayerMP, ItemFoundResult> lastResults = new HashMap<EntityPlayerMP, ItemFoundResult>();
    private final Map<EntityPlayerMP, Integer> lastProcessedContainers = new HashMap<EntityPlayerMP, Integer>();

    public ItemFindService() {
        FindItNetwork.registerMessage(FindItemRequest.Handler.class, FindItemRequest.class, Side.SERVER);
        FindItNetwork.registerMessage(ItemFoundResponse.Handler.class, ItemFoundResponse.class, Side.CLIENT);
        FindItNetwork.registerMessage(HighlightSlotsPacket.Handler.class, HighlightSlotsPacket.class, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new ContainerListener());
    }

    private ItemFoundResult getLastFoundResult(EntityPlayerMP player) {
        ItemFoundResult lastResult = this.lastResults.get(player);
        if (lastResult != null && !lastResult.isValid(player.func_130014_f_())) {
            this.lastResults.remove(player);
            return null;
        }
        return lastResult;
    }

    public void handleRequest(EntityPlayerMP player, FindItemRequest request) {
        if (FindIt.getCooldownService().checkSearchCooldown(player)) {
            return;
        }
        Item itemToFind = request.getStackToFind().func_77973_b();
        int metaToFind = request.getStackToFind().func_77960_j();
        ArrayList<ChunkPosition> positions = new ArrayList<ChunkPosition>();
        block2: for (TileEntity tileEntity : WorldUtils.getTileEntitiesAround((Entity)player, FindItConfig.SEARCH_RADIUS)) {
            try {
                if (!(tileEntity instanceof IInventory)) continue;
                IInventory inventory = (IInventory)tileEntity;
                for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                    ItemStack stackInSlot = inventory.func_70301_a(slot);
                    if (stackInSlot == null || stackInSlot.func_77973_b() != itemToFind || itemToFind.func_77614_k() && stackInSlot.func_77960_j() != metaToFind) continue;
                    positions.add(new ChunkPosition(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e));
                    if (positions.size() != FindItConfig.MAX_RESPONSE_SIZE) continue block2;
                    break block2;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        if (!positions.isEmpty()) {
            ItemFoundResult foundResult = new ItemFoundResult(request.getStackToFind(), positions, player.func_130014_f_().func_82737_E());
            this.lastResults.put(player, foundResult);
            FindItNetwork.CHANNEL.sendTo((IMessage)new ItemFoundResponse(request.getStackToFind(), positions), player);
        }
    }

    private void processOpenContainer(EntityPlayerMP player) {
        this.lastProcessedContainers.put(player, player.field_71070_bA.field_75152_c);
        Container container = player.field_71070_bA;
        ItemFoundResult lastFoundResult = this.getLastFoundResult(player);
        if (lastFoundResult == null) {
            return;
        }
        List slots = container.field_75151_b;
        ArrayList<Integer> targetSlots = new ArrayList<Integer>();
        HashSet<ChunkPosition> tilePositions = new HashSet<ChunkPosition>();
        for (int slotId = 0; slotId < slots.size(); ++slotId) {
            Slot slot = (Slot)slots.get(slotId);
            IInventory inventory = this.getSlotTrueInventory(slot);
            if (!(inventory instanceof TileEntity)) continue;
            TileEntity tile = (TileEntity)inventory;
            ChunkPosition tilePos = new ChunkPosition(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            if (!lastFoundResult.containsPosition(tilePos)) continue;
            targetSlots.add(slotId);
            tilePositions.add(tilePos);
            if (targetSlots.size() >= 256) break;
        }
        if (!targetSlots.isEmpty()) {
            tilePositions.forEach(lastFoundResult::pollPosition);
            FindItNetwork.CHANNEL.sendTo((IMessage)new HighlightSlotsPacket(container.field_75152_c, lastFoundResult.foundStack, targetSlots), player);
        }
    }

    private IInventory getSlotTrueInventory(Slot slot) {
        if (slot.field_75224_c instanceof InventoryLargeChest) {
            InventoryLargeChest largeChest = (InventoryLargeChest)slot.field_75224_c;
            return slot.field_75222_d < largeChest.field_70477_b.func_70302_i_() ? largeChest.field_70477_b : largeChest.field_70478_c;
        }
        return slot.field_75224_c;
    }

    public static class ItemFoundResult {
        private final ItemStack foundStack;
        private final Set<ChunkPosition> positions = new HashSet<ChunkPosition>();
        private final long responseTime;

        public ItemFoundResult(ItemStack foundStack, List<ChunkPosition> positions, long responseTime) {
            this.foundStack = foundStack;
            this.positions.addAll(positions);
            this.responseTime = responseTime;
        }

        public ItemStack getFoundStack() {
            return this.foundStack;
        }

        public boolean isValid(World world) {
            return !this.positions.isEmpty() && world.func_82737_E() - this.responseTime < 1200L;
        }

        public boolean containsPosition(ChunkPosition position) {
            return this.positions.contains(position);
        }

        public void pollPosition(ChunkPosition position) {
            this.positions.remove(position);
        }
    }

    public class ContainerListener {
        @SubscribeEvent
        public void onContainerOpen(PlayerOpenContainerEvent event) {
            if (event.entityPlayer.field_70170_p.field_72995_K) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
            if (player.field_71070_bA == player.field_71069_bz) {
                return;
            }
            int lastProcessedContainer = ItemFindService.this.lastProcessedContainers.getOrDefault(player, -1);
            if (player.field_71070_bA.field_75152_c != lastProcessedContainer) {
                ItemFindService.this.processOpenContainer(player);
            }
        }
    }
}

