/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.api.arboriculture.EnumWoodType;
import forestry.arboriculture.items.ItemBlockWood;
import forestry.arboriculture.render.IconProviderWood;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderStairItem
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                RenderStairItem.renderStairBlock((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                RenderStairItem.renderStairBlock((RenderBlocks)data[0], item, 0.5f, 0.5f, 0.5f);
                break;
            }
            case INVENTORY: {
                RenderStairItem.renderStairBlock((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
        }
    }

    private static void renderStairBlock(RenderBlocks renderBlocks, ItemStack itemStack, float x, float y, float z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Block block = ItemStackUtil.getBlock(itemStack);
        if (!(itemStack.func_77973_b() instanceof ItemBlockWood) || block == null) {
            return;
        }
        EnumWoodType woodType = ItemBlockWood.getWoodType(itemStack);
        IIcon texture = IconProviderWood.getPlankIcon(woodType);
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
            }
            if (i == 1) {
                renderBlocks.func_147782_a(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderBlocks.func_147768_a(block, (double)x, (double)y, (double)z, texture);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderBlocks.func_147806_b(block, (double)x, (double)y, (double)z, texture);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderBlocks.func_147761_c(block, (double)x, (double)y, (double)z, texture);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderBlocks.func_147734_d(block, (double)x, (double)y, (double)z, texture);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderBlocks.func_147798_e(block, (double)x, (double)y, (double)z, texture);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderBlocks.func_147764_f(block, (double)x, (double)y, (double)z, texture);
            tessellator.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }
}

