/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerCrafting;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.SlotCrafter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.inventory.InventoryCraftingForestry;
import forestry.factory.network.packets.PacketWorktableMemoryUpdate;
import forestry.factory.network.packets.PacketWorktableRecipeUpdate;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.TileWorktable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerWorktable
extends ContainerTile<TileWorktable>
implements IContainerCrafting,
IGuiSelectable {
    private final InventoryCraftingForestry craftMatrix = new InventoryCraftingForestry(this);
    private long lastMemoryUpdate;
    private boolean craftMatrixChanged = false;

    public ContainerWorktable(EntityPlayer player, TileWorktable tile) {
        super(tile, player.field_71071_by, 8, 136);
        int i;
        IInventory craftingDisplay = tile.getCraftingDisplay();
        IInventoryAdapter internalInventory = tile.getInternalInventory();
        for (i = 0; i < 2; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)internalInventory, 0 + k + i * 9, 8 + k * 18, 90 + i * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.func_75146_a(new SlotCraftMatrix(this, craftingDisplay, k1 + l * 3, 11 + k1 * 18, 20 + l * 18));
            }
        }
        this.func_75146_a((Slot)new SlotCrafter(player, craftingDisplay, tile, 9, 77, 38));
        for (i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            this.onCraftMatrixChanged(tile.getCraftingDisplay(), i);
        }
    }

    @Override
    public void func_75142_b() {
        if (this.craftMatrixChanged) {
            this.craftMatrixChanged = false;
            ((TileWorktable)this.tile).setCurrentRecipe(this.craftMatrix);
            this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
        }
        super.func_75142_b();
        if (this.lastMemoryUpdate != ((TileWorktable)this.tile).getMemory().getLastUpdate()) {
            this.lastMemoryUpdate = ((TileWorktable)this.tile).getMemory().getLastUpdate();
            this.sendPacketToCrafters(new PacketWorktableMemoryUpdate((TileWorktable)this.tile));
        }
    }

    private void updateCraftMatrix() {
        IInventory crafting = ((TileWorktable)this.tile).getCraftingDisplay();
        for (int i = 0; i < crafting.func_70302_i_(); ++i) {
            this.onCraftMatrixChanged(crafting, i);
        }
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory, int slot) {
        ItemStack currentStack;
        if (slot >= this.craftMatrix.func_70302_i_()) {
            return;
        }
        ItemStack stack = iinventory.func_70301_a(slot);
        if (!ItemStackUtil.isIdenticalItem(stack, currentStack = this.craftMatrix.func_70301_a(slot))) {
            this.craftMatrix.func_70299_a(slot, stack);
        }
    }

    public void func_75130_a(IInventory iinventory) {
        this.craftMatrixChanged = true;
    }

    public static void clearRecipe() {
        ContainerWorktable.sendRecipeClick(-1, 0);
    }

    public static void sendRecipeClick(int mouseButton, int recipeIndex) {
        Proxies.net.sendToServer(new PacketGuiSelectRequest(mouseButton, recipeIndex));
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packet) {
        int primary = packet.getPrimaryIndex();
        int secondary = packet.getSecondaryIndex();
        switch (primary) {
            case -1: {
                ((TileWorktable)this.tile).clearCraftMatrix();
                this.updateCraftMatrix();
                this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 0: {
                ((TileWorktable)this.tile).chooseRecipeMemory(secondary);
                this.updateCraftMatrix();
                this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 1: {
                long time = player.field_70170_p.func_82737_E();
                RecipeMemory memory = ((TileWorktable)this.tile).getMemory();
                memory.toggleLock(time, secondary);
                break;
            }
            case 100: {
                ((TileWorktable)this.tile).choosePreviousConflictRecipe();
                this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 101: {
                ((TileWorktable)this.tile).chooseNextConflictRecipe();
                this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
            }
        }
    }
}

