/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.entities.golems.upgrades;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import makeo.gadomancy.common.entities.golems.upgrades.GolemUpgrade;
import makeo.gadomancy.common.registration.RegisteredGolemStuff;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.EnumGolemType;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXShield;

public class GolemUpgradeRunicShield
extends GolemUpgrade {
    private static final String LAST_DISCHARGE_TAG = "lastRunicDischarge";

    @Override
    public String getName() {
        return "runicShield";
    }

    public float absorb(EntityGolemBase golem, float amount, DamageSource source) {
        float charge = this.getCharge(golem);
        if (Math.floor(charge) > 0.0) {
            this.sendShieldEffect(golem, source);
            float rest = (float)(Math.floor(charge) - (double)amount);
            float chargeRest = charge - (float)Math.floor(charge);
            if (rest <= 0.0f) {
                this.setCharge(golem, chargeRest);
                return rest * -1.0f;
            }
            this.setCharge(golem, (float)Math.floor(rest) + chargeRest);
            return 0.0f;
        }
        return amount;
    }

    private void sendShieldEffect(EntityGolemBase golem, DamageSource source) {
        int target = -1;
        if (source.func_76346_g() != null) {
            target = source.func_76346_g().func_145782_y();
        } else if (source == DamageSource.field_76379_h) {
            target = -2;
        } else if (source == DamageSource.field_82729_p) {
            target = -3;
        }
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXShield(golem.func_145782_y(), target), new NetworkRegistry.TargetPoint(golem.field_70170_p.field_73011_w.field_76574_g, golem.field_70165_t, golem.field_70163_u, golem.field_70161_v, 64.0));
    }

    public float getCharge(EntityGolemBase golem) {
        float limit;
        int elapsed = golem.field_70173_aa - this.getLastDischarge(golem);
        float charge = (float)elapsed * this.getRechargeSpeed(golem);
        return charge > (limit = (float)this.getChargeLimit(golem)) ? limit : charge;
    }

    private void setCharge(EntityGolemBase golem, float charge) {
        int ticksNeeded = Math.round(charge / this.getRechargeSpeed(golem));
        this.setLastDischarge(golem, golem.field_70173_aa - ticksNeeded);
    }

    private void setLastDischarge(EntityGolemBase golem, Integer ticks) {
        golem.getEntityData().func_74768_a(LAST_DISCHARGE_TAG, ticks.intValue());
    }

    private int getLastDischarge(EntityGolemBase golem) {
        NBTTagCompound compound = golem.getEntityData();
        if (!compound.func_74764_b(LAST_DISCHARGE_TAG)) {
            compound.func_74768_a(LAST_DISCHARGE_TAG, golem.field_70173_aa);
            return golem.field_70173_aa;
        }
        return compound.func_74762_e(LAST_DISCHARGE_TAG);
    }

    private float getRechargeSpeed(EntityGolemBase golem) {
        return 0.02f;
    }

    public int getChargeLimit(EntityGolemBase golem) {
        return this.getChargeLimit(golem.getGolemType(), golem.func_110138_aP());
    }

    public int getChargeLimit(ItemStack stack) {
        EnumGolemType type = EnumGolemType.getType((int)stack.func_77960_j());
        float maxHealth = type.health;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("deco") && stack.func_77978_p().func_74779_i("deco").contains("H")) {
            maxHealth += 5.0f;
        }
        return this.getChargeLimit(type, maxHealth);
    }

    private int getChargeLimit(EnumGolemType type, float maxHealth) {
        if (type == RegisteredGolemStuff.typeSilverwood.getEnumEntry()) {
            return (int)maxHealth;
        }
        return (int)((double)maxHealth / 2.6);
    }
}

