/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs;

import cofh.api.energy.IEnergyReceiver;
import gregtech.api.GregTech_API;
import gregtech.api.graphs.GenerateNodeMap;
import gregtech.api.graphs.Node;
import gregtech.api.graphs.PowerNode;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.graphs.consumers.EmptyPowerConsumer;
import gregtech.api.graphs.consumers.NodeEnergyConnected;
import gregtech.api.graphs.consumers.NodeEnergyReceiver;
import gregtech.api.graphs.consumers.NodeEnergySink;
import gregtech.api.graphs.consumers.NodeGTBaseMetaTile;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.graphs.paths.PowerNodePath;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class GenerateNodeMapPower
extends GenerateNodeMap {
    public GenerateNodeMapPower(BaseMetaPipeEntity aTileEntity) {
        this.generateNode(aTileEntity, null, 1, null, -1, new ArrayList<ConsumerNode>(), new HashSet<Node>());
    }

    @Override
    protected boolean isPipe(TileEntity aTileEntity) {
        return super.isPipe(aTileEntity) && ((BaseMetaPipeEntity)aTileEntity).getMetaTileEntity() instanceof GT_MetaPipeEntity_Cable;
    }

    @Override
    protected boolean addConsumer(TileEntity aTileEntity, byte aSide, int aNodeValue, ArrayList<ConsumerNode> aConsumers) {
        if (aTileEntity instanceof BaseMetaTileEntity) {
            BaseMetaTileEntity tBaseTileEntity = (BaseMetaTileEntity)aTileEntity;
            if (tBaseTileEntity.inputEnergyFrom(aSide, false)) {
                NodeGTBaseMetaTile tConsumerNode = new NodeGTBaseMetaTile(aNodeValue, tBaseTileEntity, aSide, aConsumers);
                aConsumers.add(tConsumerNode);
                return true;
            }
        } else if (aTileEntity instanceof IEnergyConnected) {
            IEnergyConnected tTileEntity = (IEnergyConnected)aTileEntity;
            if (tTileEntity.inputEnergyFrom(aSide, false)) {
                NodeEnergyConnected tConsumerNode = new NodeEnergyConnected(aNodeValue, tTileEntity, aSide, aConsumers);
                aConsumers.add(tConsumerNode);
                return true;
            }
        } else if (aTileEntity instanceof IEnergySink) {
            int dX = aTileEntity.field_145851_c + ForgeDirection.getOrientation((int)aSide).offsetX;
            int dY = aTileEntity.field_145848_d + ForgeDirection.getOrientation((int)aSide).offsetY;
            int dZ = aTileEntity.field_145849_e + ForgeDirection.getOrientation((int)aSide).offsetZ;
            boolean crossesChuncks = dX >> 4 != aTileEntity.field_145851_c >> 4 || dZ >> 4 != aTileEntity.field_145849_e >> 4;
            TileEntity tNextTo = null;
            if (!crossesChuncks || !aTileEntity.func_145831_w().func_72899_e(dX, dY, dZ)) {
                tNextTo = aTileEntity.func_145831_w().func_147438_o(dX, dY, dZ);
            }
            if (((IEnergySink)aTileEntity).acceptsEnergyFrom(tNextTo, ForgeDirection.getOrientation((int)aSide))) {
                NodeEnergySink tConsumerNode = new NodeEnergySink(aNodeValue, (IEnergySink)aTileEntity, aSide, aConsumers);
                aConsumers.add(tConsumerNode);
                return true;
            }
        } else if (GregTech_API.mOutputRF && aTileEntity instanceof IEnergyReceiver) {
            NodeEnergyReceiver tConsumerNode = new NodeEnergyReceiver(aNodeValue, (IEnergyReceiver)aTileEntity, aSide, aConsumers);
            aConsumers.add(tConsumerNode);
            return true;
        }
        return false;
    }

    @Override
    protected NodePath getNewPath(MetaPipeEntity[] aPipes) {
        return new PowerNodePath(aPipes);
    }

    @Override
    protected Node getEmptyNode(int aNodeValue, byte aSide, TileEntity aTileEntity, ArrayList<ConsumerNode> aConsumers) {
        EmptyPowerConsumer tNode = new EmptyPowerConsumer(aNodeValue, aTileEntity, aSide, aConsumers);
        aConsumers.add(tNode);
        return tNode;
    }

    @Override
    protected Node getPipeNode(int aNodeValue, byte aSide, TileEntity aTileEntity, ArrayList<ConsumerNode> aConsumers) {
        return new PowerNode(aNodeValue, aTileEntity, aConsumers);
    }
}

