/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Log;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class GT_Worldgenerator
implements IWorldGenerator {
    private static int mEndAsteroidProbability = 300;
    private static int mSize = 100;
    private static int endMinSize = 50;
    private static int endMaxSize = 200;
    private static boolean endAsteroids = true;
    public static List<Runnable> mList = new ArrayList<Runnable>();
    public static HashSet<Long> ProcChunks = new HashSet();
    public static GT_Worldgen_GT_Ore_Layer noOresInVein = new GT_Worldgen_GT_Ore_Layer("NoOresInVein", false, 0, 255, 0, 255, 16, false, false, false, Materials.Aluminium, Materials.Aluminium, Materials.Aluminium, Materials.Aluminium);
    public static Hashtable<Long, GT_Worldgen_GT_Ore_Layer> validOreveins = new Hashtable(1024);
    public boolean mIsGenerating = false;
    public static final Object listLock = new Object();

    public GT_Worldgenerator() {
        endAsteroids = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "GenerateAsteroids", true);
        endMinSize = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidMinSize", 50);
        endMaxSize = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidMaxSize", 200);
        mEndAsteroidProbability = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidProbability", 300);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0x3FFFFFFF);
        if (GT_Values.debugWorldGen) {
            GT_Log.out.println("GT_Worldgenerator created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Random aRandom, int aX, int aZ, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        Object object = listLock;
        synchronized (object) {
            mList.add(new WorldGenContainer(new XSTR(Math.abs(aRandom.nextInt()) + 1), aX, aZ, aWorld.field_73011_w.field_76574_g, aWorld, aChunkGenerator, aChunkProvider, aWorld.func_72807_a((int)(aX * 16 + 8), (int)(aZ * 16 + 8)).field_76791_y));
            if (GT_Values.debugWorldGen) {
                GT_Log.out.println("ADD WorldSeed:" + aWorld.func_72905_C() + " DimId" + aWorld.field_73011_w.field_76574_g + " chunk x:" + aX + " z:" + aZ + " SIZE: " + mList.size());
            }
        }
        if (!this.mIsGenerating) {
            this.mIsGenerating = true;
            int mList_sS = mList.size();
            mList_sS = Math.min(mList_sS, 5);
            for (int i = 0; i < mList_sS; ++i) {
                WorldGenContainer toRun = (WorldGenContainer)mList.get(0);
                if (GT_Values.debugWorldGen) {
                    GT_Log.out.println("RUN WorldSeed:" + aWorld.func_72905_C() + " DimId" + aWorld.field_73011_w.field_76574_g + " chunk x:" + toRun.mX + " z:" + toRun.mZ + " SIZE: " + mList.size() + " i: " + i);
                }
                Object object2 = listLock;
                synchronized (object2) {
                    mList.remove(0);
                }
                toRun.run();
            }
            this.mIsGenerating = false;
        }
    }

    public static class WorldGenContainer
    implements Runnable {
        public final Random mRandom;
        public final int mX;
        public final int mZ;
        public final int mDimensionType;
        public final World mWorld;
        public final IChunkProvider mChunkGenerator;
        public final IChunkProvider mChunkProvider;
        public final String mBiome;
        public static ArrayList<NearbySeeds> seedList = new ArrayList();

        public WorldGenContainer(Random aRandom, int aX, int aZ, int aDimensionType, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider, String aBiome) {
            this.mRandom = aRandom;
            this.mX = aX;
            this.mZ = aZ;
            this.mDimensionType = aDimensionType;
            this.mWorld = aWorld;
            this.mChunkGenerator = aChunkGenerator;
            this.mChunkProvider = aChunkProvider;
            this.mBiome = aBiome;
        }

        public void worldGenFindVein(int oreseedX, int oreseedZ) {
            long oreveinSeed = this.mWorld.func_72905_C() << 16 ^ (((long)this.mWorld.field_73011_w.field_76574_g & 0xFFL) << 56 | ((long)oreseedX & 0xFFFFFFFL) << 28 | (long)oreseedZ & 0xFFFFFFFL);
            XSTR oreveinRNG = new XSTR(oreveinSeed);
            int oreveinPercentageRoll = oreveinRNG.nextInt(100);
            boolean noOrePlacedCount = false;
            String tDimensionName = "";
            if (GT_Values.debugOrevein) {
                tDimensionName = this.mWorld.field_73011_w.func_80007_l();
            }
            if (GT_Values.debugOrevein) {
                GT_Log.out.println(" Finding oreveins for oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " worldSeed=" + this.mWorld.func_72905_C());
            }
            if (!validOreveins.containsKey(oreveinSeed)) {
                if (oreveinPercentageRoll < GT_Values.oreveinPercentage && GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                    int i;
                    int placementAttempts = 0;
                    boolean oreveinFound = false;
                    block12: for (i = 0; i < GT_Values.oreveinAttempts && !oreveinFound && placementAttempts < GT_Values.oreveinMaxPlacementAttempts; ++i) {
                        int tRandomWeight = oreveinRNG.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                        for (GT_Worldgen_GT_Ore_Layer tWorldGen : GT_Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                            try {
                                int placementResult = tWorldGen.executeWorldgenChunkified(this.mWorld, new XSTR(oreveinSeed ^ (long)tWorldGen.mPrimaryMeta), this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, oreseedX * 16, oreseedZ * 16, this.mChunkGenerator, this.mChunkProvider);
                                switch (placementResult) {
                                    case 4: {
                                        if (GT_Values.debugOrevein) {
                                            GT_Log.out.println(" Added near oreveinSeed=" + oreveinSeed + " " + tWorldGen.mWorldGenName + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        validOreveins.put(oreveinSeed, tWorldGen);
                                        oreveinFound = true;
                                        break;
                                    }
                                    case 2: {
                                        ++placementAttempts;
                                        break;
                                    }
                                    case 3: {
                                        if (GT_Values.debugOrevein) {
                                            GT_Log.out.println(" Added far oreveinSeed=" + oreveinSeed + " " + tWorldGen.mWorldGenName + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        validOreveins.put(oreveinSeed, tWorldGen);
                                        oreveinFound = true;
                                        break;
                                    }
                                    case 5: {
                                        if (GT_Values.debugOrevein) {
                                            GT_Log.out.println(" No overlap and air block in test spot=" + oreveinSeed + " " + tWorldGen.mWorldGenName + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                                        }
                                        ++placementAttempts;
                                    }
                                }
                                continue block12;
                            }
                            catch (Throwable e) {
                                if (GT_Values.debugOrevein) {
                                    GT_Log.out.println("Exception occurred on oreVein" + tWorldGen + " oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ);
                                }
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                    if (!oreveinFound && this.mX == oreseedX && this.mZ == oreseedZ) {
                        if (GT_Values.debugOrevein) {
                            GT_Log.out.println(" Empty oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimensionName=" + tDimensionName);
                        }
                        validOreveins.put(oreveinSeed, noOresInVein);
                    }
                } else if (oreveinPercentageRoll >= GT_Values.oreveinPercentage) {
                    if (GT_Values.debugOrevein) {
                        GT_Log.out.println(" Skipped oreveinSeed=" + oreveinSeed + " mX=" + this.mX + " mZ=" + this.mZ + " oreseedX=" + oreseedX + " oreseedZ=" + oreseedZ + " RNG=" + oreveinPercentageRoll + " %=" + GT_Values.oreveinPercentage + " dimensionName=" + tDimensionName);
                    }
                    validOreveins.put(oreveinSeed, noOresInVein);
                }
            } else {
                if (GT_Values.debugOrevein) {
                    GT_Log.out.print(" Valid oreveinSeed=" + oreveinSeed + " validOreveins.size()=" + validOreveins.size() + " ");
                }
                GT_Worldgen_GT_Ore_Layer tWorldGen = validOreveins.get(oreveinSeed);
                oreveinRNG.setSeed(oreveinSeed ^ (long)tWorldGen.mPrimaryMeta);
                int placementResult = tWorldGen.executeWorldgenChunkified(this.mWorld, oreveinRNG, this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, oreseedX * 16, oreseedZ * 16, this.mChunkGenerator, this.mChunkProvider);
                switch (placementResult) {
                    case 2: {
                        if (!GT_Values.debugOrevein) break;
                        GT_Log.out.println(" No ore in bottom layer");
                        break;
                    }
                    case 3: {
                        if (!GT_Values.debugOrevein) break;
                        GT_Log.out.println(" No overlap");
                    }
                }
            }
        }

        @Override
        public void run() {
            Chunk tChunk;
            long startTime = System.nanoTime();
            try {
                for (GT_Worldgen tWorldGen : GregTech_API.sWorldgenList) {
                    tWorldGen.executeWorldgen(this.mWorld, this.mRandom, this.mBiome, this.mDimensionType, this.mX * 16, this.mZ * 16, this.mChunkGenerator, this.mChunkProvider);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            long leftOverTime = System.nanoTime();
            int oreveinMaxSize = this.mWorld.field_73011_w.func_80007_l().equals("Underdark") ? 32 : 32;
            int wXbox = this.mX - oreveinMaxSize / 16;
            int eXbox = this.mX + (oreveinMaxSize / 16 + 1);
            int nZbox = this.mZ - oreveinMaxSize / 16;
            int sZbox = this.mZ + (oreveinMaxSize / 16 + 1);
            for (int x = wXbox; x < eXbox; ++x) {
                for (int z = nZbox; z < sZbox; ++z) {
                    if (Math.abs(x) % 3 != 1 || Math.abs(z) % 3 != 1) continue;
                    if (GT_Values.debugWorldGen) {
                        GT_Log.out.println("Adding seed x=" + x + " z=" + z);
                    }
                    seedList.add(new NearbySeeds(x, z));
                }
            }
            while (seedList.size() != 0) {
                if (GT_Values.debugWorldGen) {
                    GT_Log.out.println("Processing seed x=" + WorldGenContainer.seedList.get((int)0).mX + " z=" + WorldGenContainer.seedList.get((int)0).mZ);
                }
                this.worldGenFindVein(WorldGenContainer.seedList.get((int)0).mX, WorldGenContainer.seedList.get((int)0).mZ);
                seedList.remove(0);
            }
            long oregenTime = System.nanoTime();
            int tDimensionType = this.mWorld.field_73011_w.field_76574_g;
            Random aRandom = new Random();
            if (tDimensionType == 1 && endAsteroids && (mEndAsteroidProbability <= 1 || aRandom.nextInt(mEndAsteroidProbability) == 0)) {
                short primaryMeta = 0;
                short secondaryMeta = 0;
                short betweenMeta = 0;
                short sporadicMeta = 0;
                if (GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                    boolean temp = true;
                    block8: for (int i = 0; i < GT_Values.oreveinAttempts && temp; ++i) {
                        int tRandomWeight = aRandom.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                        for (GT_Worldgen_GT_Ore_Layer tWorldGen : GT_Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                            try {
                                if (!tWorldGen.mEndAsteroid || tDimensionType != 1) continue;
                                primaryMeta = tWorldGen.mPrimaryMeta;
                                secondaryMeta = tWorldGen.mSecondaryMeta;
                                betweenMeta = tWorldGen.mBetweenMeta;
                                sporadicMeta = tWorldGen.mSporadicMeta;
                                temp = false;
                                continue block8;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                }
                int tX = this.mX * 16 + aRandom.nextInt(16);
                int tY = 50 + aRandom.nextInt(150);
                int tZ = this.mZ * 16 + aRandom.nextInt(16);
                if (tDimensionType == 1) {
                    mSize = aRandom.nextInt(endMaxSize - endMinSize);
                }
                if (this.mWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)this.mWorld, tX, tY, tZ)) {
                    float var6 = aRandom.nextFloat() * 3.141593f;
                    double var7 = (float)(tX + 8) + MathHelper.func_76126_a((float)var6) * (float)mSize / 8.0f;
                    double var9 = (float)(tX + 8) - MathHelper.func_76126_a((float)var6) * (float)mSize / 8.0f;
                    double var11 = (float)(tZ + 8) + MathHelper.func_76134_b((float)var6) * (float)mSize / 8.0f;
                    double var13 = (float)(tZ + 8) - MathHelper.func_76134_b((float)var6) * (float)mSize / 8.0f;
                    double var15 = tY + aRandom.nextInt(3) - 2;
                    double var17 = tY + aRandom.nextInt(3) - 2;
                    for (int var19 = 0; var19 <= mSize; ++var19) {
                        double var20 = var7 + (var9 - var7) * (double)var19 / (double)mSize;
                        double var22 = var15 + (var17 - var15) * (double)var19 / (double)mSize;
                        double var24 = var11 + (var13 - var11) * (double)var19 / (double)mSize;
                        double var26 = aRandom.nextDouble() * (double)mSize / 16.0;
                        double var28 = (double)(MathHelper.func_76126_a((float)((float)var19 * 3.141593f / (float)mSize)) + 1.0f) * var26 + 1.0;
                        double var30 = (double)(MathHelper.func_76126_a((float)((float)var19 * 3.141593f / (float)mSize)) + 1.0f) * var26 + 1.0;
                        int tMinX = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
                        int tMinY = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
                        int tMinZ = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
                        int tMaxX = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
                        int tMaxY = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
                        int tMaxZ = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
                        for (int eX = tMinX; eX <= tMaxX; ++eX) {
                            double var39 = ((double)eX + 0.5 - var20) / (var28 / 2.0);
                            if (!(var39 * var39 < 1.0)) continue;
                            for (int eY = tMinY; eY <= tMaxY; ++eY) {
                                double var42 = ((double)eY + 0.5 - var22) / (var30 / 2.0);
                                if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                                for (int eZ = tMinZ; eZ <= tMaxZ; ++eZ) {
                                    double var45 = ((double)eZ + 0.5 - var24) / (var28 / 2.0);
                                    if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0) || !this.mWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)this.mWorld, tX, tY, tZ)) continue;
                                    int ranOre = aRandom.nextInt(50);
                                    if (ranOre < 3) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, primaryMeta, false);
                                        continue;
                                    }
                                    if (ranOre < 6) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, secondaryMeta, false);
                                        continue;
                                    }
                                    if (ranOre < 8) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, betweenMeta, false);
                                        continue;
                                    }
                                    if (ranOre < 10) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, sporadicMeta, false);
                                        continue;
                                    }
                                    this.mWorld.func_147465_d(eX, eY, eZ, Blocks.field_150377_bs, 0, 0);
                                }
                            }
                        }
                    }
                }
            }
            if ((tChunk = this.mWorld.func_72938_d(this.mX, this.mZ)) != null) {
                tChunk.field_76643_l = true;
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            if (GT_Values.debugWorldGen) {
                GT_Log.out.println(" Oregen took " + (oregenTime - leftOverTime) + " Leftover gen took " + (leftOverTime - startTime) + " Worldgen took " + duration + " nanoseconds");
            }
        }

        class NearbySeeds {
            public int mX;
            public int mZ;

            NearbySeeds(int x, int z) {
                this.mX = x;
                this.mZ = z;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof NearbySeeds)) {
                    return false;
                }
                NearbySeeds that = (NearbySeeds)o;
                if (this.mX != that.mX) {
                    return false;
                }
                return this.mZ == that.mZ;
            }

            public int hashCode() {
                int result = this.mX;
                result = 31 * result + this.mZ;
                return result;
            }
        }
    }
}

