/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.IGuiScreen;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_WirelessRedstoneCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_Cover_RedstoneWirelessBase
extends GT_CoverBehavior {
    private static final int MAX_CHANNEL = 65535;
    private static final int PRIVATE_MASK = -131072;
    private static final int PUBLIC_MASK = 65535;
    private static final int CHECKBOX_MASK = 65536;

    @Override
    public boolean onCoverRemoval(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        GregTech_API.sWirelessRedstone.put(aCoverVariable, (byte)0);
        return true;
    }

    @Override
    protected boolean onCoverRightClickImpl(byte aSide, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || aSide > 3 && (double)aY > 0.375 && (double)aY < 0.625) {
            GregTech_API.sWirelessRedstone.put(aCoverVariable.get(), (byte)0);
            aCoverVariable.set(aCoverVariable.get() & 0xFFFF0000 | Integer.valueOf(GT_Utility.stackToInt(aPlayer.field_71071_by.func_70448_g())).hashCode() & 0xFFFF);
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("081", "Frequency: ") + aCoverVariable);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || aSide > 3 && (double)aY > 0.375 && (double)aY < 0.625) {
            GregTech_API.sWirelessRedstone.put(aCoverVariable, (byte)0);
            int val = GT_Utility.stackToInt(aPlayer.field_71071_by.func_70448_g()) * (1 + aPlayer.field_71071_by.func_70448_g().func_77960_j());
            aCoverVariable = aCoverVariable & 0xFFFF0000 | val & 0xFFFF;
            aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("081", "Frequency: ") + (aCoverVariable & 0xFFFF));
            return true;
        }
        return false;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || aSide <= 3 || (double)aY > 0.375 && (double)aY < 0.625 || (double)aZ <= 0.375 || (double)aZ >= 0.625) {
            GregTech_API.sWirelessRedstone.put(aCoverVariable, (byte)0);
            float[] tCoords = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ);
            int tAdjustVal = 0;
            switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                case 0: {
                    tAdjustVal = -32;
                    break;
                }
                case 1: {
                    tAdjustVal = 32;
                    break;
                }
                case 2: {
                    tAdjustVal = -1024;
                    break;
                }
                case 3: {
                    tAdjustVal = 1024;
                }
            }
            int tPublicChannel = (aCoverVariable & 0xFFFF) + tAdjustVal;
            aCoverVariable = tPublicChannel < 0 ? (aCoverVariable &= 0xFFFF0000) : (tPublicChannel > 65535 ? aCoverVariable & 0xFFFF0000 | 0xFFFF : aCoverVariable & 0xFFFF0000 | tPublicChannel);
        }
        GT_Utility.sendChatToPlayer(aPlayer, this.trans("081", "Frequency: ") + (aCoverVariable & 0xFFFF));
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public String getDescription(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return this.trans("081", "Frequency: ") + aCoverVariable;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private GT_GuiIntegerTextBox fBox;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.fBox = new GT_GuiShortTextBox(this, 2, 10, 27, 69, 12);
            this.fBox.func_146180_a(String.valueOf(this.coverVariable & 0xFFFF));
            this.fBox.func_146203_f(12);
            GT_GuiIconCheckButton b = new GT_GuiIconCheckButton(this, 0, 10, 61, GT_GuiIcon.CHECKMARK, null);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().func_78276_b(GT_Cover_RedstoneWirelessBase.this.trans("246", "Frequency"), 82, 29, -11184811);
            this.getFontRenderer().func_78276_b(GT_Cover_RedstoneWirelessBase.this.trans("601", "Use Private Frequency"), 28, 65, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.fBox.func_146195_b(true);
            ((GT_GuiIconCheckButton)this.field_146292_n.get(0)).setChecked((this.coverVariable & 0x10000) > 0);
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            for (GT_GuiIntegerTextBox box : this.textBoxes) {
                long tCoverVariable;
                if (!box.func_146206_l()) continue;
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.func_146272_n() ? 1000 : (GUI.func_146271_m() ? 50 : 1)) * (delta > 0 ? step : -step);
                try {
                    tCoverVariable = Long.parseLong(box.func_146179_b());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if ((tCoverVariable += (long)step) > 65535L) {
                    tCoverVariable = 65535L;
                } else if (tCoverVariable < 0L) {
                    tCoverVariable = 0L;
                }
                box.func_146180_a(String.valueOf(tCoverVariable));
                return;
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            int tPublicChannel;
            String s = box.func_146179_b().trim();
            try {
                tPublicChannel = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.resetTextBox(box);
                return;
            }
            if (tPublicChannel > 65535) {
                tPublicChannel = 65535;
            } else if (tPublicChannel < 0) {
                tPublicChannel = 0;
            }
            int tCheckBoxValue = ((GT_GuiIconCheckButton)this.field_146292_n.get(0)).isChecked() ? 65536 : 0;
            this.coverVariable = tCheckBoxValue | tPublicChannel;
            this.fBox.func_146180_a(Integer.toString(tPublicChannel));
            GT_Values.NW.sendToServer(new GT_Packet_WirelessRedstoneCover(this.side, this.coverID, this.tile, tPublicChannel, tCheckBoxValue));
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            box.func_146180_a(String.valueOf(this.coverVariable & 0xFFFF));
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            GT_GuiIconCheckButton tBtn;
            tBtn.setChecked(!(tBtn = (GT_GuiIconCheckButton)btn).isChecked());
            int tPublicChannel = 0;
            String tText = this.fBox.func_146179_b().trim();
            if (tText.length() > 0) {
                tPublicChannel = Integer.parseInt(tText);
            }
            int tCheckBoxValue = tBtn.isChecked() ? 65536 : 0;
            this.coverVariable = tCheckBoxValue | tPublicChannel;
            GT_Values.NW.sendToServer(new GT_Packet_WirelessRedstoneCover(this.side, this.coverID, this.tile, tPublicChannel, tCheckBoxValue));
        }

        private class GT_GuiShortTextBox
        extends GT_GuiIntegerTextBox {
            public GT_GuiShortTextBox(IGuiScreen gui, int id, int x, int y, int width, int height) {
                super(gui, id, x, y, width, height);
            }

            @Override
            public boolean func_146201_a(char c, int key) {
                int tValue = 0;
                if (!super.func_146201_a(c, key)) {
                    return false;
                }
                int cursorPos = this.func_146198_h();
                String tText = this.func_146179_b().trim();
                if (tText.length() > 0) {
                    try {
                        tValue = Integer.parseInt(tText);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (tValue > 65535) {
                        this.func_146180_a(String.valueOf(65535));
                    } else {
                        this.func_146180_a(String.valueOf(tValue));
                    }
                    this.func_146190_e(cursorPos);
                }
                return true;
            }
        }
    }
}

