/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.GT_GUIDialogSelectItem;
import gregtech.api.interfaces.INetworkUpdatableItem;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.net.GT_Packet_UpdateItem;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.commons.lang3.tuple.Pair;

public class GT_IntegratedCircuit_Item
extends GT_Generic_Item
implements INetworkUpdatableItem {
    private static final String aTextEmptyRow = "   ";
    private static final List<ItemStack> ALL_VARIANTS = new ArrayList<ItemStack>();
    protected IIcon[] mIconDamage = new IIcon[25];

    public GT_IntegratedCircuit_Item() {
        super("integrated_circuit", "Programmed Circuit", "");
        this.func_77627_a(true);
        this.func_77656_e(0);
        ItemList.Circuit_Integrated.set(this);
        ALL_VARIANTS.add(new ItemStack((Item)this, 0, 0));
        for (int i = 1; i <= 24; ++i) {
            ItemStack aStack = new ItemStack((Item)this, 0, i);
            GregTech_API.registerConfigurationCircuit(aStack, 1);
            ALL_VARIANTS.add(aStack);
        }
        GT_ModHandler.addShapelessCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 0L, new Object[0]), GT_ModHandler.RecipeBits.NOT_REMOVABLE, new Object[]{OrePrefixes.circuit.get(Materials.Basic)});
        long bits = GT_ModHandler.RecipeBits.BUFFERED | GT_ModHandler.RecipeBits.NOT_REMOVABLE;
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 1L, new Object[0]), bits, new Object[]{"d  ", " P ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 2L, new Object[0]), bits, new Object[]{" d ", " P ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 3L, new Object[0]), bits, new Object[]{"  d", " P ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 4L, new Object[0]), bits, new Object[]{aTextEmptyRow, " Pd", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 5L, new Object[0]), bits, new Object[]{aTextEmptyRow, " P ", "  d", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 6L, new Object[0]), bits, new Object[]{aTextEmptyRow, " P ", " d ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 7L, new Object[0]), bits, new Object[]{aTextEmptyRow, " P ", "d  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 8L, new Object[0]), bits, new Object[]{aTextEmptyRow, "dP ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 9L, new Object[0]), bits, new Object[]{"P d", aTextEmptyRow, aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 10L, new Object[0]), bits, new Object[]{"P  ", "  d", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 11L, new Object[0]), bits, new Object[]{"P  ", aTextEmptyRow, "  d", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 12L, new Object[0]), bits, new Object[]{"P  ", aTextEmptyRow, " d ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 13L, new Object[0]), bits, new Object[]{"  P", aTextEmptyRow, "  d", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 14L, new Object[0]), bits, new Object[]{"  P", aTextEmptyRow, " d ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 15L, new Object[0]), bits, new Object[]{"  P", aTextEmptyRow, "d  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 16L, new Object[0]), bits, new Object[]{"  P", "d  ", aTextEmptyRow, Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 17L, new Object[0]), bits, new Object[]{aTextEmptyRow, aTextEmptyRow, "d P", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 18L, new Object[0]), bits, new Object[]{aTextEmptyRow, "d  ", "  P", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 19L, new Object[0]), bits, new Object[]{"d  ", aTextEmptyRow, "  P", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 20L, new Object[0]), bits, new Object[]{" d ", aTextEmptyRow, "  P", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 21L, new Object[0]), bits, new Object[]{"d  ", aTextEmptyRow, "P  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 22L, new Object[0]), bits, new Object[]{" d ", aTextEmptyRow, "P  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 23L, new Object[0]), bits, new Object[]{"  d", aTextEmptyRow, "P  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Circuit_Integrated.getWithDamage(1L, 24L, new Object[0]), bits, new Object[]{aTextEmptyRow, "  d", "P  ", Character.valueOf('P'), ItemList.Circuit_Integrated.getWildcard(1L, new Object[0])});
    }

    private static String getModeString(int aMetaData) {
        switch ((byte)(aMetaData >>> 8)) {
            case 0: {
                return "==";
            }
            case 1: {
                return "<=";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<";
            }
            case 4: {
                return ">";
            }
        }
        return "";
    }

    private static String getConfigurationString(int aMetaData) {
        return GT_IntegratedCircuit_Item.getModeString(aMetaData) + " " + (byte)(aMetaData & 0xFF);
    }

    @Override
    public void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
        super.addAdditionalToolTips(aList, aStack, aPlayer);
        aList.add(GT_LanguageManager.addStringLocalization(this.func_77658_a() + ".configuration", "Configuration: ") + GT_IntegratedCircuit_Item.getConfigurationString(this.getDamage(aStack)));
        aList.add(GT_LanguageManager.addStringLocalization(this.func_77658_a() + ".tooltip.0", "Right click to reconfigure"));
        aList.add(GT_LanguageManager.addStringLocalization(this.func_77658_a() + ".tooltip.1", "Needs a screwdriver or circuit programming tool"));
    }

    @Override
    public String func_77667_c(ItemStack aStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        aList.add(new ItemStack((Item)this, 1, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        super.func_94581_a(aIconRegister);
        for (int i = 0; i < this.mIconDamage.length; ++i) {
            this.mIconDamage[i] = aIconRegister.func_94245_a("gregtech:" + (GT_Config.troll ? "troll" : this.func_77658_a() + "/" + i));
        }
        if (GregTech_API.sPostloadFinished) {
            GT_Log.out.println("GT_Mod: Starting Item Icon Load Phase");
            GT_Mod.GT_FML_LOGGER.info("GT_Mod: Starting Item Icon Load Phase");
            GregTech_API.sItemIcons = aIconRegister;
            try {
                for (Runnable tRunnable : GregTech_API.sGTItemIconload) {
                    tRunnable.run();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            GT_Log.out.println("GT_Mod: Finished Item Icon Load Phase");
            GT_Mod.GT_FML_LOGGER.info("GT_Mod: Finished Item Icon Load Phase");
        }
    }

    @Override
    public IIcon func_77617_a(int damage) {
        byte circuitMode = (byte)(damage & 0xFF);
        return this.mIconDamage[circuitMode < this.mIconDamage.length ? circuitMode : (byte)0];
    }

    @Override
    public boolean receive(ItemStack stack, EntityPlayerMP player, NBTTagCompound tag) {
        int meta;
        int n = meta = tag.func_150297_b("meta", 1) ? (int)tag.func_74771_c("meta") : -1;
        if (meta < 0 || meta > 24) {
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> toolIndex = GT_IntegratedCircuit_Item.findConfiguratorInInv((EntityPlayer)player);
            if (toolIndex == null) {
                return true;
            }
            ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
            mainInventory[((Integer)toolIndex.getKey()).intValue()] = (ItemStack)((BiFunction)toolIndex.getValue()).apply(mainInventory[(Integer)toolIndex.getKey()], player);
        }
        stack.func_77964_b(meta);
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        ItemStack configuratorStack;
        if (player instanceof FakePlayer || !world.field_72995_K) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            configuratorStack = null;
        } else {
            Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> configurator = GT_IntegratedCircuit_Item.findConfiguratorInInv(player);
            if (configurator == null) {
                int count;
                try {
                    count = Integer.parseInt(StatCollector.func_74838_a((String)"GT5U.item.programmed_circuit.no_screwdriver.count"));
                }
                catch (NumberFormatException e) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Error in translation GT5U.item.programmed_circuit.no_screwdriver.count: " + e.getMessage()));
                    count = 1;
                }
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.item.programmed_circuit.no_screwdriver." + XSTR.XSTR_INSTANCE.nextInt(count), new Object[0]));
                return false;
            }
            configuratorStack = player.field_71071_by.field_70462_a[(Integer)configurator.getKey()];
        }
        this.openSelectorGui(configuratorStack, stack.func_77960_j());
        return true;
    }

    private void openSelectorGui(ItemStack configurator, int meta) {
        FMLCommonHandler.instance().showGuiScreen((Object)new GT_GUIDialogSelectItem(StatCollector.func_74838_a((String)"GT5U.item.programmed_circuit.select.header"), configurator, null, GT_IntegratedCircuit_Item::onConfigured, ALL_VARIANTS, meta, true));
    }

    private static void onConfigured(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("meta", (byte)stack.func_77960_j());
        GT_Values.NW.sendToServer(new GT_Packet_UpdateItem(tag));
    }

    private static Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> findConfiguratorInInv(EntityPlayer player) {
        ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
        int mainInventoryLength = mainInventory.length;
        for (int j = 0; j < mainInventoryLength; ++j) {
            ItemStack toolStack = mainInventory[j];
            if (!GT_Utility.isStackValid(toolStack)) continue;
            for (Map.Entry<Predicate<ItemStack>, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> p : GregTech_API.sCircuitProgrammerList.entrySet()) {
                if (!p.getKey().test(toolStack)) continue;
                return Pair.of((Object)j, p.getValue());
            }
        }
        return null;
    }
}

