/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.GT_ChunkManager;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_OreDrillingPlantBase
extends GT_MetaTileEntity_DrillerBase {
    private final ArrayList<ChunkPosition> oreBlockPositions = new ArrayList();
    protected int mTier = 1;
    private int chunkRadiusConfig = this.getRadiusInChunks();

    GT_MetaTileEntity_OreDrillingPlantBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    GT_MetaTileEntity_OreDrillingPlantBase(String aName) {
        super(aName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("chunkRadiusConfig", this.chunkRadiusConfig);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("chunkRadiusConfig")) {
            this.chunkRadiusConfig = aNBT.func_74762_e("chunkRadiusConfig");
        }
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "OreDrillingPlant.png");
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        if (aPlayer.func_70093_af()) {
            if (this.chunkRadiusConfig > 0) {
                --this.chunkRadiusConfig;
            }
            if (this.chunkRadiusConfig == 0) {
                this.chunkRadiusConfig = this.getRadiusInChunks();
            }
        } else {
            if (this.chunkRadiusConfig <= this.getRadiusInChunks()) {
                ++this.chunkRadiusConfig;
            }
            if (this.chunkRadiusConfig > this.getRadiusInChunks()) {
                this.chunkRadiusConfig = 1;
            }
        }
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.workareaset") + " " + (this.chunkRadiusConfig << 4) + " " + StatCollector.func_74838_a((String)"GT5U.machines.radius"));
    }

    @Override
    protected boolean workingDownward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (yHead != oldYHead) {
            this.oreBlockPositions.clear();
        }
        if (this.mWorkChunkNeedsReload && this.mChunkLoadingEnabled) {
            GT_ChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), null);
            this.mWorkChunkNeedsReload = false;
        }
        this.fillMineListIfEmpty(xDrill, yDrill, zDrill, xPipe, zPipe, yHead);
        if (this.oreBlockPositions.isEmpty()) {
            switch (this.tryLowerPipeState()) {
                case 2: {
                    this.mMaxProgresstime = 0;
                    return false;
                }
                case 3: {
                    this.workState = 2;
                    return true;
                }
                case 1: {
                    this.workState = 1;
                    return true;
                }
            }
            this.fillMineListIfEmpty(xDrill, yDrill, zDrill, xPipe, zPipe, yHead);
        }
        return this.processOreList();
    }

    private boolean processOreList() {
        ChunkPosition oreBlockPos = null;
        int x = 0;
        int y = 0;
        int z = 0;
        Block oreBlock = null;
        int oreBlockMetadata = 0;
        while (!(oreBlock != null && GT_Utility.isOre(oreBlock, oreBlockMetadata) || this.oreBlockPositions.isEmpty())) {
            oreBlockPos = this.oreBlockPositions.remove(0);
            x = oreBlockPos.field_151329_a;
            y = oreBlockPos.field_151327_b;
            z = oreBlockPos.field_151328_c;
            if (GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), x, y, z, true)) {
                oreBlock = this.getBaseMetaTileEntity().getBlock(x, y, z);
            }
            oreBlockMetadata = this.getBaseMetaTileEntity().getWorld().func_72805_g(x, y, z);
        }
        if (!this.tryConsumeDrillingFluid()) {
            this.oreBlockPositions.add(0, oreBlockPos);
            return false;
        }
        if (oreBlock != null && GT_Utility.isOre(oreBlock, oreBlockMetadata)) {
            short metaData = 0;
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntity(x, y, z);
            if (tTileEntity instanceof GT_TileEntity_Ores) {
                metaData = ((GT_TileEntity_Ores)tTileEntity).mMetaData;
            }
            Collection<ItemStack> oreBlockDrops = this.getBlockDrops(oreBlock, x, y, z);
            ItemStack cobble = GT_Utility.getCobbleForOre(oreBlock, metaData);
            this.getBaseMetaTileEntity().getWorld().func_147465_d(x, y, z, Block.func_149634_a((Item)cobble.func_77973_b()), cobble.func_77960_j(), 3);
            this.mOutputItems = this.getOutputByDrops(oreBlockDrops);
        }
        return true;
    }

    @Override
    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (!this.mChunkLoadingEnabled) {
            return super.workingAtBottom(aStack, xDrill, yDrill, zDrill, xPipe, zPipe, yHead, oldYHead);
        }
        if (this.mCurrentChunk == null) {
            this.createInitialWorkingChunk();
            return true;
        }
        if (this.mWorkChunkNeedsReload) {
            GT_ChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
            this.mWorkChunkNeedsReload = false;
            return true;
        }
        if (this.oreBlockPositions.isEmpty()) {
            this.fillChunkMineList(yHead, yDrill);
            if (this.oreBlockPositions.isEmpty()) {
                GT_ChunkManager.releaseChunk((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
                if (!this.moveToNextChunk(xDrill >> 4, zDrill >> 4)) {
                    this.workState = 2;
                }
                return true;
            }
        }
        return this.processOreList();
    }

    private void createInitialWorkingChunk() {
        int centerX = this.getXDrill() >> 4;
        int centerZ = this.getZDrill() >> 4;
        int leftRight = this.getXDrill() - (centerX << 4) < 8 ? 0 : 1;
        int topBottom = this.getZDrill() - (centerZ << 4) < 8 ? 0 : 1;
        this.mCurrentChunk = new ChunkCoordIntPair(centerX - this.chunkRadiusConfig + leftRight, centerZ - this.chunkRadiusConfig + topBottom);
        GT_ChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
        this.mWorkChunkNeedsReload = false;
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (!this.mChunkLoadingEnabled || this.oreBlockPositions.isEmpty()) {
            return super.workingUpward(aStack, xDrill, yDrill, zDrill, xPipe, zPipe, yHead, oldYHead);
        }
        boolean result = this.processOreList();
        if (this.oreBlockPositions.isEmpty()) {
            GT_ChunkManager.releaseTicket((TileEntity)this.getBaseMetaTileEntity());
        }
        return result;
    }

    private boolean moveToNextChunk(int centerX, int centerZ) {
        if (this.mCurrentChunk == null) {
            return false;
        }
        int left = centerX - this.chunkRadiusConfig + (this.getXDrill() - (centerX << 4) < 8 ? 0 : 1);
        int right = left + this.chunkRadiusConfig * 2;
        int bottom = centerZ + this.chunkRadiusConfig + (this.getZDrill() - (centerZ << 4) < 8 ? 0 : 1);
        int nextChunkX = this.mCurrentChunk.field_77276_a + 1;
        int nextChunkZ = this.mCurrentChunk.field_77275_b;
        if (nextChunkX >= right) {
            nextChunkX = left;
            ++nextChunkZ;
        }
        if (nextChunkX == centerX && nextChunkZ == centerZ && ++nextChunkX >= right) {
            nextChunkX = left;
            ++nextChunkZ;
        }
        if (nextChunkZ >= bottom) {
            this.mCurrentChunk = null;
            return false;
        }
        this.mCurrentChunk = new ChunkCoordIntPair(nextChunkX, nextChunkZ);
        GT_ChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), new ChunkCoordIntPair(nextChunkX, nextChunkZ));
        return true;
    }

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mInputHatches.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -3 * (1 << (tier << 1));
        this.mMaxProgresstime = (this.workState == 0 || this.workState == 1 ? this.getBaseProgressTime() : 80) / (1 << tier);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
    }

    private ItemStack[] getOutputByDrops(Collection<ItemStack> oreBlockDrops) {
        long voltage = this.getMaxInputVoltage();
        HashSet outputItems = new HashSet();
        oreBlockDrops.forEach(currentItem -> {
            if (!this.doUseMaceratorRecipe((ItemStack)currentItem)) {
                outputItems.add(this.multiplyStackSize((ItemStack)currentItem));
                return;
            }
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, voltage, null, (ItemStack)currentItem);
            if (tRecipe == null) {
                outputItems.add(currentItem);
                return;
            }
            for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
                ItemStack recipeOutput = tRecipe.mOutputs[i].func_77946_l();
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) < tRecipe.getOutputChance(i)) {
                    this.multiplyStackSize(recipeOutput);
                }
                outputItems.add(recipeOutput);
            }
        });
        return outputItems.toArray(new ItemStack[0]);
    }

    private boolean doUseMaceratorRecipe(ItemStack currentItem) {
        ItemData itemData = GT_OreDictUnificator.getItemData(currentItem);
        return itemData == null || itemData.mPrefix != OrePrefixes.crushed && itemData.mPrefix != OrePrefixes.dustImpure && itemData.mPrefix != OrePrefixes.dust && itemData.mMaterial.mMaterial != Materials.Oilsands;
    }

    private ItemStack multiplyStackSize(ItemStack itemStack) {
        itemStack.field_77994_a *= this.getBaseMetaTileEntity().getRandomNumber(4) + 1;
        return itemStack;
    }

    private Collection<ItemStack> getBlockDrops(Block oreBlock, int posX, int posY, int posZ) {
        byte blockMeta = this.getBaseMetaTileEntity().getMetaID(posX, posY, posZ);
        if (oreBlock.canSilkHarvest(this.getBaseMetaTileEntity().getWorld(), null, posX, posY, posZ, (int)blockMeta)) {
            return Collections.singleton(new ItemStack(oreBlock, 1, (int)blockMeta));
        }
        return oreBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), posX, posY, posZ, (int)blockMeta, this.mTier + 3);
    }

    private boolean tryConsumeDrillingFluid() {
        if (!this.depleteInput(new FluidStack(ItemList.sDrillingFluid, 2000))) {
            this.mMaxProgresstime = 0;
            return false;
        }
        return true;
    }

    private void fillChunkMineList(int yHead, int yDrill) {
        if (this.mCurrentChunk == null || !this.oreBlockPositions.isEmpty()) {
            return;
        }
        int minX = this.mCurrentChunk.field_77276_a << 4;
        int maxX = minX + 16;
        int minZ = this.mCurrentChunk.field_77275_b << 4;
        int maxZ = minZ + 16;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = yHead; y < yDrill; ++y) {
                    this.tryAddOreBlockToMineList(x, y, z);
                }
            }
        }
    }

    private void fillMineListIfEmpty(int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead) {
        if (!this.oreBlockPositions.isEmpty()) {
            return;
        }
        this.tryAddOreBlockToMineList(xPipe, yHead - 1, zPipe);
        if (yHead == yDrill) {
            return;
        }
        if (this.mChunkLoadingEnabled) {
            int startX = xDrill >> 4 << 4;
            int startZ = zDrill >> 4 << 4;
            for (int x = startX; x < startX + 16; ++x) {
                for (int z = startZ; z < startZ + 16; ++z) {
                    this.tryAddOreBlockToMineList(x, yHead, z);
                }
            }
        } else {
            int radius = this.chunkRadiusConfig << 4;
            for (int xOff = -radius; xOff <= radius; ++xOff) {
                for (int zOff = -radius; zOff <= radius; ++zOff) {
                    this.tryAddOreBlockToMineList(xDrill + xOff, yHead, zDrill + zOff);
                }
            }
        }
    }

    private void tryAddOreBlockToMineList(int x, int y, int z) {
        Block block = this.getBaseMetaTileEntity().getBlock(x, y, z);
        byte blockMeta = this.getBaseMetaTileEntity().getMetaID(x, y, z);
        ChunkPosition blockPos = new ChunkPosition(x, y, z);
        if (!this.oreBlockPositions.contains(blockPos)) {
            if (block instanceof GT_Block_Ores_Abstract) {
                TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntity(x, y, z);
                if (tTileEntity instanceof GT_TileEntity_Ores && ((GT_TileEntity_Ores)tTileEntity).mNatural) {
                    this.oreBlockPositions.add(blockPos);
                }
            } else if (GT_Utility.isOre(block, blockMeta)) {
                this.oreBlockPositions.add(blockPos);
            }
        }
    }

    protected abstract int getRadiusInChunks();

    protected abstract int getBaseProgressTime();

    protected GT_Multiblock_Tooltip_Builder createTooltip(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Miner").addInfo("Controller Block for the Ore Drilling Plant " + (tierSuffix != null ? tierSuffix : "")).addInfo("Use a Screwdriver to configure block radius").addInfo("Maximum radius is " + (this.getRadiusInChunks() << 4) + " blocks").addInfo("Use Soldering iron to turn off chunk mode").addInfo("In chunk mode, working area center is the chunk corner nearest to the drill").addInfo("Gives ~3x as much crushed ore vs normal processing").addInfo("Fortune bonus of " + (this.mTier + 3) + ". Only works on small ores").addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addStructureInfo(casings + " form the 3x1x3 Base").addOtherStructurePart(casings, " 1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GT_Values.VN[this.getMinTier()] + "+, Any base casing", 1).addMaintenanceHatch("Any base casing", 1).addInputBus("Mining Pipes, optional, any base casing", 1).addInputHatch("Drilling Fluid, any base casing", 1).addOutputBus("Any base casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public String[] getInfoData() {
        int diameter = this.chunkRadiusConfig * 2;
        return new String[]{EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.minermulti") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + diameter + "x" + diameter + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.chunks")};
    }
}

